/*
 * Decompiled with CFR 0.152.
 */
package com.kittehmod.ceilands.neoforge.worldgen.features.trunkplacers;

import com.google.common.collect.ImmutableList;
import com.kittehmod.ceilands.neoforge.registry.CeilandsTrunkPlacerType;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class CeiltrunkTrunkPlacer
extends TrunkPlacer {
    public static final MapCodec<CeiltrunkTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(func -> CeiltrunkTrunkPlacer.trunkPlacerParts((RecordCodecBuilder.Instance)func).apply((Applicative)func, CeiltrunkTrunkPlacer::new));

    public CeiltrunkTrunkPlacer(int p_70268_, int p_70269_, int p_70270_) {
        super(p_70268_, p_70269_, p_70270_);
    }

    protected TrunkPlacerType<?> type() {
        return CeilandsTrunkPlacerType.CEILTRUNK_TRUNK_PLACER;
    }

    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader reader, BiConsumer<BlockPos, BlockState> consumer, RandomSource random, int height, BlockPos pos, TreeConfiguration config) {
        if (reader.isStateAtPosition(pos.above(), blockstate -> blockstate.getBlock() != Blocks.GRASS_BLOCK)) {
            CeiltrunkTrunkPlacer.setDirtAt((LevelSimulatedReader)reader, consumer, (RandomSource)random, (BlockPos)pos.above(), (TreeConfiguration)config);
        }
        int logPlacedCount = 0;
        for (int i = 0; i < height; ++i) {
            if (!this.placeLog(reader, consumer, random, pos.below(i), config)) continue;
            ++logPlacedCount;
        }
        return logPlacedCount > 0 ? ImmutableList.of((Object)new FoliagePlacer.FoliageAttachment(pos.below(height - 2), 1, false)) : ImmutableList.of();
    }
}

