/*
 * Decompiled with CFR 0.152.
 */
package com.kittehmod.ceilands.neoforge.worldgen.features.trees;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.rootplacers.RootPlacer;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.shapes.BitSetDiscreteVoxelShape;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;

public class CeiltrunkTreeFeature
extends Feature<TreeConfiguration> {
    public CeiltrunkTreeFeature(Codec<TreeConfiguration> codecIn) {
        super(codecIn);
    }

    public static boolean isFree(LevelSimulatedReader level, BlockPos pos) {
        return CeiltrunkTreeFeature.validTreePos(level, pos) || level.isStateAtPosition(pos, state -> state.is(BlockTags.LOGS));
    }

    private static boolean isVine(LevelSimulatedReader level, BlockPos pos) {
        return level.isStateAtPosition(pos, state -> state.is(Blocks.VINE));
    }

    private static boolean isBlockWater(LevelSimulatedReader level, BlockPos pos) {
        return level.isStateAtPosition(pos, state -> state.is(Blocks.WATER));
    }

    public static boolean isAirOrLeaves(LevelSimulatedReader level, BlockPos pos) {
        return level.isStateAtPosition(pos, state -> state.isAir() || state.is(BlockTags.LEAVES));
    }

    private static boolean isReplaceablePlant(LevelSimulatedReader level, BlockPos pos) {
        return level.isStateAtPosition(pos, blockstate -> blockstate.canBeReplaced());
    }

    public static void setBlockKnownShape(LevelWriter p_236408_0_, BlockPos p_236408_1_, BlockState p_236408_2_) {
        p_236408_0_.setBlock(p_236408_1_, p_236408_2_, 19);
    }

    public static boolean validTreePos(LevelSimulatedReader level, BlockPos pos) {
        return CeiltrunkTreeFeature.isAirOrLeaves(level, pos) || CeiltrunkTreeFeature.isReplaceablePlant(level, pos) || CeiltrunkTreeFeature.isBlockWater(level, pos);
    }

    private boolean doPlace(WorldGenLevel level, RandomSource source, BlockPos pos, BiConsumer<BlockPos, BlockState> consumer1, BiConsumer<BlockPos, BlockState> consumer2, FoliagePlacer.FoliageSetter foliage, TreeConfiguration config) {
        int trunkHeight = config.trunkPlacer.getTreeHeight(source);
        int foliageHeight = config.foliagePlacer.foliageHeight(source, trunkHeight, config);
        int k = trunkHeight + foliageHeight;
        int l = config.foliagePlacer.foliageRadius(source, k);
        BlockPos blockpos = config.rootPlacer.map(rootplacer -> rootplacer.getTrunkOrigin(pos, source)).orElse(pos);
        int i1 = Math.min(pos.getY(), blockpos.getY());
        int j1 = Math.max(pos.getY(), blockpos.getY()) + trunkHeight + 1;
        if (!CeiltrunkTreeFeature.isFree((LevelSimulatedReader)level, pos.below())) {
            return false;
        }
        if (i1 >= level.getMinBuildHeight() + 1 && j1 <= level.getMaxBuildHeight()) {
            OptionalInt optionalint = config.minimumSize.minClippedHeight();
            int k1 = this.getMaxFreeTreeHeight((LevelSimulatedReader)level, trunkHeight, blockpos, config);
            if (k1 >= -trunkHeight || !optionalint.isEmpty() && k1 >= optionalint.getAsInt()) {
                if (config.rootPlacer.isPresent() && !((RootPlacer)config.rootPlacer.get()).placeRoots((LevelSimulatedReader)level, consumer1, source, pos, blockpos, config)) {
                    return false;
                }
                List list = config.trunkPlacer.placeTrunk((LevelSimulatedReader)level, consumer2, source, k1, blockpos, config);
                list.forEach(p_225279_ -> config.foliagePlacer.createFoliage((LevelSimulatedReader)level, foliage, source, config, k1, p_225279_, foliageHeight, l));
                return true;
            }
            return false;
        }
        return false;
    }

    private int getMaxFreeTreeHeight(LevelSimulatedReader reader, int height, BlockPos pos, TreeConfiguration config) {
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        for (int i = 0; i <= height + 1; ++i) {
            int j = config.minimumSize.getSizeAtHeight(height, -i);
            for (int k = -j; k <= j; ++k) {
                for (int l = -j; l <= j; ++l) {
                    blockpos$mutable.setWithOffset((Vec3i)pos, k, -i, l);
                    if (CeiltrunkTreeFeature.isFree(reader, (BlockPos)blockpos$mutable) && (config.ignoreVines || !CeiltrunkTreeFeature.isVine(reader, (BlockPos)blockpos$mutable))) continue;
                    return i - 2;
                }
            }
        }
        return height;
    }

    public final boolean place(FeaturePlaceContext<TreeConfiguration> placeContxt) {
        final WorldGenLevel worldgenlevel = placeContxt.level();
        RandomSource randomsource = placeContxt.random();
        BlockPos blockpos = placeContxt.origin();
        TreeConfiguration treeconfiguration = (TreeConfiguration)placeContxt.config();
        HashSet set = Sets.newHashSet();
        HashSet set1 = Sets.newHashSet();
        final HashSet set2 = Sets.newHashSet();
        HashSet set3 = Sets.newHashSet();
        BiConsumer<BlockPos, BlockState> biconsumer = (pos, state) -> {
            set.add(pos.immutable());
            worldgenlevel.setBlock(pos, state, 19);
        };
        BiConsumer<BlockPos, BlockState> biconsumer1 = (pos, state) -> {
            set1.add(pos.immutable());
            worldgenlevel.setBlock(pos, state, 19);
        };
        FoliagePlacer.FoliageSetter foliage = new FoliagePlacer.FoliageSetter(){

            public void set(BlockPos pos, BlockState state) {
                set2.add(pos.immutable());
                worldgenlevel.setBlock(pos, state, 19);
            }

            public boolean isSet(BlockPos state) {
                return set2.contains(state);
            }
        };
        BiConsumer<BlockPos, BlockState> biconsumer3 = (pos, state) -> {
            set3.add(pos.immutable());
            worldgenlevel.setBlock(pos, state, 19);
        };
        boolean flag = this.doPlace(worldgenlevel, randomsource, blockpos, biconsumer, biconsumer1, foliage, treeconfiguration);
        if (!(!flag || set1.isEmpty() && set2.isEmpty())) {
            if (!treeconfiguration.decorators.isEmpty()) {
                TreeDecorator.Context treedecorator$context = new TreeDecorator.Context((LevelSimulatedReader)worldgenlevel, biconsumer3, randomsource, (Set)set1, (Set)set2, (Set)set);
                treeconfiguration.decorators.forEach(p_160528_ -> p_160528_.place(treedecorator$context));
            }
            return BoundingBox.encapsulatingPositions((Iterable)Iterables.concat((Iterable)set, (Iterable)set1, (Iterable)set2)).map(p_160521_ -> {
                DiscreteVoxelShape discretevoxelshape = CeiltrunkTreeFeature.updateLeaves((LevelAccessor)worldgenlevel, p_160521_, set, set2);
                StructureTemplate.updateShapeAtEdge((LevelAccessor)worldgenlevel, (int)3, (DiscreteVoxelShape)discretevoxelshape, (int)p_160521_.minX(), (int)p_160521_.minY(), (int)p_160521_.minZ());
                return true;
            }).orElse(false);
        }
        return false;
    }

    private static DiscreteVoxelShape updateLeaves(LevelAccessor worldIn, BoundingBox bbIn, Set<BlockPos> p_236403_3_, Set<BlockPos> p_236403_4_) {
        ArrayList list = Lists.newArrayList();
        BitSetDiscreteVoxelShape discretevoxelshape = new BitSetDiscreteVoxelShape(bbIn.getXSpan(), bbIn.getYSpan(), bbIn.getZSpan());
        int amt = 6;
        for (int j = 0; j < amt; ++j) {
            list.add(Sets.newHashSet());
        }
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        for (BlockPos blockpos : Lists.newArrayList(p_236403_4_)) {
            if (!bbIn.isInside((Vec3i)blockpos)) continue;
            discretevoxelshape.fill(blockpos.getX() - bbIn.minX(), blockpos.getY() - bbIn.minY(), blockpos.getZ() - bbIn.minZ());
        }
        for (BlockPos blockpos1 : Lists.newArrayList(p_236403_3_)) {
            if (bbIn.isInside((Vec3i)blockpos1)) {
                discretevoxelshape.fill(blockpos1.getX() - bbIn.minX(), blockpos1.getY() - bbIn.minY(), blockpos1.getZ() - bbIn.minZ());
            }
            for (Direction direction : Direction.values()) {
                BlockState blockstate;
                blockpos$mutable.setWithOffset((Vec3i)blockpos1, direction);
                if (p_236403_3_.contains(blockpos$mutable) || !(blockstate = worldIn.getBlockState((BlockPos)blockpos$mutable)).hasProperty((Property)BlockStateProperties.DISTANCE)) continue;
                ((Set)list.get(0)).add(blockpos$mutable.immutable());
                CeiltrunkTreeFeature.setBlockKnownShape((LevelWriter)worldIn, (BlockPos)blockpos$mutable, (BlockState)blockstate.setValue((Property)BlockStateProperties.DISTANCE, (Comparable)Integer.valueOf(1)));
                if (!bbIn.isInside((Vec3i)blockpos$mutable)) continue;
                discretevoxelshape.fill(blockpos$mutable.getX() - bbIn.minX(), blockpos$mutable.getY() - bbIn.minY(), blockpos$mutable.getZ() - bbIn.minZ());
            }
        }
        for (int l = 1; l < amt; ++l) {
            Set set = (Set)list.get(l - 1);
            Set set1 = (Set)list.get(l);
            for (BlockPos blockpos2 : set) {
                if (bbIn.isInside((Vec3i)blockpos2)) {
                    discretevoxelshape.fill(blockpos2.getX() - bbIn.minX(), blockpos2.getY() - bbIn.minY(), blockpos2.getZ() - bbIn.minZ());
                }
                for (Direction direction1 : Direction.values()) {
                    int k;
                    BlockState blockstate1;
                    blockpos$mutable.setWithOffset((Vec3i)blockpos2, direction1);
                    if (set.contains(blockpos$mutable) || set1.contains(blockpos$mutable) || !(blockstate1 = worldIn.getBlockState((BlockPos)blockpos$mutable)).hasProperty((Property)BlockStateProperties.DISTANCE) || (k = ((Integer)blockstate1.getValue((Property)BlockStateProperties.DISTANCE)).intValue()) >= 7 || k <= l + 1) continue;
                    BlockState blockstate2 = (BlockState)blockstate1.setValue((Property)BlockStateProperties.DISTANCE, (Comparable)Integer.valueOf(l + 1));
                    CeiltrunkTreeFeature.setBlockKnownShape((LevelWriter)worldIn, (BlockPos)blockpos$mutable, blockstate2);
                    if (bbIn.isInside((Vec3i)blockpos$mutable)) {
                        discretevoxelshape.fill(blockpos$mutable.getX() - bbIn.minX(), blockpos$mutable.getY() - bbIn.minY(), blockpos$mutable.getZ() - bbIn.minZ());
                    }
                    set1.add(blockpos$mutable.immutable());
                }
            }
        }
        return discretevoxelshape;
    }
}

