/*
 * Decompiled with CFR 0.152.
 */
package com.kittehmod.ceilands.neoforge.worldgen.features;

import com.kittehmod.ceilands.neoforge.tags.CeilandsBlockTags;
import com.kittehmod.ceilands.neoforge.util.MathHelper;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;

public class WaterOrbFeature
extends Feature<BlockStateConfiguration> {
    public WaterOrbFeature(Codec<BlockStateConfiguration> codec) {
        super(codec);
    }

    private boolean isBlockReplaceable(WorldGenLevel level, BlockPos pos) {
        return level.getBlockState(pos).is(CeilandsBlockTags.WATER_ORB_REPLACEABLES);
    }

    public boolean place(FeaturePlaceContext<BlockStateConfiguration> context) {
        int posZ;
        int posX;
        int posY;
        boolean isGlassOrb;
        BlockPos blockpos = context.origin();
        RandomSource randomsource = context.random();
        WorldGenLevel worldgenlevel = context.level();
        int radius = 12 + randomsource.nextInt(5);
        BlockState state = ((BlockStateConfiguration)context.config()).state;
        boolean bl = isGlassOrb = (double)randomsource.nextFloat() < 0.1;
        if (isGlassOrb) {
            for (posY = -radius; posY < radius; ++posY) {
                for (posX = -radius; posX < radius; ++posX) {
                    for (posZ = -radius; posZ < radius; ++posZ) {
                        if (posY == -radius && posX == 0 && posZ == 0 || !MathHelper.isPlotInSphere(posX, posY, posZ, radius) || !this.isBlockReplaceable(worldgenlevel, blockpos.below(posY).east(posX).south(posZ))) continue;
                        this.setBlock((LevelWriter)worldgenlevel, blockpos.below(posY).east(posX).south(posZ), posY == 0 || posX == 0 || posZ == 0 ? state : Blocks.GLASS.defaultBlockState());
                    }
                }
            }
        } else {
            for (posY = 0; posY < radius; ++posY) {
                for (posX = -radius; posX < radius; ++posX) {
                    for (posZ = -radius; posZ < radius; ++posZ) {
                        if (!MathHelper.isPlotInSphere(posX, posY, posZ, radius) || !this.isBlockReplaceable(worldgenlevel, blockpos.below(posY).east(posX).south(posZ))) continue;
                        this.setBlock((LevelWriter)worldgenlevel, blockpos.below(posY).east(posX).south(posZ), state);
                    }
                }
            }
        }
        int n = posY = isGlassOrb ? -(--radius) : 0;
        while (posY < radius) {
            for (posX = -radius; posX < radius; ++posX) {
                for (posZ = -radius; posZ < radius; ++posZ) {
                    if (!MathHelper.isPlotInSphere(posX, posY, posZ, radius) || !this.isBlockReplaceable(worldgenlevel, blockpos.below(posY).east(posX).south(posZ))) continue;
                    this.setBlock((LevelWriter)worldgenlevel, blockpos.below(posY).east(posX).south(posZ), Blocks.WATER.defaultBlockState());
                }
            }
            ++posY;
        }
        int biometype = randomsource.nextInt(3);
        Block block = switch (biometype) {
            default -> Blocks.DIRT;
            case 1 -> Blocks.SAND;
            case 2 -> Blocks.GRAVEL;
        };
        for (int posY2 = radius - 3; posY2 < radius; ++posY2) {
            for (int posX2 = -radius; posX2 < radius; ++posX2) {
                for (int posZ2 = -radius; posZ2 < radius; ++posZ2) {
                    if (!MathHelper.isPlotInSphere(posX2, posY2, posZ2, radius) || !this.isBlockReplaceable(worldgenlevel, blockpos.below(posY2).east(posX2).south(posZ2))) continue;
                    this.setBlock((LevelWriter)worldgenlevel, blockpos.below(posY2).east(posX2).south(posZ2), block.defaultBlockState());
                    if (posX2 != 0 || posZ2 != 0) continue;
                    this.setBlock((LevelWriter)worldgenlevel, blockpos.below(posY2).east(posX2).south(posZ2), Blocks.GLOWSTONE.defaultBlockState());
                }
            }
        }
        return true;
    }
}

