/*
 * Decompiled with CFR 0.152.
 */
package com.kittehmod.ceilands.neoforge.worldgen.features;

import com.kittehmod.ceilands.neoforge.registry.CeilandsBlocks;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;

public class SmallFloatingIslandFeature
extends Feature<BlockStateConfiguration> {
    public SmallFloatingIslandFeature(Codec<BlockStateConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<BlockStateConfiguration> context) {
        boolean flag2;
        int l;
        BlockPos blockpos = context.origin();
        WorldGenLevel worldgenlevel = context.level();
        blockpos = new BlockPos(blockpos.getX(), blockpos.getY(), blockpos.getZ());
        RandomSource randomsource = context.random();
        boolean flag = randomsource.nextDouble() > 0.7;
        BlockState blockstate = ((BlockStateConfiguration)context.config()).state;
        double d0 = randomsource.nextDouble() * 2.0 * Math.PI;
        int i = 11 - randomsource.nextInt(5);
        int j = 3 + randomsource.nextInt(3);
        boolean flag1 = randomsource.nextDouble() > 0.7;
        int k = 11;
        int n = l = flag1 ? randomsource.nextInt(6) + 6 : randomsource.nextInt(15) + 3;
        if (!flag1 && randomsource.nextDouble() > 0.9) {
            l += randomsource.nextInt(19) + 7;
        }
        int i1 = Math.min(l + randomsource.nextInt(11), 18);
        int j1 = Math.min(l + randomsource.nextInt(7) - randomsource.nextInt(5), k);
        int k1 = flag1 ? i : 11;
        for (int l1 = -k1; l1 < k1; ++l1) {
            for (int i2 = -k1; i2 < k1; ++i2) {
                for (int j2 = 0; j2 < l; ++j2) {
                    int k2;
                    int n2 = k2 = flag1 ? this.heightDependentRadiusEllipse(j2, l, j1) : this.heightDependentRadiusRound(randomsource, j2, l, j1);
                    if (!flag1 && l1 >= k2) continue;
                    this.generateIcebergBlock((LevelAccessor)worldgenlevel, randomsource, blockpos, l, l1, j2, i2, k2, k1, flag1, j, d0, flag, blockstate);
                }
            }
        }
        this.smooth((LevelAccessor)worldgenlevel, blockpos, j1, l, flag1, i);
        for (int i3 = -k1; i3 < k1; ++i3) {
            for (int j3 = -k1; j3 < k1; ++j3) {
                for (int k3 = -1; k3 > -i1; --k3) {
                    int l3 = flag1 ? Mth.ceil((float)((float)k1 * (1.0f - (float)Math.pow(k3, 2.0) / ((float)i1 * 8.0f)))) : k1;
                    int l2 = this.heightDependentRadiusSteep(randomsource, -k3, i1, j1);
                    if (i3 >= l2) continue;
                    this.generateIcebergBlock((LevelAccessor)worldgenlevel, randomsource, blockpos, i1, i3, k3, j3, l2, l3, flag1, j, d0, flag, blockstate);
                }
            }
        }
        boolean bl = flag1 ? randomsource.nextDouble() > 0.1 : (flag2 = randomsource.nextDouble() > 0.7);
        if (flag2) {
            this.generateCutOut(randomsource, (LevelAccessor)worldgenlevel, j1, l, blockpos, flag1, i, d0, j);
        }
        return true;
    }

    private void generateCutOut(RandomSource p_225100_, LevelAccessor p_225101_, int p_225102_, int p_225103_, BlockPos p_225104_, boolean p_225105_, int p_225106_, double p_225107_, int p_225108_) {
        int i = p_225100_.nextBoolean() ? -1 : 1;
        int j = p_225100_.nextBoolean() ? -1 : 1;
        int k = p_225100_.nextInt(Math.max(p_225102_ / 2 - 2, 1));
        if (p_225100_.nextBoolean()) {
            k = p_225102_ / 2 + 1 - p_225100_.nextInt(Math.max(p_225102_ - p_225102_ / 2 - 1, 1));
        }
        int l = p_225100_.nextInt(Math.max(p_225102_ / 2 - 2, 1));
        if (p_225100_.nextBoolean()) {
            l = p_225102_ / 2 + 1 - p_225100_.nextInt(Math.max(p_225102_ - p_225102_ / 2 - 1, 1));
        }
        if (p_225105_) {
            k = l = p_225100_.nextInt(Math.max(p_225106_ - 5, 1));
        }
        BlockPos blockpos = new BlockPos(i * k, 0, j * l);
        double d0 = p_225105_ ? p_225107_ + 1.5707963267948966 : p_225100_.nextDouble() * 2.0 * Math.PI;
        for (int i1 = 0; i1 < p_225103_ - 3; ++i1) {
            int j1 = this.heightDependentRadiusRound(p_225100_, i1, p_225103_, p_225102_);
            this.carve(j1, i1, p_225104_, p_225101_, false, d0, blockpos, p_225106_, p_225108_);
        }
        for (int k1 = -1; k1 > -p_225103_ + p_225100_.nextInt(5); --k1) {
            int l1 = this.heightDependentRadiusSteep(p_225100_, -k1, p_225103_, p_225102_);
            this.carve(l1, k1, p_225104_, p_225101_, true, d0, blockpos, p_225106_, p_225108_);
        }
    }

    private void carve(int p_66036_, int p_66037_, BlockPos p_66038_, LevelAccessor p_66039_, boolean p_66040_, double p_66041_, BlockPos p_66042_, int p_66043_, int p_66044_) {
        int i = p_66036_ + 1 + p_66043_ / 3;
        int j = Math.min(p_66036_ - 3, 3) + p_66044_ / 2 - 1;
        for (int k = -i; k < i; ++k) {
            for (int l = -i; l < i; ++l) {
                BlockPos blockpos;
                BlockState blockstate;
                double d0 = this.signedDistanceEllipse(k, l, p_66042_, i, j, p_66041_);
                if (!(d0 < 0.0) || !SmallFloatingIslandFeature.isIslandState(blockstate = p_66039_.getBlockState(blockpos = p_66038_.offset(k, p_66037_, l))) && !blockstate.is(Blocks.SNOW_BLOCK)) continue;
                this.setBlock((LevelWriter)p_66039_, blockpos, Blocks.AIR.defaultBlockState());
                this.removeFloatingSnowLayer(p_66039_, blockpos);
            }
        }
    }

    private void removeFloatingSnowLayer(LevelAccessor p_66049_, BlockPos p_66050_) {
        if (p_66049_.getBlockState(p_66050_.above()).is(Blocks.SNOW)) {
            this.setBlock((LevelWriter)p_66049_, p_66050_.above(), Blocks.AIR.defaultBlockState());
        }
    }

    private void generateIcebergBlock(LevelAccessor level, RandomSource random, BlockPos pos, int p_225113_, int p_225114_, int p_225115_, int p_225116_, int p_225117_, int p_225118_, boolean p_225119_, int p_225120_, double p_225121_, boolean p_225122_, BlockState state) {
        double d0;
        double d = d0 = p_225119_ ? this.signedDistanceEllipse(p_225114_, p_225116_, BlockPos.ZERO, p_225118_, this.getEllipseC(p_225115_, p_225113_, p_225120_), p_225121_) : this.signedDistanceCircle(p_225114_, p_225116_, BlockPos.ZERO, p_225117_, random);
        if (d0 < 0.0) {
            double d1;
            BlockPos blockpos = pos.offset(p_225114_, p_225115_, p_225116_);
            double d2 = d1 = p_225119_ ? -0.5 : (double)(-6 - random.nextInt(3));
            if (d0 > d1 && random.nextDouble() > 0.9) {
                return;
            }
            this.setIcebergBlock(blockpos, level, random, p_225113_ - p_225115_, p_225113_, p_225119_, p_225122_, state);
        }
    }

    private void setIcebergBlock(BlockPos pos, LevelAccessor level, RandomSource randomsource, int p_225128_, int p_225129_, boolean p_225130_, boolean p_225131_, BlockState state) {
        BlockState blockstate = level.getBlockState(pos);
        if (blockstate.is(Blocks.AIR) || blockstate.is(Blocks.CAVE_AIR) || blockstate.is(Blocks.SNOW_BLOCK) || blockstate.is(Blocks.RED_SAND) || blockstate.is(Blocks.ICE) || blockstate.is(Blocks.WATER)) {
            int i;
            boolean flag = !p_225130_ || randomsource.nextDouble() > 0.05;
            int n = i = p_225130_ ? 3 : 2;
            if (p_225131_ && !blockstate.is(Blocks.WATER) && (double)p_225128_ <= (double)randomsource.nextInt(Math.max(1, p_225129_ / i)) + (double)p_225129_ * 0.6 && flag) {
                this.setBlock((LevelWriter)level, pos, state.getBlock() == CeilandsBlocks.ROOFSHALE ? Blocks.RED_SAND.defaultBlockState() : Blocks.SNOW_BLOCK.defaultBlockState());
            } else {
                this.setBlock((LevelWriter)level, pos, state);
            }
        }
    }

    private int getEllipseC(int p_66019_, int p_66020_, int p_66021_) {
        int i = p_66021_;
        if (p_66019_ > 0 && p_66020_ - p_66019_ <= 3) {
            i = p_66021_ - (4 - (p_66020_ - p_66019_));
        }
        return i;
    }

    private double signedDistanceCircle(int p_225089_, int p_225090_, BlockPos p_225091_, int p_225092_, RandomSource p_225093_) {
        float f = 10.0f * Mth.clamp((float)p_225093_.nextFloat(), (float)0.2f, (float)0.8f) / (float)p_225092_;
        return (double)f + Math.pow(p_225089_ - p_225091_.getX(), 2.0) + Math.pow(p_225090_ - p_225091_.getZ(), 2.0) - Math.pow(p_225092_, 2.0);
    }

    private double signedDistanceEllipse(int p_66023_, int p_66024_, BlockPos p_66025_, int p_66026_, int p_66027_, double p_66028_) {
        return Math.pow(((double)(p_66023_ - p_66025_.getX()) * Math.cos(p_66028_) - (double)(p_66024_ - p_66025_.getZ()) * Math.sin(p_66028_)) / (double)p_66026_, 2.0) + Math.pow(((double)(p_66023_ - p_66025_.getX()) * Math.sin(p_66028_) + (double)(p_66024_ - p_66025_.getZ()) * Math.cos(p_66028_)) / (double)p_66027_, 2.0) - 1.0;
    }

    private int heightDependentRadiusRound(RandomSource p_225095_, int p_225096_, int p_225097_, int p_225098_) {
        float f = 3.5f - p_225095_.nextFloat();
        float f1 = (1.0f - (float)Math.pow(p_225096_, 2.0) / ((float)p_225097_ * f)) * (float)p_225098_;
        if (p_225097_ > 15 + p_225095_.nextInt(5)) {
            int i = p_225096_ < 3 + p_225095_.nextInt(6) ? p_225096_ / 2 : p_225096_;
            f1 = (1.0f - (float)i / ((float)p_225097_ * f * 0.4f)) * (float)p_225098_;
        }
        return Mth.ceil((float)(f1 / 2.0f));
    }

    private int heightDependentRadiusEllipse(int p_66110_, int p_66111_, int p_66112_) {
        float f = 1.0f;
        float f1 = (f - (float)Math.pow(p_66110_, 2.0) / ((float)p_66111_ * f)) * (float)p_66112_;
        return Mth.ceil((float)(f1 / 2.0f));
    }

    private int heightDependentRadiusSteep(RandomSource p_225134_, int p_225135_, int p_225136_, int p_225137_) {
        float f = 1.0f + p_225134_.nextFloat() / 2.0f;
        float f1 = (1.0f - (float)p_225135_ / ((float)p_225136_ * f)) * (float)p_225137_;
        return Mth.ceil((float)(f1 / 2.0f));
    }

    private static boolean isIslandState(BlockState state) {
        return state.is(CeilandsBlocks.CEILINGNEOUS) || state.is(Blocks.SNOW_BLOCK) || state.is(Blocks.BLUE_ICE);
    }

    private boolean belowIsAir(BlockGetter state, BlockPos pos) {
        return state.getBlockState(pos.below()).getBlock() == Blocks.AIR || state.getBlockState(pos.below()).getBlock() == Blocks.CAVE_AIR;
    }

    private void smooth(LevelAccessor p_66052_, BlockPos p_66053_, int p_66054_, int p_66055_, boolean p_66056_, int p_66057_) {
        int i = p_66056_ ? p_66057_ : p_66054_ / 2;
        for (int j = -i; j <= i; ++j) {
            for (int k = -i; k <= i; ++k) {
                for (int l = 0; l <= p_66055_; ++l) {
                    BlockPos blockpos = p_66053_.offset(j, l, k);
                    BlockState blockstate = p_66052_.getBlockState(blockpos);
                    if (!SmallFloatingIslandFeature.isIslandState(blockstate) && !blockstate.is(Blocks.SNOW)) continue;
                    if (this.belowIsAir((BlockGetter)p_66052_, blockpos)) {
                        this.setBlock((LevelWriter)p_66052_, blockpos, Blocks.AIR.defaultBlockState());
                        this.setBlock((LevelWriter)p_66052_, blockpos.above(), Blocks.AIR.defaultBlockState());
                        continue;
                    }
                    if (!SmallFloatingIslandFeature.isIslandState(blockstate)) continue;
                    BlockState[] ablockstate = new BlockState[]{p_66052_.getBlockState(blockpos.west()), p_66052_.getBlockState(blockpos.east()), p_66052_.getBlockState(blockpos.north()), p_66052_.getBlockState(blockpos.south())};
                    int i1 = 0;
                    for (BlockState blockstate1 : ablockstate) {
                        if (SmallFloatingIslandFeature.isIslandState(blockstate1)) continue;
                        ++i1;
                    }
                    if (i1 < 3) continue;
                    this.setBlock((LevelWriter)p_66052_, blockpos, Blocks.AIR.defaultBlockState());
                }
            }
        }
    }
}

