/*
 * Decompiled with CFR 0.152.
 */
package com.kittehmod.ceilands.neoforge.worldgen.features;

import com.kittehmod.ceilands.neoforge.util.MathHelper;
import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;

public class NaturalBridgeFeature
extends Feature<BlockStateConfiguration> {
    public NaturalBridgeFeature(Codec<BlockStateConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<BlockStateConfiguration> context) {
        int diffZ;
        int diffY;
        Block refBlock;
        List<Direction> startingDirections = List.of(Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST);
        BlockState state = ((BlockStateConfiguration)context.config()).state;
        BlockPos blockpos = context.origin();
        RandomSource randomsource = context.random();
        WorldGenLevel worldgenlevel = context.level();
        BlockPos pointA = null;
        BlockPos pointB = null;
        if (worldgenlevel.getBlockState(blockpos).getBlock() != Blocks.AIR) {
            return false;
        }
        int dirChooser = randomsource.nextInt(startingDirections.size());
        Direction dir = startingDirections.get(dirChooser);
        for (int fwd = 0; fwd < 12; ++fwd) {
            for (int hgt = 6; hgt > -6; --hgt) {
                for (int wdth = -5; wdth <= 5; ++wdth) {
                    refBlock = worldgenlevel.getBlockState(blockpos.relative(dir, fwd).relative(dir.getClockWise(), wdth).above(hgt)).getBlock();
                    if (refBlock == Blocks.AIR || refBlock != state.getBlock()) continue;
                    pointA = blockpos.relative(dir, fwd).relative(dir.getClockWise(), wdth).above(hgt);
                    break;
                }
                if (pointA != null) break;
            }
            if (pointA != null) break;
        }
        block3: for (int attempt = 0; attempt < 3; ++attempt) {
            dir = dir.getClockWise();
            for (int fwd = 0; fwd < 12; ++fwd) {
                for (int hgt = 6; hgt > -6; --hgt) {
                    refBlock = worldgenlevel.getBlockState(blockpos.relative(dir, fwd).above(hgt)).getBlock();
                    if (refBlock == Blocks.AIR || refBlock != state.getBlock()) continue;
                    pointB = blockpos.relative(dir, fwd).above(hgt);
                    break;
                }
                if (pointB != null) continue block3;
            }
        }
        if (pointA == null || pointB == null) {
            return false;
        }
        int diffX = Math.abs(pointA.getX() - pointB.getX());
        int dist = this.calculateBiggestOfThree(diffX, diffY = Math.abs(pointA.getY() - pointB.getY()), diffZ = Math.abs(pointA.getZ() - pointB.getZ()));
        int radiusSize = 1 + Math.max((int)Math.floor(Math.sqrt(dist)), 2);
        if (radiusSize > 2) {
            radiusSize = 2;
        }
        int archHeight = 2 + randomsource.nextInt(Math.max(8 - diffY, 1));
        for (int i = 0; i < dist; ++i) {
            BlockPos posToSet = MathHelper.getInterpolatedBlockPos(pointA, pointB, (float)i / (float)dist);
            this.makeSphereAt(worldgenlevel, posToSet.above((int)Math.floor(Math.sin((double)((float)i / (float)dist) * Math.PI) * (double)archHeight)), state, radiusSize);
        }
        return true;
    }

    private void makeSphereAt(WorldGenLevel level, BlockPos pos, BlockState state, int radius) {
        for (int i = -radius; i < radius; ++i) {
            for (int j = -radius; j < radius; ++j) {
                for (int k = -radius; k < radius; ++k) {
                    if (!MathHelper.isPlotInSphere(i, j, k, radius)) continue;
                    this.setBlock((LevelWriter)level, pos.above(i).south(j).east(k), state);
                }
            }
        }
    }

    private int calculateBiggestOfThree(int par1, int par2, int par3) {
        int a = Math.max(Math.abs(par1), Math.abs(par2));
        int b = Math.max(Math.abs(par2), Math.abs(par3));
        return Math.max(a, b);
    }
}

