/*
 * Decompiled with CFR 0.152.
 */
package com.kittehmod.ceilands.neoforge.worldgen.features;

import com.kittehmod.ceilands.neoforge.registry.CeilandsBlocks;
import com.kittehmod.ceilands.neoforge.util.MathHelper;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;

public class LargeFloatingIslandFeature
extends Feature<BlockStateConfiguration> {
    public LargeFloatingIslandFeature(Codec<BlockStateConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<BlockStateConfiguration> context) {
        BlockPos blockpos = context.origin();
        RandomSource randomsource = context.random();
        WorldGenLevel worldgenlevel = context.level();
        int radius = 12 + randomsource.nextInt(5);
        int height = radius / 2 + randomsource.nextInt(12);
        int taperingAmt = height > radius ? 2 : 1;
        int taperingSteps = (double)height * 0.5 < (double)radius ? 2 : 1;
        boolean hasPond = (double)randomsource.nextFloat() < 0.2;
        int pondDepth = hasPond ? randomsource.nextInt(3) : 0;
        int pondWidth = hasPond ? pondDepth * 2 + randomsource.nextInt(4) + 1 : 0;
        for (int posY = 0; posY < height; ++posY) {
            if (posY == 0) {
                --radius;
            }
            if (posY == 1) {
                ++radius;
            }
            for (int posX = -radius; posX < radius; ++posX) {
                for (int posZ = -radius; posZ < radius; ++posZ) {
                    if (MathHelper.isPlotInCircle(posX, posZ, radius) && worldgenlevel.getBlockState(blockpos.below(posY).east(posX).south(posZ)).getBlock() == Blocks.AIR) {
                        if (posY == 0) {
                            this.setBlock((LevelWriter)worldgenlevel, blockpos.below(posY).east(posX).south(posZ), Blocks.GRASS_BLOCK.defaultBlockState());
                        } else if (posY == 1) {
                            this.setBlock((LevelWriter)worldgenlevel, blockpos.below(posY).east(posX).south(posZ), Blocks.DIRT.defaultBlockState());
                        } else if (posY == 2 && (double)randomsource.nextFloat() < 0.5) {
                            this.setBlock((LevelWriter)worldgenlevel, blockpos.below(posY).east(posX).south(posZ), Blocks.DIRT.defaultBlockState());
                        } else if (posY == 3 && (double)randomsource.nextFloat() < 0.25) {
                            this.setBlock((LevelWriter)worldgenlevel, blockpos.below(posY).east(posX).south(posZ), Blocks.DIRT.defaultBlockState());
                        } else {
                            this.setBlock((LevelWriter)worldgenlevel, blockpos.below(posY).east(posX).south(posZ), CeilandsBlocks.CEILINGNEOUS.defaultBlockState());
                        }
                    }
                    if (!hasPond || !MathHelper.isPlotInCircle(posX, posZ, pondWidth) || posY > pondDepth) continue;
                    this.setBlock((LevelWriter)worldgenlevel, blockpos.below(posY).east(posX).south(posZ), Blocks.WATER.defaultBlockState());
                    this.setBlock((LevelWriter)worldgenlevel, blockpos.below(posY + 1).east(posX).south(posZ), Blocks.SAND.defaultBlockState());
                }
            }
            if (pondWidth > 0) {
                --pondWidth;
            }
            if (posY % taperingSteps == 0) {
                radius -= taperingAmt;
            }
            if (radius <= 0) break;
        }
        return true;
    }
}

