/*
 * Decompiled with CFR 0.152.
 */
package com.kittehmod.ceilands.neoforge.worldgen.features;

import com.kittehmod.ceilands.neoforge.registry.CeilandsBlocks;
import com.kittehmod.ceilands.neoforge.util.MathHelper;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;

public class HugeIcicleFeature
extends Feature<BlockStateConfiguration> {
    public HugeIcicleFeature(Codec<BlockStateConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<BlockStateConfiguration> context) {
        int height;
        BlockPos blockpos = context.origin();
        RandomSource randomsource = context.random();
        WorldGenLevel worldgenlevel = context.level();
        for (int i = 1; i < 96; ++i) {
            if (worldgenlevel.getBlockState(blockpos.above(i)).getBlock() == Blocks.AIR || worldgenlevel.getBlockState(blockpos.above(i)).getBlock() == Blocks.SNOW_BLOCK) continue;
            blockpos = blockpos.above(i);
            break;
        }
        BlockState state = ((BlockStateConfiguration)context.config()).state;
        int width = 2 + randomsource.nextInt(8);
        int narrowenIntervals = 4 + randomsource.nextInt(6);
        if (state.getBlock() == CeilandsBlocks.CEILINGNEOUS) {
            narrowenIntervals += randomsource.nextInt(8);
            if ((width += randomsource.nextInt(24)) > 16) {
                width = 16;
            }
            if (narrowenIntervals > 10) {
                narrowenIntervals = 12;
            }
        }
        if ((height = width * narrowenIntervals) > 220) {
            height = 220;
        }
        for (int ht = 0; ht < height; ++ht) {
            for (int x = -width; x <= width; ++x) {
                for (int z = -width; z <= width; ++z) {
                    if (!MathHelper.isPlotInCircle(x, z, width) || worldgenlevel.getBlockState(blockpos.below(ht).east(x).south(z)).getBlock() != Blocks.AIR || blockpos.below(ht).getY() < worldgenlevel.getMinBuildHeight()) continue;
                    worldgenlevel.setBlock(blockpos.below(ht).east(x).south(z), state, 11);
                }
            }
            if (ht % narrowenIntervals == 0) {
                --width;
            }
            if (width <= 0) break;
        }
        return true;
    }
}

