/*
 * Decompiled with CFR 0.152.
 */
package com.kittehmod.ceilands.neoforge.worldgen.features;

import com.kittehmod.ceilands.neoforge.registry.CeilandsBlocks;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;

public class ColossalCeiltrunkTree
extends Feature<BlockStateConfiguration> {
    public ColossalCeiltrunkTree(Codec<BlockStateConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<BlockStateConfiguration> context) {
        int i;
        BlockPos blockpos = context.origin();
        RandomSource randomsource = context.random();
        WorldGenLevel worldgenlevel = context.level();
        boolean foundSpace = false;
        boolean isOKToPutLog = false;
        for (i = 1; i < 6; ++i) {
            if (worldgenlevel.getBlockState(blockpos.below(i)).getBlock() == Blocks.AIR || worldgenlevel.getBlockState(blockpos.below(i)).is(BlockTags.CAVE_VINES)) continue;
            blockpos = blockpos.below(i);
            foundSpace = true;
            break;
        }
        for (i = 1; i < 6 && !foundSpace; ++i) {
            if (worldgenlevel.getBlockState(blockpos.above(i)).getBlock() == Blocks.AIR || worldgenlevel.getBlockState(blockpos.above(i)).is(BlockTags.CAVE_VINES)) continue;
            blockpos = blockpos.above(i);
            foundSpace = true;
            break;
        }
        if (!foundSpace) {
            return false;
        }
        int trunkRadius = 2 + randomsource.nextInt(3);
        int trunkHeight = 4 + trunkRadius * (3 + randomsource.nextInt(7));
        int branchLength = 2 + trunkRadius + randomsource.nextInt(3);
        for (int trunkX = -trunkRadius; trunkX < trunkRadius; ++trunkX) {
            for (int trunkZ = -trunkRadius; trunkZ < trunkRadius; ++trunkZ) {
                if ((trunkX <= -trunkRadius || trunkX >= trunkRadius - 1) && (trunkZ <= -trunkRadius || trunkZ >= trunkRadius - 1) || worldgenlevel.getBlockState(blockpos.above(1).east(trunkX).south(trunkZ)).getBlock() != Blocks.AIR && !worldgenlevel.getBlockState(blockpos.below(0).east(trunkX).south(trunkZ)).is(BlockTags.CAVE_VINES) && !worldgenlevel.getBlockState(blockpos.below(0).east(trunkX).south(trunkZ)).is(CeilandsBlocks.CEILTRUNK_LEAVES)) continue;
                this.setBlock((LevelWriter)worldgenlevel, blockpos.above(1).east(trunkX).south(trunkZ), Blocks.MOSS_BLOCK.defaultBlockState());
            }
        }
        for (int trunkY = 0; trunkY < trunkHeight; ++trunkY) {
            for (int trunkX = -trunkRadius; trunkX < trunkRadius; ++trunkX) {
                for (int trunkZ = -trunkRadius; trunkZ < trunkRadius; ++trunkZ) {
                    isOKToPutLog = false;
                    if (!(trunkX != -trunkRadius + 1 && trunkX != trunkRadius - 2 || trunkZ != -trunkRadius + 1 && trunkZ != trunkRadius - 2)) {
                        isOKToPutLog = true;
                    } else {
                        boolean bl = isOKToPutLog = trunkRadius <= 3;
                    }
                    if (trunkX > -trunkRadius + 1 && trunkX < trunkRadius - 2 || trunkZ > -trunkRadius + 1 && trunkZ < trunkRadius - 2) {
                        isOKToPutLog = true;
                    }
                    if (!isOKToPutLog || worldgenlevel.getBlockState(blockpos.below(trunkY).east(trunkX).south(trunkZ)).getBlock() != Blocks.AIR && !worldgenlevel.getBlockState(blockpos.below(trunkY).east(trunkX).south(trunkZ)).is(BlockTags.CAVE_VINES) && !worldgenlevel.getBlockState(blockpos.below(trunkY).east(trunkX).south(trunkZ)).is(CeilandsBlocks.CEILTRUNK_LEAVES)) continue;
                    this.setBlock((LevelWriter)worldgenlevel, blockpos.below(trunkY).east(trunkX).south(trunkZ), CeilandsBlocks.CEILTRUNK_LOG.defaultBlockState());
                }
            }
        }
        Direction dir = Direction.NORTH;
        boolean clockwise = (double)randomsource.nextFloat() >= 0.5;
        for (int i2 = 2; i2 < trunkHeight - 2; ++i2) {
            this.generateBranches(worldgenlevel, randomsource, blockpos.below(i2), dir, branchLength, dir.getAxis() == Direction.Axis.X ? (dir == Direction.EAST ? trunkRadius - 1 : -trunkRadius) : 0, dir.getAxis() == Direction.Axis.Z ? (dir == Direction.SOUTH ? trunkRadius - 1 : -trunkRadius) : 0, 1);
            dir = clockwise ? dir.getClockWise() : dir.getCounterClockWise();
        }
        this.generateBranches(worldgenlevel, randomsource, blockpos.below(trunkHeight), Direction.NORTH, branchLength, -2, -trunkRadius + 1, 2);
        this.generateBranches(worldgenlevel, randomsource, blockpos.below(trunkHeight), Direction.NORTH, branchLength, -1, -trunkRadius + 1, 2);
        this.generateBranches(worldgenlevel, randomsource, blockpos.below(trunkHeight), Direction.NORTH, branchLength, 1, -trunkRadius + 1, 2);
        this.generateBranches(worldgenlevel, randomsource, blockpos.below(trunkHeight), Direction.NORTH, branchLength, 2, -trunkRadius + 1, 2);
        this.generateBranches(worldgenlevel, randomsource, blockpos.below(trunkHeight), Direction.EAST, branchLength, trunkRadius - 2, -2, 2);
        this.generateBranches(worldgenlevel, randomsource, blockpos.below(trunkHeight), Direction.EAST, branchLength, trunkRadius - 2, -1, 2);
        this.generateBranches(worldgenlevel, randomsource, blockpos.below(trunkHeight), Direction.EAST, branchLength, trunkRadius - 2, 1, 2);
        this.generateBranches(worldgenlevel, randomsource, blockpos.below(trunkHeight), Direction.EAST, branchLength, trunkRadius - 2, 2, 2);
        this.generateBranches(worldgenlevel, randomsource, blockpos.below(trunkHeight), Direction.SOUTH, branchLength, -2, trunkRadius - 2, 2);
        this.generateBranches(worldgenlevel, randomsource, blockpos.below(trunkHeight), Direction.SOUTH, branchLength, -1, trunkRadius - 2, 2);
        this.generateBranches(worldgenlevel, randomsource, blockpos.below(trunkHeight), Direction.SOUTH, branchLength, 1, trunkRadius - 2, 2);
        this.generateBranches(worldgenlevel, randomsource, blockpos.below(trunkHeight), Direction.SOUTH, branchLength, 2, trunkRadius - 2, 2);
        this.generateBranches(worldgenlevel, randomsource, blockpos.below(trunkHeight), Direction.WEST, branchLength, -trunkRadius + 1, -2, 2);
        this.generateBranches(worldgenlevel, randomsource, blockpos.below(trunkHeight), Direction.WEST, branchLength, -trunkRadius + 1, -1, 2);
        this.generateBranches(worldgenlevel, randomsource, blockpos.below(trunkHeight), Direction.WEST, branchLength, -trunkRadius + 1, 1, 2);
        this.generateBranches(worldgenlevel, randomsource, blockpos.below(trunkHeight), Direction.WEST, branchLength, -trunkRadius + 1, 2, 2);
        return true;
    }

    private void generateBranches(WorldGenLevel level, RandomSource random, BlockPos pos, Direction direction, int branchLength, int offsetX, int offsetZ, int foliageRadius) {
        for (int bl = 1; bl <= branchLength; ++bl) {
            this.setBlock((LevelWriter)level, pos.relative(direction, bl).east(offsetX).south(offsetZ), (BlockState)CeilandsBlocks.CEILTRUNK_LOG.defaultBlockState().setValue((Property)RotatedPillarBlock.AXIS, (Comparable)direction.getAxis()));
            if (bl == branchLength - 1) {
                this.setBlock((LevelWriter)level, pos.relative(direction, bl).east(offsetX).south(offsetZ).above(1), (BlockState)CeilandsBlocks.CEILTRUNK_LOG.defaultBlockState().setValue((Property)RotatedPillarBlock.AXIS, (Comparable)Direction.Axis.Y));
            }
            this.setSurroundingBlocks(level, pos.relative(direction, bl).east(offsetX).south(offsetZ), CeilandsBlocks.CEILTRUNK_LEAVES.defaultBlockState(), foliageRadius);
        }
    }

    private void setSurroundingBlocks(WorldGenLevel level, BlockPos pos, BlockState state, int radius) {
        for (Direction dir : Direction.values()) {
            for (int i = 0; i <= radius; ++i) {
                if (level.getBlockState(pos.relative(dir, i)).getBlock() != Blocks.AIR || !(state.getBlock() instanceof LeavesBlock)) continue;
                this.setBlock((LevelWriter)level, pos.relative(dir, i), (BlockState)state.setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(i + 1)));
            }
        }
    }
}

