/*
 * Decompiled with CFR 0.152.
 */
package com.kittehmod.ceilands.neoforge.worldgen.features;

import com.kittehmod.ceilands.neoforge.util.MathHelper;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;

public class ColossalCeilshroom
extends Feature<BlockStateConfiguration> {
    public ColossalCeilshroom(Codec<BlockStateConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<BlockStateConfiguration> context) {
        boolean shouldPlace = false;
        BlockPos blockpos = context.origin();
        RandomSource randomsource = context.random();
        WorldGenLevel worldgenlevel = context.level();
        for (int i = 1; i < 96; ++i) {
            if (!worldgenlevel.getBlockState(blockpos.above(i)).is(BlockTags.DIRT)) continue;
            blockpos = blockpos.above(i);
            shouldPlace = true;
            break;
        }
        if (!worldgenlevel.getBlockState(blockpos.below()).is(BlockTags.AIR)) {
            shouldPlace = false;
        }
        if (!shouldPlace) {
            return false;
        }
        boolean genShroomlights = (double)randomsource.nextFloat() < 0.1;
        boolean genLush = (double)randomsource.nextFloat() < 0.25;
        int stemRadius = 2 + randomsource.nextInt(5);
        int stemHeight = stemRadius * (3 + randomsource.nextInt(7));
        int stemTaperThreshold = 3 + randomsource.nextInt(2);
        int stemTaperThreshold2 = (double)randomsource.nextFloat() < 0.5 ? stemTaperThreshold * 2 + randomsource.nextInt(4) : -1;
        for (int stemY = -1; stemY < stemHeight; ++stemY) {
            for (int stemX = -stemRadius; stemX < stemRadius; ++stemX) {
                for (int stemZ = -stemRadius; stemZ < stemRadius; ++stemZ) {
                    if ((stemX <= -stemRadius || stemX >= stemRadius - 1) && (stemZ <= -stemRadius || stemZ >= stemRadius - 1) || worldgenlevel.getBlockState(blockpos.below(stemY).east(stemX).south(stemZ)).getBlock() != Blocks.AIR) continue;
                    this.setBlock((LevelWriter)worldgenlevel, blockpos.below(stemY).east(stemX).south(stemZ), stemY == -1 ? Blocks.MOSS_BLOCK.defaultBlockState() : Blocks.MUSHROOM_STEM.defaultBlockState());
                }
            }
            if (stemY == stemTaperThreshold) {
                --stemRadius;
            }
            if (stemTaperThreshold2 > 0 && stemY == stemTaperThreshold2) {
                --stemRadius;
            }
            if (stemRadius >= 2) continue;
            stemRadius = 2;
        }
        blockpos = blockpos.below(stemHeight);
        Block capBlock = (double)randomsource.nextFloat() < 0.5 ? Blocks.RED_MUSHROOM_BLOCK : Blocks.BROWN_MUSHROOM_BLOCK;
        Block lushBlock = (double)randomsource.nextFloat() < 0.3 ? Blocks.MOSS_BLOCK : Blocks.GRASS_BLOCK;
        int capRadius = 5 + stemRadius * 4 + randomsource.nextInt(5);
        int capThickness = 3 + (int)Math.floor(capRadius / 5 + randomsource.nextInt(8));
        if (capRadius > 16) {
            capRadius = 16;
        }
        for (int capY = 0; capY < capThickness; ++capY) {
            for (int capX = -capRadius; capX < capRadius; ++capX) {
                for (int capZ = -capRadius; capZ < capRadius; ++capZ) {
                    if (!MathHelper.isPlotInCircle(capX, capZ, capRadius) || worldgenlevel.getBlockState(blockpos.below(capY).east(capX).south(capZ)) != Blocks.AIR.defaultBlockState()) continue;
                    this.setBlock((LevelWriter)worldgenlevel, blockpos.below(capY).east(capX).south(capZ), capBlock.defaultBlockState());
                    if (genLush && capY == 0 && capX > -capRadius + 2 && capX < capRadius - 2 && capZ > -capRadius + 2 && capZ < capRadius - 2 && MathHelper.isPlotInCircle(capX, capZ, capRadius - 2) && worldgenlevel.getBlockState(blockpos.below(capY).east(capX).south(capZ)).getBlock() != Blocks.MUSHROOM_STEM) {
                        this.setBlock((LevelWriter)worldgenlevel, blockpos.below(capY).east(capX).south(capZ), lushBlock.defaultBlockState());
                    }
                    if (!genShroomlights || !((double)randomsource.nextFloat() < 0.02)) continue;
                    this.setBlock((LevelWriter)worldgenlevel, blockpos.below(capY).east(capX).south(capZ), Blocks.SHROOMLIGHT.defaultBlockState());
                }
            }
            if (capY < 1) continue;
            if (capBlock == Blocks.RED_MUSHROOM_BLOCK) {
                capRadius -= Math.min(capY + 1, 5);
                continue;
            }
            capRadius = (int)((double)capRadius - Math.max((double)capRadius * 0.15, 1.0));
        }
        return true;
    }
}

