/*
 * Decompiled with CFR 0.152.
 */
package com.kittehmod.ceilands.neoforge.neoforge.compat;

import com.kittehmod.ceilands.neoforge.block.CeilandsFlammableBlocks;
import com.kittehmod.ceilands.neoforge.neoforge.CeilandsRegistry;
import com.kittehmod.ceilands.neoforge.registry.CeilandsBlocks;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import oshi.util.tuples.Pair;
import oshi.util.tuples.Triplet;
import twilightforest.block.BanisterBlock;
import twilightforest.block.ClimbableHollowLogBlock;
import twilightforest.block.HorizontalHollowLogBlock;
import twilightforest.block.VerticalHollowLogBlock;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFCreativeTabs;
import twilightforest.init.TFItems;
import twilightforest.item.HollowLogItem;

public class TwilightForestCompat {
    public static final ResourceLocation CEILTRUNK_BANISTER_RES = ResourceLocation.fromNamespaceAndPath((String)"ceilands", (String)"ceiltrunk_banister");
    public static final ResourceLocation LUZAWOOD_BANISTER_RES = ResourceLocation.fromNamespaceAndPath((String)"ceilands", (String)"luzawood_banister");
    public static final ResourceLocation CEILTRUNK_HOLLOW_LOG_RES = ResourceLocation.fromNamespaceAndPath((String)"ceilands", (String)"hollow_ceiltrunk_log");
    public static final ResourceLocation LUZAWOOD_HOLLOW_LOG_RES = ResourceLocation.fromNamespaceAndPath((String)"ceilands", (String)"hollow_luzawood_log");
    public static final ResourceLocation CEILTRUNK_HOLLOW_LOG_CLIMBABLE_RES = ResourceLocation.fromNamespaceAndPath((String)"ceilands", (String)"hollow_ceiltrunk_log_climbable");
    public static final ResourceLocation LUZAWOOD_HOLLOW_LOG_CLIMBABLE_RES = ResourceLocation.fromNamespaceAndPath((String)"ceilands", (String)"hollow_luzawood_log_climbable");
    private Holder<Block> hollowHorizontalCeiltrunkLogHolder = Holder.direct((Object)Blocks.AIR);
    private Holder<Block> hollowVerticalCeiltrunkLogHolder = Holder.direct((Object)Blocks.AIR);
    private Holder<Block> hollowClimbableCeiltrunkLogHolder = Holder.direct((Object)Blocks.AIR);
    private Holder<Block> hollowHorizontalLuzawoodLogHolder = Holder.direct((Object)Blocks.AIR);
    private Holder<Block> hollowVerticalLuzawoodLogHolder = Holder.direct((Object)Blocks.AIR);
    private Holder<Block> hollowClimbableLuzawoodLogHolder = Holder.direct((Object)Blocks.AIR);

    public TwilightForestCompat(boolean register) {
        if (!register) {
            return;
        }
        BanisterBlock CEILTRUNK_BANISTER = new BanisterBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)CeilandsBlocks.CEILTRUNK_PLANKS));
        BanisterBlock LUZAWOOD_BANISTER = new BanisterBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)CeilandsBlocks.LUZAWOOD_PLANKS));
        HorizontalHollowLogBlock HOLLOW_CEILTRUNK_LOG_HORIZONTAL = new HorizontalHollowLogBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_LIGHT_GREEN).strength(2.0f, 4.0f).sound(SoundType.WOOD));
        VerticalHollowLogBlock HOLLOW_CEILTRUNK_LOG_VERTICAL = new VerticalHollowLogBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_LIGHT_GREEN).strength(2.0f, 4.0f).sound(SoundType.WOOD), this.hollowClimbableCeiltrunkLogHolder);
        ClimbableHollowLogBlock HOLLOW_CEILTRUNK_LOG_CLIMBABLE = new ClimbableHollowLogBlock(this.hollowVerticalCeiltrunkLogHolder, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_LIGHT_GREEN).strength(2.0f, 4.0f).sound(SoundType.WOOD));
        HorizontalHollowLogBlock HOLLOW_LUZAWOOD_LOG_HORIZONTAL = new HorizontalHollowLogBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_LIGHT_GREEN).strength(2.0f, 4.0f).sound(SoundType.WOOD));
        VerticalHollowLogBlock HOLLOW_LUZAWOOD_LOG_VERTICAL = new VerticalHollowLogBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_LIGHT_GREEN).strength(2.0f, 4.0f).sound(SoundType.WOOD), this.hollowClimbableLuzawoodLogHolder);
        ClimbableHollowLogBlock HOLLOW_LUZAWOOD_LOG_CLIMBABLE = new ClimbableHollowLogBlock(this.hollowVerticalLuzawoodLogHolder, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_LIGHT_GREEN).strength(2.0f, 4.0f).sound(SoundType.WOOD));
        this.hollowHorizontalCeiltrunkLogHolder = Holder.direct((Object)HOLLOW_CEILTRUNK_LOG_HORIZONTAL);
        this.hollowVerticalCeiltrunkLogHolder = Holder.direct((Object)HOLLOW_CEILTRUNK_LOG_VERTICAL);
        this.hollowClimbableCeiltrunkLogHolder = Holder.direct((Object)HOLLOW_CEILTRUNK_LOG_CLIMBABLE);
        this.hollowHorizontalLuzawoodLogHolder = Holder.direct((Object)HOLLOW_LUZAWOOD_LOG_HORIZONTAL);
        this.hollowVerticalLuzawoodLogHolder = Holder.direct((Object)HOLLOW_LUZAWOOD_LOG_VERTICAL);
        this.hollowClimbableLuzawoodLogHolder = Holder.direct((Object)HOLLOW_LUZAWOOD_LOG_CLIMBABLE);
        CeilandsRegistry.COMPAT_BLOCKS.add((Pair<ResourceLocation, Block>)new Pair((Object)CEILTRUNK_BANISTER_RES, (Object)CEILTRUNK_BANISTER));
        CeilandsRegistry.COMPAT_BLOCKS.add((Pair<ResourceLocation, Block>)new Pair((Object)LUZAWOOD_BANISTER_RES, (Object)LUZAWOOD_BANISTER));
        CeilandsRegistry.COMPAT_BLOCKS.add((Pair<ResourceLocation, Block>)new Pair((Object)ResourceLocation.fromNamespaceAndPath((String)"ceilands", (String)"hollow_ceiltrunk_log_horizontal"), (Object)HOLLOW_CEILTRUNK_LOG_HORIZONTAL));
        CeilandsRegistry.COMPAT_BLOCKS.add((Pair<ResourceLocation, Block>)new Pair((Object)ResourceLocation.fromNamespaceAndPath((String)"ceilands", (String)"hollow_ceiltrunk_log_vertical"), (Object)HOLLOW_CEILTRUNK_LOG_VERTICAL));
        CeilandsRegistry.COMPAT_BLOCKS.add((Pair<ResourceLocation, Block>)new Pair((Object)ResourceLocation.fromNamespaceAndPath((String)"ceilands", (String)"hollow_ceiltrunk_log_climbable"), (Object)HOLLOW_CEILTRUNK_LOG_CLIMBABLE));
        CeilandsRegistry.COMPAT_BLOCKS.add((Pair<ResourceLocation, Block>)new Pair((Object)ResourceLocation.fromNamespaceAndPath((String)"ceilands", (String)"hollow_luzawood_log_horizontal"), (Object)HOLLOW_LUZAWOOD_LOG_HORIZONTAL));
        CeilandsRegistry.COMPAT_BLOCKS.add((Pair<ResourceLocation, Block>)new Pair((Object)ResourceLocation.fromNamespaceAndPath((String)"ceilands", (String)"hollow_luzawood_log_vertical"), (Object)HOLLOW_LUZAWOOD_LOG_VERTICAL));
        CeilandsRegistry.COMPAT_BLOCKS.add((Pair<ResourceLocation, Block>)new Pair((Object)ResourceLocation.fromNamespaceAndPath((String)"ceilands", (String)"hollow_luzawood_log_climbable"), (Object)HOLLOW_LUZAWOOD_LOG_CLIMBABLE));
        CeilandsRegistry.COMPAT_ITEMS.add((Pair<ResourceLocation, Item>)new Pair((Object)CEILTRUNK_BANISTER_RES, (Object)new BlockItem((Block)CEILTRUNK_BANISTER, new Item.Properties())));
        CeilandsRegistry.COMPAT_ITEMS.add((Pair<ResourceLocation, Item>)new Pair((Object)LUZAWOOD_BANISTER_RES, (Object)new BlockItem((Block)LUZAWOOD_BANISTER, new Item.Properties())));
        CeilandsRegistry.COMPAT_ITEMS.add((Pair<ResourceLocation, Item>)new Pair((Object)CEILTRUNK_HOLLOW_LOG_RES, (Object)new HollowLogItem(this.hollowHorizontalCeiltrunkLogHolder, this.hollowVerticalCeiltrunkLogHolder, this.hollowClimbableCeiltrunkLogHolder, new Item.Properties())));
        CeilandsRegistry.COMPAT_ITEMS.add((Pair<ResourceLocation, Item>)new Pair((Object)LUZAWOOD_HOLLOW_LOG_RES, (Object)new HollowLogItem(this.hollowHorizontalCeiltrunkLogHolder, this.hollowVerticalLuzawoodLogHolder, this.hollowClimbableLuzawoodLogHolder, new Item.Properties())));
        CeilandsFlammableBlocks.CEILANDS_FLAMMABLE_BLOCKS.add((Triplet<Block, Integer, Integer>)new Triplet((Object)CEILTRUNK_BANISTER, (Object)5, (Object)20));
        CeilandsFlammableBlocks.CEILANDS_FLAMMABLE_BLOCKS.add((Triplet<Block, Integer, Integer>)new Triplet((Object)LUZAWOOD_BANISTER, (Object)5, (Object)20));
    }

    @SubscribeEvent
    public void assignItemsToTabs(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == TFCreativeTabs.BLOCKS.getKey()) {
            event.insertAfter(((BanisterBlock)TFBlocks.CHERRY_BANISTER.get()).asItem().getDefaultInstance(), ((Item)BuiltInRegistries.ITEM.get(CEILTRUNK_BANISTER_RES)).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Item)BuiltInRegistries.ITEM.get(CEILTRUNK_BANISTER_RES)).getDefaultInstance(), ((Item)BuiltInRegistries.ITEM.get(LUZAWOOD_BANISTER_RES)).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((HollowLogItem)TFItems.HOLLOW_CHERRY_LOG.get()).asItem().getDefaultInstance(), ((Item)BuiltInRegistries.ITEM.get(CEILTRUNK_HOLLOW_LOG_RES)).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Item)BuiltInRegistries.ITEM.get(CEILTRUNK_HOLLOW_LOG_RES)).getDefaultInstance(), ((Item)BuiltInRegistries.ITEM.get(LUZAWOOD_HOLLOW_LOG_RES)).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
    }
}

