/*
 * Decompiled with CFR 0.152.
 */
package com.kittehmod.ceilands.neoforge.neoforge.client;

import com.kittehmod.ceilands.neoforge.block.ModWoodType;
import com.kittehmod.ceilands.neoforge.client.CeilandsSkyEffect;
import com.kittehmod.ceilands.neoforge.client.ClientCommon;
import com.kittehmod.ceilands.neoforge.client.entity.model.CastleLordModel;
import com.kittehmod.ceilands.neoforge.client.renderer.CastleLordRenderer;
import com.kittehmod.ceilands.neoforge.neoforge.compat.TwilightForestCompat;
import com.kittehmod.ceilands.neoforge.registry.CeilandsBlocks;
import com.kittehmod.ceilands.neoforge.registry.CeilandsItems;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterDimensionSpecialEffectsEvent;
import oshi.util.tuples.Pair;

@EventBusSubscriber(modid="ceilands", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientHandler {
    public static void setupRenderers() {
        ClientCommon.initializeCommonClient();
        for (Pair<Block, RenderType> pair : ClientCommon.BLOCK_RENDERS) {
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)pair.getA()), (RenderType)((RenderType)pair.getB()));
        }
    }

    @SubscribeEvent
    public static void setupClient(FMLClientSetupEvent event) {
        ClientHandler.setupRenderers();
        event.enqueueWork(() -> {
            Sheets.addWoodType((WoodType)ModWoodType.CEILTRUNK);
            Sheets.addWoodType((WoodType)ModWoodType.LUZAWOOD);
        });
    }

    @SubscribeEvent
    public static void registerEntityLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(CastleLordRenderer.CASTLE_LORD_MODEL_LAYER, CastleLordModel::getBaseLayerDefinition);
        event.registerLayerDefinition(CastleLordRenderer.CASTLE_LORD_MODEL_INNER_ARMOR_LAYER, CastleLordModel::getInnerLayerDefinition);
        event.registerLayerDefinition(CastleLordRenderer.CASTLE_LORD_MODEL_OUTER_ARMOR_LAYER, CastleLordModel::getOuterLayerDefinition);
    }

    @SubscribeEvent
    public static void registerEntityLayers(RegisterDimensionSpecialEffectsEvent event) {
        event.register(CeilandsSkyEffect.CEILANDS_EFFECTS, (DimensionSpecialEffects)new CeilandsSkyEffect.CeilandsEffects());
    }

    @SubscribeEvent
    public static void registerBlockColours(RegisterColorHandlersEvent.Block event) {
        event.register((state, worldIn, pos, tintIndex) -> state != null && worldIn != null ? 0xCFFF00 : FoliageColor.getDefaultColor(), new Block[]{CeilandsBlocks.CEILTRUNK_LEAVES});
        event.register((state, worldIn, pos, tintIndex) -> 4637695, new Block[]{CeilandsBlocks.LUZAWOOD_LEAVES});
        if (ModList.get().isLoaded("twilightforest")) {
            event.register((state, worldIn, pos, tintIndex) -> state != null && worldIn != null ? BiomeColors.getAverageFoliageColor((BlockAndTintGetter)worldIn, (BlockPos)pos) : FoliageColor.getDefaultColor(), new Block[]{(Block)BuiltInRegistries.BLOCK.get(TwilightForestCompat.CEILTRUNK_HOLLOW_LOG_CLIMBABLE_RES), (Block)BuiltInRegistries.BLOCK.get(TwilightForestCompat.LUZAWOOD_HOLLOW_LOG_CLIMBABLE_RES)});
        }
    }

    @SubscribeEvent
    public static void registerItemColours(RegisterColorHandlersEvent.Item event) {
        BlockColors blockColours = event.getBlockColors();
        event.register((stack, tintIndex) -> {
            BlockState blockstate = ((BlockItem)stack.getItem()).getBlock().defaultBlockState();
            return blockColours.getColor(blockstate, (BlockAndTintGetter)null, (BlockPos)null, tintIndex);
        }, new ItemLike[]{CeilandsItems.CEILTRUNK_LEAVES, CeilandsItems.LUZAWOOD_LEAVES});
    }
}

