/*
 * Decompiled with CFR 0.152.
 */
package com.kittehmod.ceilands.neoforge.neoforge;

import com.google.common.collect.ImmutableSet;
import com.kittehmod.ceilands.neoforge.block.CeilandsFlammableBlocks;
import com.kittehmod.ceilands.neoforge.entity.mob.CastleLord;
import com.kittehmod.ceilands.neoforge.entity.mob.SpiderMonarch;
import com.kittehmod.ceilands.neoforge.neoforge.CompatsNeoForge;
import com.kittehmod.ceilands.neoforge.neoforge.compat.FarmersDelightCompat;
import com.kittehmod.ceilands.neoforge.neoforge.compat.TwilightForestCompat;
import com.kittehmod.ceilands.neoforge.registry.CeilandsBlockEntities;
import com.kittehmod.ceilands.neoforge.registry.CeilandsBlocks;
import com.kittehmod.ceilands.neoforge.registry.CeilandsEntities;
import com.kittehmod.ceilands.neoforge.registry.CeilandsFeatures;
import com.kittehmod.ceilands.neoforge.registry.CeilandsGameRules;
import com.kittehmod.ceilands.neoforge.registry.CeilandsItems;
import com.kittehmod.ceilands.neoforge.registry.CeilandsPOIType;
import com.kittehmod.ceilands.neoforge.registry.CeilandsTrunkPlacerType;
import com.kittehmod.ceilands.neoforge.util.CreativeModeTabDatabase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.registries.RegisterEvent;
import oshi.util.tuples.Pair;
import oshi.util.tuples.Quintet;
import oshi.util.tuples.Triplet;

public class CeilandsRegistry {
    public static final List<Pair<ResourceLocation, Block>> COMPAT_BLOCKS = new ArrayList<Pair<ResourceLocation, Block>>();
    public static final List<Pair<ResourceLocation, Item>> COMPAT_ITEMS = new ArrayList<Pair<ResourceLocation, Item>>();
    private static boolean initializedAdditional = false;

    @SubscribeEvent
    public static void register(RegisterEvent event) {
        event.register(Registries.BLOCK, registry -> {
            CeilandsBlocks.init();
            CeilandsRegistry.registerCompats();
            for (Pair<ResourceLocation, Block> pair : CeilandsBlocks.BLOCKS) {
                registry.register((ResourceLocation)pair.getA(), (Object)((Block)pair.getB()));
            }
            for (Pair<ResourceLocation, Block> pair : COMPAT_BLOCKS) {
                registry.register((ResourceLocation)pair.getA(), (Object)((Block)pair.getB()));
            }
        });
        event.register(Registries.ITEM, registry -> {
            CeilandsItems.init();
            for (Pair<ResourceLocation, Item> pair : CeilandsItems.ITEMS) {
                registry.register((ResourceLocation)pair.getA(), (Object)((Item)pair.getB()));
            }
            for (Pair<ResourceLocation, Item> pair : COMPAT_ITEMS) {
                registry.register((ResourceLocation)pair.getA(), (Object)((Item)pair.getB()));
            }
        });
        event.register(Registries.ENTITY_TYPE, registry -> {
            CeilandsItems.init();
            for (Pair<ResourceLocation, EntityType<?>> pair : CeilandsEntities.ENTITIES) {
                registry.register((ResourceLocation)pair.getA(), (Object)((EntityType)pair.getB()));
            }
        });
        event.register(Registries.BLOCK_ENTITY_TYPE, registry -> {
            CeilandsBlockEntities.init();
            for (Pair<ResourceLocation, BlockEntityType<?>> pair : CeilandsBlockEntities.BLOCK_ENTITIES) {
                registry.register((ResourceLocation)pair.getA(), (Object)((BlockEntityType)pair.getB()));
            }
        });
        event.register(Registries.FEATURE, registry -> {
            CeilandsFeatures.init();
            for (Pair<ResourceLocation, Feature<?>> pair : CeilandsFeatures.FEATURES) {
                registry.register((ResourceLocation)pair.getA(), (Object)((Feature)pair.getB()));
            }
        });
        event.register(Registries.TRUNK_PLACER_TYPE, registry -> {
            CeilandsTrunkPlacerType.init();
            for (Pair<ResourceLocation, TrunkPlacerType<?>> pair : CeilandsTrunkPlacerType.TRUNK_PLACERS) {
                registry.register((ResourceLocation)pair.getA(), (Object)((TrunkPlacerType)pair.getB()));
            }
        });
        event.register(Registries.POINT_OF_INTEREST_TYPE, registry -> registry.register(CeilandsPOIType.CEILANDS_PORTAL, (Object)new PoiType((Set)ImmutableSet.copyOf((Collection)CeilandsBlocks.CEILANDS_PORTAL.getStateDefinition().getPossibleStates()), 0, 1)));
        if (!initializedAdditional) {
            initializedAdditional = true;
            CeilandsGameRules.setup();
            CreativeModeTabDatabase.populateContents();
        }
    }

    @SubscribeEvent
    public static void registerEntityAttributes(EntityAttributeCreationEvent event) {
        event.put(CeilandsEntities.CASTLE_LORD, CastleLord.createAttributes().build());
        event.put(CeilandsEntities.SPIDER_MONARCH, SpiderMonarch.createAttributes().build());
    }

    protected static void registerCompats() {
        if (ModList.get().isLoaded("farmersdelight")) {
            new FarmersDelightCompat(true);
        }
        if (ModList.get().isLoaded("twilightforest")) {
            new TwilightForestCompat(true);
        }
    }

    protected static void registerFlammable() {
        for (Triplet<Block, Integer, Integer> entry : CeilandsFlammableBlocks.CEILANDS_FLAMMABLE_BLOCKS) {
            ((FireBlock)Blocks.FIRE).setFlammable((Block)entry.getA(), ((Integer)entry.getB()).intValue(), ((Integer)entry.getC()).intValue());
        }
    }

    protected static void registerFlowerPots() {
        ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(ResourceLocation.fromNamespaceAndPath((String)"ceilands", (String)"luzawood_sapling"), () -> CeilandsBlocks.POTTED_LUZAWOOD_SAPLING);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void assignItemsToTabs(BuildCreativeModeTabContentsEvent event) {
        ResourceKey tabKey = event.getTabKey();
        for (Quintet<Item, Item, CreativeModeTab.TabVisibility, Boolean, ResourceKey<CreativeModeTab>> quint : CreativeModeTabDatabase.ITEM_ENTRIES) {
            if (quint.getE() != tabKey) continue;
            if (quint.getA() == null) {
                event.accept((ItemLike)quint.getB());
                continue;
            }
            if (((Boolean)quint.getD()).booleanValue()) {
                event.insertAfter(((Item)quint.getA()).getDefaultInstance(), ((Item)quint.getB()).getDefaultInstance(), (CreativeModeTab.TabVisibility)quint.getC());
                continue;
            }
            event.insertBefore(((Item)quint.getA()).getDefaultInstance(), ((Item)quint.getB()).getDefaultInstance(), (CreativeModeTab.TabVisibility)quint.getC());
        }
        if (CompatsNeoForge.DRAMATIC_DOORS_INSTALLED && tabKey == CreativeModeTabs.BUILDING_BLOCKS) {
            event.insertBefore(CeilandsItems.CEILTRUNK_DOOR.getDefaultInstance(), ((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"short_ceiltrunk_door"))).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(CeilandsItems.CEILTRUNK_DOOR.getDefaultInstance(), ((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"tall_ceiltrunk_door"))).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertBefore(CeilandsItems.LUZAWOOD_DOOR.getDefaultInstance(), ((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"short_luzawood_door"))).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(CeilandsItems.LUZAWOOD_DOOR.getDefaultInstance(), ((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"tall_luzawood_door"))).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
    }
}

