/*
 * Decompiled with CFR 0.152.
 */
package com.kittehmod.ceilands.neoforge.neoforge;

import com.google.common.collect.ImmutableList;
import com.kittehmod.ceilands.neoforge.block.ModWoodType;
import com.kittehmod.ceilands.neoforge.neoforge.CeilandsRegistry;
import com.kittehmod.ceilands.neoforge.neoforge.CompatsNeoForge;
import com.kittehmod.ceilands.neoforge.neoforge.compat.FarmersDelightCompat;
import com.kittehmod.ceilands.neoforge.neoforge.compat.TwilightForestCompat;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import oshi.util.tuples.Quartet;

@Mod(value="ceilands")
public class CeilandsModNeoForge {
    public CeilandsModNeoForge(IEventBus bus, ModContainer container) {
        bus.register(CeilandsRegistry.class);
        bus.addListener(this::setupCommon);
        this.hookCompats(bus);
        bus.addListener(this::setupDataPacks);
    }

    private void hookCompats(IEventBus bus) {
        if (CompatsNeoForge.FARMERS_DELIGHT_INSTALLED) {
            bus.register((Object)new FarmersDelightCompat(false));
        }
        if (CompatsNeoForge.TWILIGHT_FOREST_INSTALLED) {
            bus.register((Object)new TwilightForestCompat(false));
        }
    }

    private void setupCommon(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> WoodType.register((WoodType)ModWoodType.CEILTRUNK));
        event.enqueueWork(() -> WoodType.register((WoodType)ModWoodType.LUZAWOOD));
        event.enqueueWork(() -> CeilandsRegistry.registerFlammable());
        event.enqueueWork(() -> CeilandsRegistry.registerFlowerPots());
    }

    public void setupDataPacks(AddPackFindersEvent event) {
        Quartet packFarmersDelight = new Quartet((Object)"farmersdelight", (Object)CompatsNeoForge.FARMERS_DELIGHT_INSTALLED, (Object)"datapacks/ceilands_fd_compat", (Object)"Ceilands - Farmers Delight Pack");
        Quartet packTwilightForest = new Quartet((Object)"twilightforet", (Object)CompatsNeoForge.TWILIGHT_FOREST_INSTALLED, (Object)"datapacks/ceilands_tf_compat", (Object)"Ceilands - Twilight Forest Pack");
        Quartet packBoatload = new Quartet((Object)"boatload", (Object)CompatsNeoForge.BOATLOAD_INSTALLED, (Object)"datapacks/ceilands_boatload_compat", (Object)"Ceilands - Boatload Pack");
        Quartet packWoodworks = new Quartet((Object)"woodworks", (Object)CompatsNeoForge.WOODWORKS_INSTALLED, (Object)"datapacks/ceilands_woodworks_compat", (Object)"Ceilands - Woodworks Pack");
        ImmutableList packs = ImmutableList.of((Object)packFarmersDelight, (Object)packTwilightForest, (Object)packBoatload, (Object)packWoodworks);
        if (event.getPackType() == PackType.SERVER_DATA) {
            for (Quartet packToCheck : packs) {
                if (!((Boolean)packToCheck.getB()).booleanValue()) continue;
                event.addPackFinders(ResourceLocation.fromNamespaceAndPath((String)"ceilands", (String)((String)packToCheck.getC())), PackType.SERVER_DATA, (Component)Component.literal((String)((String)packToCheck.getD())), PackSource.BUILT_IN, false, Pack.Position.TOP);
            }
        }
    }
}

