/*
 * Decompiled with CFR 0.152.
 */
package com.kittehmod.ceilands.neoforge.item;

import com.kittehmod.ceilands.neoforge.entity.vehicle.ModBoat;
import com.kittehmod.ceilands.neoforge.entity.vehicle.ModChestBoat;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ModBoatItem
extends Item {
    private static final Predicate<Entity> ENTITY_PREDICATE = EntitySelector.NO_SPECTATORS.and(Entity::isPickable);
    private final ModBoat.Type type;
    private final boolean hasChest;

    public ModBoatItem(boolean chest, ModBoat.Type typeIn, Item.Properties properties) {
        super(properties);
        this.type = typeIn;
        this.hasChest = chest;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        BlockHitResult hitresult = ModBoatItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (hitresult.getType() == HitResult.Type.MISS) {
            return InteractionResultHolder.pass((Object)itemstack);
        }
        Vec3 vec3 = player.getViewVector(1.0f);
        double d0 = 5.0;
        List list = level.getEntities((Entity)player, player.getBoundingBox().expandTowards(vec3.scale(d0)).inflate(1.0), ENTITY_PREDICATE);
        if (!list.isEmpty()) {
            Vec3 vec31 = player.getEyePosition();
            for (Entity entity : list) {
                AABB aabb = entity.getBoundingBox().inflate((double)entity.getPickRadius());
                if (!aabb.contains(vec31)) continue;
                return InteractionResultHolder.pass((Object)itemstack);
            }
        }
        if (hitresult.getType() == HitResult.Type.BLOCK) {
            ModBoat boat = this.getBoat(level, (HitResult)hitresult);
            boat.setType(this.type);
            boat.setYRot(player.getYRot());
            if (!level.noCollision((Entity)boat, boat.getBoundingBox())) {
                return InteractionResultHolder.fail((Object)itemstack);
            }
            if (!level.isClientSide) {
                level.addFreshEntity((Entity)boat);
                level.gameEvent((Entity)player, (Holder)GameEvent.ENTITY_PLACE, hitresult.getLocation());
                if (!player.getAbilities().instabuild) {
                    itemstack.shrink(1);
                }
            }
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)level.isClientSide());
        }
        return InteractionResultHolder.pass((Object)itemstack);
    }

    private ModBoat getBoat(Level level, HitResult result) {
        return this.hasChest ? new ModChestBoat(level, result.getLocation().x, result.getLocation().y, result.getLocation().z) : new ModBoat(level, result.getLocation().x, result.getLocation().y, result.getLocation().z);
    }
}

