/*
 * Decompiled with CFR 0.152.
 */
package com.kittehmod.ceilands.neoforge.item;

import com.kittehmod.ceilands.neoforge.block.CeilandsPortalBlock;
import com.kittehmod.ceilands.neoforge.registry.CeilandsBlocks;
import com.kittehmod.ceilands.neoforge.registry.CeilandsDimension;
import com.kittehmod.ceilands.neoforge.tags.CeilandsBlockTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.portal.PortalShape;

public class CeilandsPortalActivatorItem
extends Item {
    public CeilandsPortalActivatorItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos().relative(context.getClickedFace(), 1);
        BlockState state = level.getBlockState(pos);
        if (!level.isClientSide() && CeilandsPortalActivatorItem.inPortalDimension(level) && (CeilandsPortalActivatorItem.isPortal(level, pos, player.getDirection().getClockWise(), true) || CeilandsPortalActivatorItem.isPortal(level, pos, player.getDirection(), true))) {
            level.playSound(player, pos, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.4f + 0.8f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private static boolean inPortalDimension(Level level) {
        return level.dimension() == Level.OVERWORLD || level.dimension() == Level.NETHER || level.dimension() == CeilandsDimension.CEILANDS;
    }

    private static boolean isPortal(Level level, BlockPos pos, Direction dir, boolean setBlocks) {
        int j;
        int i;
        if (!CeilandsPortalActivatorItem.inPortalDimension(level)) {
            return false;
        }
        for (i = 0; i < 23; ++i) {
            for (j = 0; j < 23 && !level.getBlockState(pos.below(i).relative(dir, j)).is(CeilandsBlockTags.CEILANDS_PORTAL_FRAME_BLOCKS); ++j) {
                if (!level.getBlockState(pos.below(i).relative(dir, j)).is(CeilandsBlockTags.CEILANDS_PORTAL_REPLACEABLES)) {
                    return false;
                }
                if (j < 22) continue;
                return false;
            }
            for (j = 0; j < 23 && !level.getBlockState(pos.below(i).relative(dir.getOpposite(), j)).is(CeilandsBlockTags.CEILANDS_PORTAL_FRAME_BLOCKS); ++j) {
                if (!level.getBlockState(pos.below(i).relative(dir.getOpposite(), j)).is(CeilandsBlockTags.CEILANDS_PORTAL_REPLACEABLES)) {
                    return false;
                }
                if (j < 22) continue;
                return false;
            }
            if (level.getBlockState(pos.below(i)).is(CeilandsBlockTags.CEILANDS_PORTAL_FRAME_BLOCKS)) break;
            if (i < 22) continue;
            return false;
        }
        for (i = 0; i < 23; ++i) {
            for (j = 0; j < 23 && !level.getBlockState(pos.above(i).relative(dir, j)).is(CeilandsBlockTags.CEILANDS_PORTAL_FRAME_BLOCKS); ++j) {
                if (!level.getBlockState(pos.above(i).relative(dir, j)).is(CeilandsBlockTags.CEILANDS_PORTAL_REPLACEABLES)) {
                    return false;
                }
                if (j < 22) continue;
                return false;
            }
            for (j = 0; j < 23 && !level.getBlockState(pos.above(i).relative(dir.getOpposite(), j)).is(CeilandsBlockTags.CEILANDS_PORTAL_FRAME_BLOCKS); ++j) {
                if (!level.getBlockState(pos.above(i).relative(dir.getOpposite(), j)).is(CeilandsBlockTags.CEILANDS_PORTAL_REPLACEABLES)) {
                    return false;
                }
                if (j < 22) continue;
                return false;
            }
            if (level.getBlockState(pos.above(i)).is(CeilandsBlockTags.CEILANDS_PORTAL_FRAME_BLOCKS)) break;
            if (i < 22) continue;
            return false;
        }
        if (!setBlocks) {
            return true;
        }
        for (i = 0; i < 23; ++i) {
            for (j = 0; j < 23 && !level.getBlockState(pos.below(i).relative(dir, j)).is(CeilandsBlockTags.CEILANDS_PORTAL_FRAME_BLOCKS); ++j) {
                if (!level.getBlockState(pos.below(i).relative(dir, j)).is(CeilandsBlockTags.CEILANDS_PORTAL_REPLACEABLES)) continue;
                level.setBlock(pos.below(i).relative(dir, j), (BlockState)CeilandsBlocks.CEILANDS_PORTAL.defaultBlockState().setValue(CeilandsPortalBlock.AXIS, (Comparable)dir.getAxis()), 11);
            }
            for (j = 0; j < 23 && !level.getBlockState(pos.below(i).relative(dir.getOpposite(), j)).is(CeilandsBlockTags.CEILANDS_PORTAL_FRAME_BLOCKS); ++j) {
                if (!level.getBlockState(pos.below(i).relative(dir.getOpposite(), j)).is(CeilandsBlockTags.CEILANDS_PORTAL_REPLACEABLES)) continue;
                level.setBlock(pos.below(i).relative(dir.getOpposite(), j), (BlockState)CeilandsBlocks.CEILANDS_PORTAL.defaultBlockState().setValue(CeilandsPortalBlock.AXIS, (Comparable)dir.getAxis()), 11);
            }
            if (level.getBlockState(pos.below(i)).is(CeilandsBlockTags.CEILANDS_PORTAL_FRAME_BLOCKS)) break;
        }
        for (i = 0; i < 23; ++i) {
            for (j = 0; j < 23 && !level.getBlockState(pos.above(i).relative(dir, j)).is(CeilandsBlockTags.CEILANDS_PORTAL_FRAME_BLOCKS); ++j) {
                if (!level.getBlockState(pos.above(i).relative(dir, j)).is(CeilandsBlockTags.CEILANDS_PORTAL_REPLACEABLES)) continue;
                level.setBlock(pos.above(i).relative(dir, j), (BlockState)CeilandsBlocks.CEILANDS_PORTAL.defaultBlockState().setValue(CeilandsPortalBlock.AXIS, (Comparable)dir.getAxis()), 11);
            }
            for (j = 0; j < 23 && !level.getBlockState(pos.above(i).relative(dir.getOpposite(), j)).is(CeilandsBlockTags.CEILANDS_PORTAL_FRAME_BLOCKS); ++j) {
                if (!level.getBlockState(pos.above(i).relative(dir.getOpposite(), j)).is(CeilandsBlockTags.CEILANDS_PORTAL_REPLACEABLES)) continue;
                level.setBlock(pos.above(i).relative(dir.getOpposite(), j), (BlockState)CeilandsBlocks.CEILANDS_PORTAL.defaultBlockState().setValue(CeilandsPortalBlock.AXIS, (Comparable)dir.getAxis()), 11);
            }
            if (level.getBlockState(pos.above(i)).is(CeilandsBlockTags.CEILANDS_PORTAL_FRAME_BLOCKS)) break;
        }
        return true;
    }

    private static boolean isPortal(Level level, BlockPos pos, Direction dir) {
        if (!CeilandsPortalActivatorItem.inPortalDimension(level)) {
            return false;
        }
        BlockPos.MutableBlockPos $$3 = pos.mutable();
        boolean $$4 = false;
        for (Direction $$5 : Direction.values()) {
            if (!level.getBlockState((BlockPos)$$3.set((Vec3i)pos).move($$5)).is(CeilandsBlockTags.CEILANDS_PORTAL_FRAME_BLOCKS)) continue;
            $$4 = true;
            break;
        }
        if (!$$4) {
            return false;
        }
        Direction.Axis $$6 = dir.getAxis().isHorizontal() ? dir.getCounterClockWise().getAxis() : Direction.Plane.HORIZONTAL.getRandomAxis(level.random);
        return PortalShape.findEmptyPortalShape((LevelAccessor)level, (BlockPos)pos, (Direction.Axis)$$6).isPresent();
    }
}

