/*
 * Decompiled with CFR 0.152.
 */
package com.kittehmod.ceilands.neoforge.item;

import com.google.common.base.Suppliers;
import java.util.function.Supplier;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public enum CeilandsItemTiers implements Tier
{
    CEILINIUM((TagKey<Block>)BlockTags.INCORRECT_FOR_DIAMOND_TOOL, 768, 7.0f, 3.0f, 16, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_INGOT}));

    private final TagKey<Block> incorrectBlocksForDrops;
    private final int uses;
    private final float speed;
    private final float damage;
    private final int enchantmentValue;
    private final Supplier<Ingredient> repairIngredient;

    private CeilandsItemTiers(TagKey<Block> tagKey, int usesIn, float speedIn, float damageIn, int enchIn, Supplier<Ingredient> repairIngredient) {
        this.incorrectBlocksForDrops = tagKey;
        this.uses = usesIn;
        this.speed = speedIn;
        this.damage = damageIn;
        this.enchantmentValue = enchIn;
        this.repairIngredient = Suppliers.memoize(repairIngredient::get);
    }

    public int getUses() {
        return this.uses;
    }

    public float getSpeed() {
        return this.speed;
    }

    public float getAttackDamageBonus() {
        return this.damage;
    }

    public TagKey<Block> getIncorrectBlocksForDrops() {
        return this.incorrectBlocksForDrops;
    }

    public int getEnchantmentValue() {
        return this.enchantmentValue;
    }

    public Ingredient getRepairIngredient() {
        return this.repairIngredient.get();
    }
}

