/*
 * Decompiled with CFR 0.152.
 */
package com.kittehmod.ceilands.neoforge.entity.vehicle;

import com.kittehmod.ceilands.neoforge.registry.CeilandsBlocks;
import com.kittehmod.ceilands.neoforge.registry.CeilandsEntities;
import com.kittehmod.ceilands.neoforge.registry.CeilandsItems;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class ModBoat
extends Boat {
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE = SynchedEntityData.defineId(ModBoat.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public ModBoat(EntityType<? extends ModBoat> p_38290_, Level level) {
        super(p_38290_, level);
    }

    public ModBoat(Level p_219872_, double p_219873_, double p_219874_, double p_219875_) {
        this(CeilandsEntities.CEILANDS_BOAT, p_219872_);
        this.setPos(p_219873_, p_219874_, p_219875_);
        this.xo = p_219873_;
        this.yo = p_219874_;
        this.zo = p_219875_;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_ID_TYPE, (Object)Type.CEILTRUNK.ordinal());
    }

    protected void addAdditionalSaveData(CompoundTag p_38359_) {
        p_38359_.putString("Type", this.getCeilandsBoatType().getName());
    }

    protected void readAdditionalSaveData(CompoundTag p_38338_) {
        if (p_38338_.contains("Type", 8)) {
            this.setType(Type.byName(p_38338_.getString("Type")));
        }
    }

    public void setType(Type typeIn) {
        this.entityData.set(DATA_ID_TYPE, (Object)typeIn.ordinal());
    }

    public Type getCeilandsBoatType() {
        return Type.byId((Integer)this.entityData.get(DATA_ID_TYPE));
    }

    public Item getDropItem() {
        switch (this.getCeilandsBoatType().ordinal()) {
            default: {
                return CeilandsItems.CEILTRUNK_BOAT;
            }
            case 1: 
        }
        return CeilandsItems.LUZAWOOD_BOAT;
    }

    public static enum Type {
        CEILTRUNK(CeilandsBlocks.CEILTRUNK_PLANKS, "ceiltrunk"),
        LUZAWOOD(CeilandsBlocks.LUZAWOOD_PLANKS, "luzawood");

        private final String name;
        private final Block planks;

        private Type(Block p_38427_, String p_38428_) {
            this.name = p_38428_;
            this.planks = p_38427_;
        }

        public String getName() {
            return this.name;
        }

        public Block getPlanks() {
            return this.planks;
        }

        public String toString() {
            return this.name;
        }

        public static Type byId(int p_38431_) {
            Type[] aboat$type = Type.values();
            if (p_38431_ < 0 || p_38431_ >= aboat$type.length) {
                p_38431_ = 0;
            }
            return aboat$type[p_38431_];
        }

        public static Type byName(String p_38433_) {
            Type[] aboat$type = Type.values();
            for (int i = 0; i < aboat$type.length; ++i) {
                if (!aboat$type[i].getName().equals(p_38433_)) continue;
                return aboat$type[i];
            }
            return aboat$type[0];
        }
    }
}

