/*
 * Decompiled with CFR 0.152.
 */
package com.kittehmod.ceilands.neoforge.client.renderer;

import com.google.common.collect.ImmutableMap;
import com.kittehmod.ceilands.neoforge.entity.vehicle.ModBoat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import org.joml.Quaternionf;

public class CeilandsBoatRenderer
extends EntityRenderer<ModBoat> {
    private final Map<ModBoat.Type, Pair<ResourceLocation, BoatModel>> boatResources;

    public CeilandsBoatRenderer(EntityRendererProvider.Context context, boolean isChest) {
        super(context);
        this.shadowRadius = 0.8f;
        this.boatResources = (Map)Stream.of(ModBoat.Type.values()).collect(ImmutableMap.toImmutableMap(map -> map, boattype -> Pair.of((Object)ResourceLocation.fromNamespaceAndPath((String)"ceilands", (String)CeilandsBoatRenderer.getTextureLocation(boattype, isChest)), (Object)this.createBoatModel(context, (ModBoat.Type)((Object)boattype), isChest))));
    }

    private BoatModel createBoatModel(EntityRendererProvider.Context context, ModBoat.Type boatType, boolean isChest) {
        ModelLayerLocation modellayerlocation = isChest ? CeilandsBoatRenderer.createChestBoatModelName(boatType) : CeilandsBoatRenderer.createBoatModelName(boatType);
        ModelPart modelpart = context.bakeLayer(modellayerlocation);
        return isChest ? new ChestBoatModel(modelpart) : new BoatModel(modelpart);
    }

    private static String getTextureLocation(ModBoat.Type boatType, boolean isChest) {
        return isChest ? "textures/entity/chest_boat/" + boatType.getName() + ".png" : "textures/entity/boat/" + boatType.getName() + ".png";
    }

    public void render(ModBoat entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        float f2;
        matrixStackIn.pushPose();
        matrixStackIn.translate(0.0, 0.375, 0.0);
        matrixStackIn.mulPose(Axis.YP.rotationDegrees(180.0f - entityYaw));
        float f = (float)entityIn.getHurtTime() - partialTicks;
        float f1 = entityIn.getDamage() - partialTicks;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f > 0.0f) {
            matrixStackIn.mulPose(Axis.XP.rotationDegrees(Mth.sin((float)f) * f * f1 / 10.0f * (float)entityIn.getHurtDir()));
        }
        if (!Mth.equal((float)(f2 = entityIn.getBubbleAngle(partialTicks)), (float)0.0f)) {
            matrixStackIn.mulPose(new Quaternionf().setAngleAxis(entityIn.getBubbleAngle(partialTicks) * ((float)Math.PI / 180), 1.0f, 0.0f, 1.0f));
        }
        Pair<ResourceLocation, BoatModel> pair = this.getModelWithLocation(entityIn);
        ResourceLocation resourcelocation = (ResourceLocation)pair.getFirst();
        BoatModel boatmodel = (BoatModel)pair.getSecond();
        matrixStackIn.scale(-1.0f, -1.0f, 1.0f);
        matrixStackIn.mulPose(Axis.YP.rotationDegrees(90.0f));
        boatmodel.setupAnim((Boat)entityIn, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexconsumer = bufferIn.getBuffer(boatmodel.renderType(resourcelocation));
        boatmodel.renderToBuffer(matrixStackIn, vertexconsumer, packedLightIn, OverlayTexture.NO_OVERLAY);
        if (!entityIn.isUnderWater()) {
            VertexConsumer vertexconsumer1 = bufferIn.getBuffer(RenderType.waterMask());
            boatmodel.waterPatch().render(matrixStackIn, vertexconsumer1, packedLightIn, OverlayTexture.NO_OVERLAY);
        }
        matrixStackIn.popPose();
        super.render((Entity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    public ResourceLocation getTextureLocation(ModBoat entity) {
        switch (entity.getCeilandsBoatType()) {
            case CEILTRUNK: {
                return ResourceLocation.parse((String)"ceilands:textures/entity/boat/ceiltrunk.png");
            }
        }
        return ResourceLocation.parse((String)"ceilands:textures/entity/boat/luzawood.png");
    }

    public Pair<ResourceLocation, BoatModel> getModelWithLocation(ModBoat boat) {
        return this.boatResources.get((Object)boat.getCeilandsBoatType());
    }

    private static ModelLayerLocation createLocation(String path, String p_171302_) {
        return new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)path), p_171302_);
    }

    public static ModelLayerLocation createBoatModelName(ModBoat.Type p_171290_) {
        return CeilandsBoatRenderer.createLocation("boat/oak", "main");
    }

    public static ModelLayerLocation createChestBoatModelName(ModBoat.Type p_233551_) {
        return CeilandsBoatRenderer.createLocation("chest_boat/oak", "main");
    }
}

