/*
 * Decompiled with CFR 0.152.
 */
package com.kittehmod.ceilands.neoforge.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class CeilandsSkyEffect {
    public static final ResourceLocation CEILANDS_EFFECTS = ResourceLocation.fromNamespaceAndPath((String)"ceilands", (String)"the_ceilands");
    private static final ResourceLocation MOON_LOCATION = ResourceLocation.parse((String)"textures/environment/moon_phases.png");
    private static final ResourceLocation SUN_LOCATION = ResourceLocation.parse((String)"textures/environment/sun.png");

    public static class CeilandsEffects
    extends DimensionSpecialEffects {
        public CeilandsEffects() {
            super(-5.0f, false, DimensionSpecialEffects.SkyType.NORMAL, false, false);
        }

        public Vec3 getBrightnessDependentFogColor(Vec3 vec3, float fl) {
            return vec3.multiply((double)(fl * 0.94f + 0.06f), (double)(fl * 0.94f + 0.06f), (double)(fl * 0.91f + 0.09f));
        }

        public boolean isFoggyAt(int int1, int yPos) {
            return false;
        }

        public float[] getSunriseColor(float time, float p_108873_) {
            return super.getSunriseColor(time + 0.5f, p_108873_);
        }

        public static void renderCeilandsSky(ClientLevel level, Matrix4f cameraMatrix, Matrix4f projectionMatrix, float partialTick, Camera camera, boolean isFoggy, Runnable runnable) {
            FogType fogtype;
            runnable.run();
            Minecraft minecraft = Minecraft.getInstance();
            if (!isFoggy && (fogtype = camera.getFluidInCamera()) != FogType.POWDER_SNOW && fogtype != FogType.LAVA && !CeilandsEffects.doesMobEffectBlockSky(camera)) {
                PoseStack posestack = new PoseStack();
                posestack.mulPose(cameraMatrix);
                Vec3 vec3 = level.getSkyColor(minecraft.gameRenderer.getMainCamera().getPosition(), partialTick);
                float f = (float)vec3.x;
                float f1 = (float)vec3.y;
                float f2 = (float)vec3.z;
                FogRenderer.levelFogColor();
                Tesselator tesselator = Tesselator.getInstance();
                BufferBuilder bufferbuilder = null;
                RenderSystem.depthMask((boolean)false);
                RenderSystem.setShaderColor((float)f, (float)f1, (float)f2, (float)1.0f);
                ShaderInstance shaderinstance = RenderSystem.getShader();
                minecraft.levelRenderer.skyBuffer.bind();
                minecraft.levelRenderer.skyBuffer.drawWithShader(posestack.last().pose(), projectionMatrix, shaderinstance);
                VertexBuffer.unbind();
                RenderSystem.enableBlend();
                float[] afloat = level.effects().getSunriseColor(level.getTimeOfDay(partialTick), partialTick);
                if (afloat != null) {
                    RenderSystem.setShader(GameRenderer::getPositionColorShader);
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    posestack.pushPose();
                    posestack.mulPose(Axis.XP.rotationDegrees(90.0f));
                    float f3 = Mth.sin((float)level.getSunAngle(partialTick)) < 0.0f ? 180.0f : 0.0f;
                    posestack.mulPose(Axis.ZP.rotationDegrees(-f3));
                    posestack.mulPose(Axis.ZP.rotationDegrees(-90.0f));
                    float f4 = afloat[0];
                    float f5 = afloat[1];
                    float f6 = afloat[2];
                    Matrix4f matrix4f = posestack.last().pose();
                    bufferbuilder = tesselator.begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_COLOR);
                    bufferbuilder.addVertex(matrix4f, 0.0f, 100.0f, 0.0f).setColor(f4, f5, f6, afloat[3]);
                    int i = 16;
                    for (int j = 0; j <= i; ++j) {
                        float f7 = (float)j * ((float)Math.PI * 2) / 16.0f;
                        float f8 = Mth.sin((float)f7);
                        float f9 = Mth.cos((float)f7);
                        bufferbuilder.addVertex(matrix4f, f8 * 120.0f, f9 * 120.0f, -f9 * 40.0f * afloat[3]).setColor(afloat[0], afloat[1], afloat[2], 0.0f);
                    }
                    BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
                    posestack.popPose();
                }
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                posestack.pushPose();
                float f11 = 1.0f - level.getRainLevel(partialTick);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)f11);
                posestack.mulPose(Axis.YP.rotationDegrees(-90.0f));
                posestack.mulPose(Axis.XP.rotationDegrees(level.getTimeOfDay(partialTick + 0.5f) * -360.0f + 180.0f));
                Matrix4f matrix4f1 = posestack.last().pose();
                float f12 = 30.0f;
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)SUN_LOCATION);
                bufferbuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                bufferbuilder.addVertex(matrix4f1, -f12, 100.0f, -f12).setUv(0.0f, 0.0f);
                bufferbuilder.addVertex(matrix4f1, f12, 100.0f, -f12).setUv(1.0f, 0.0f);
                bufferbuilder.addVertex(matrix4f1, f12, 100.0f, f12).setUv(1.0f, 1.0f);
                bufferbuilder.addVertex(matrix4f1, -f12, 100.0f, f12).setUv(0.0f, 1.0f);
                BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
                f12 = 20.0f;
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)MOON_LOCATION);
                int k = level.getMoonPhase();
                int l = k % 4;
                int i1 = k / 4 % 2;
                float f13 = (float)(l + 0) / 4.0f;
                float f14 = (float)(i1 + 0) / 2.0f;
                float f15 = (float)(l + 1) / 4.0f;
                float f16 = (float)(i1 + 1) / 2.0f;
                bufferbuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                bufferbuilder.addVertex(matrix4f1, -f12, -100.0f, f12).setUv(f15, f16);
                bufferbuilder.addVertex(matrix4f1, f12, -100.0f, f12).setUv(f13, f16);
                bufferbuilder.addVertex(matrix4f1, f12, -100.0f, -f12).setUv(f13, f14);
                bufferbuilder.addVertex(matrix4f1, -f12, -100.0f, -f12).setUv(f15, f14);
                BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
                float f10 = level.getStarBrightness(partialTick) * f11;
                if (f10 > 0.0f) {
                    RenderSystem.setShaderColor((float)f10, (float)f10, (float)f10, (float)f10);
                    FogRenderer.setupNoFog();
                    minecraft.levelRenderer.starBuffer.bind();
                    minecraft.levelRenderer.starBuffer.drawWithShader(posestack.last().pose(), projectionMatrix, GameRenderer.getPositionShader());
                    VertexBuffer.unbind();
                    runnable.run();
                }
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.disableBlend();
                RenderSystem.defaultBlendFunc();
                posestack.popPose();
                RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.depthMask((boolean)true);
            }
        }

        public static boolean doesMobEffectBlockSky(Camera camera) {
            Entity entity = camera.getEntity();
            if (!(entity instanceof LivingEntity)) {
                return false;
            }
            LivingEntity livingentity = (LivingEntity)entity;
            return livingentity.hasEffect(MobEffects.BLINDNESS) || livingentity.hasEffect(MobEffects.DARKNESS);
        }
    }
}

