/*
 * Decompiled with CFR 0.152.
 */
package com.kittehmod.ceilands.neoforge.block;

import com.kittehmod.ceilands.neoforge.Ceilands;
import com.kittehmod.ceilands.neoforge.registry.CeilandsBlocks;
import com.kittehmod.ceilands.neoforge.registry.CeilandsDimension;
import com.kittehmod.ceilands.neoforge.tags.CeilandsBlockTags;
import com.kittehmod.ceilands.neoforge.util.CeilandsPortalForcer;
import java.util.Optional;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.level.portal.PortalShape;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CeilandsPortalBlock
extends Block
implements Portal {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.HORIZONTAL_AXIS;
    protected static final int AABB_OFFSET = 2;
    protected static final VoxelShape X_AXIS_AABB = Block.box((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    protected static final VoxelShape Z_AXIS_AABB = Block.box((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);

    public CeilandsPortalBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(AXIS, (Comparable)Direction.Axis.X));
    }

    public BlockState updateShape(BlockState currentState, Direction dir, BlockState newState, LevelAccessor level, BlockPos pos1, BlockPos pos2) {
        Direction.Axis $$6 = dir.getAxis();
        Direction.Axis $$7 = (Direction.Axis)currentState.getValue(AXIS);
        boolean $$8 = $$7 != $$6 && $$6.isHorizontal();
        return !$$8 && !newState.is((Block)this) && !new PortalShape(level, pos1, $$7).isComplete() ? Blocks.AIR.defaultBlockState() : super.updateShape(currentState, dir, newState, level, pos1, pos2);
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        switch ((Direction.Axis)state.getValue(AXIS)) {
            case Z: {
                return Z_AXIS_AABB;
            }
        }
        return X_AXIS_AABB;
    }

    public boolean canPortalBlockStay(LevelAccessor level, BlockPos pos) {
        boolean flag = true;
        if (!level.getBlockState(pos.above()).is(CeilandsBlockTags.CEILANDS_PORTAL_FRAME_BLOCKS) && !level.getBlockState(pos.above()).is(CeilandsBlocks.CEILANDS_PORTAL)) {
            flag = false;
        }
        if (!level.getBlockState(pos.below()).is(CeilandsBlockTags.CEILANDS_PORTAL_FRAME_BLOCKS) && !level.getBlockState(pos.below()).is(CeilandsBlocks.CEILANDS_PORTAL)) {
            flag = false;
        }
        if (!level.getBlockState(pos.relative(Direction.fromAxisAndDirection((Direction.Axis)((Direction.Axis)level.getBlockState(pos).getValue(AXIS)), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE), 1)).is(CeilandsBlockTags.CEILANDS_PORTAL_FRAME_BLOCKS) && !level.getBlockState(pos.relative(Direction.fromAxisAndDirection((Direction.Axis)((Direction.Axis)level.getBlockState(pos).getValue(AXIS)), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE), 1)).is(CeilandsBlocks.CEILANDS_PORTAL)) {
            flag = false;
        }
        if (!level.getBlockState(pos.relative(Direction.fromAxisAndDirection((Direction.Axis)((Direction.Axis)level.getBlockState(pos).getValue(AXIS)), (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE), 1)).is(CeilandsBlockTags.CEILANDS_PORTAL_FRAME_BLOCKS) && !level.getBlockState(pos.relative(Direction.fromAxisAndDirection((Direction.Axis)((Direction.Axis)level.getBlockState(pos).getValue(AXIS)), (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE), 1)).is(CeilandsBlocks.CEILANDS_PORTAL)) {
            flag = false;
        }
        return flag;
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity.canUsePortal(false)) {
            entity.setAsInsidePortal((Portal)this, pos);
        }
    }

    public int getPortalTransitionTime(ServerLevel $$0, Entity $$1) {
        int n;
        if ($$1 instanceof Player) {
            Player $$2 = (Player)$$1;
            n = Math.max(1, $$0.getGameRules().getInt($$2.getAbilities().invulnerable ? GameRules.RULE_PLAYERS_NETHER_PORTAL_CREATIVE_DELAY : GameRules.RULE_PLAYERS_NETHER_PORTAL_DEFAULT_DELAY));
        } else {
            n = 0;
        }
        return n;
    }

    public DimensionTransition getPortalDestination(ServerLevel level, Entity entity, BlockPos pos) {
        ResourceKey<Level> resourcekey = level.dimension() == CeilandsDimension.CEILANDS ? Level.OVERWORLD : CeilandsDimension.CEILANDS;
        ServerLevel serverlevel = level.getServer().getLevel(resourcekey);
        if (serverlevel == null) {
            return null;
        }
        boolean flag = serverlevel.dimension() == CeilandsDimension.CEILANDS;
        WorldBorder worldborder = serverlevel.getWorldBorder();
        double d0 = DimensionType.getTeleportationScale((DimensionType)level.dimensionType(), (DimensionType)serverlevel.dimensionType());
        BlockPos blockpos = worldborder.clampToBounds(entity.getX() * d0, entity.getY(), entity.getZ() * d0);
        return this.getExitPortal(serverlevel, entity, pos, blockpos, flag, worldborder);
    }

    @Nullable
    private DimensionTransition getExitPortal(ServerLevel level, Entity entity, BlockPos pos1, BlockPos pos2, boolean p_350326_, WorldBorder border) {
        DimensionTransition.PostDimensionTransition dimensiontransition$postdimensiontransition;
        BlockUtil.FoundRectangle blockutil$foundrectangle;
        CeilandsPortalForcer forcer = new CeilandsPortalForcer(level);
        Optional optional = forcer.findClosestPortalPosition(pos2, p_350326_, border);
        if (optional.isPresent()) {
            BlockPos blockpos = (BlockPos)optional.get();
            BlockState blockstate = level.getBlockState(blockpos);
            blockutil$foundrectangle = BlockUtil.getLargestRectangleAround((BlockPos)blockpos, (Direction.Axis)((Direction.Axis)blockstate.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS)), (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, pos -> level.getBlockState(pos) == blockstate);
            dimensiontransition$postdimensiontransition = DimensionTransition.PLAY_PORTAL_SOUND.then(p_351967_ -> p_351967_.placePortalTicket(blockpos));
        } else {
            Direction.Axis direction$axis = entity.level().getBlockState(pos1).getOptionalValue(AXIS).orElse(Direction.Axis.X);
            Optional optional1 = forcer.createPortal(pos2, direction$axis);
            if (optional1.isEmpty()) {
                Ceilands.LOGGER.error("Unable to create a portal, likely target out of worldborder");
                return null;
            }
            blockutil$foundrectangle = (BlockUtil.FoundRectangle)optional1.get();
            dimensiontransition$postdimensiontransition = DimensionTransition.PLAY_PORTAL_SOUND.then(DimensionTransition.PLACE_PORTAL_TICKET);
        }
        return CeilandsPortalBlock.getDimensionTransitionFromExit(entity, pos1, blockutil$foundrectangle, level, dimensiontransition$postdimensiontransition);
    }

    private static DimensionTransition getDimensionTransitionFromExit(Entity p_350906_, BlockPos p_350376_, BlockUtil.FoundRectangle p_350428_, ServerLevel p_350928_, DimensionTransition.PostDimensionTransition p_352093_) {
        Vec3 vec3;
        Direction.Axis direction$axis;
        BlockState blockstate = p_350906_.level().getBlockState(p_350376_);
        if (blockstate.hasProperty((Property)BlockStateProperties.HORIZONTAL_AXIS)) {
            direction$axis = (Direction.Axis)blockstate.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS);
            BlockUtil.FoundRectangle blockutil$foundrectangle = BlockUtil.getLargestRectangleAround((BlockPos)p_350376_, (Direction.Axis)direction$axis, (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, p_351016_ -> p_350906_.level().getBlockState(p_351016_) == blockstate);
            vec3 = p_350906_.getRelativePortalPosition(direction$axis, blockutil$foundrectangle);
        } else {
            direction$axis = Direction.Axis.X;
            vec3 = new Vec3(0.5, 0.0, 0.0);
        }
        return CeilandsPortalBlock.createDimensionTransition(p_350928_, p_350428_, direction$axis, vec3, p_350906_, p_350906_.getDeltaMovement(), p_350906_.getYRot(), p_350906_.getXRot(), p_352093_);
    }

    private static DimensionTransition createDimensionTransition(ServerLevel level, BlockUtil.FoundRectangle rectangle, Direction.Axis axis, Vec3 p_351020_, Entity entity, Vec3 p_350266_, float p_350648_, float p_350338_, DimensionTransition.PostDimensionTransition p_352441_) {
        BlockPos blockpos = rectangle.minCorner;
        BlockState blockstate = level.getBlockState(blockpos);
        Direction.Axis direction$axis = blockstate.getOptionalValue((Property)BlockStateProperties.HORIZONTAL_AXIS).orElse(Direction.Axis.X);
        double d0 = rectangle.axis1Size;
        double d1 = rectangle.axis2Size;
        EntityDimensions entitydimensions = entity.getDimensions(entity.getPose());
        int i = axis == direction$axis ? 0 : 90;
        Vec3 vec3 = axis == direction$axis ? p_350266_ : new Vec3(p_350266_.z, p_350266_.y, -p_350266_.x);
        double d2 = (double)entitydimensions.width() / 2.0 + (d0 - (double)entitydimensions.width()) * p_351020_.x();
        double d3 = (d1 - (double)entitydimensions.height()) * p_351020_.y();
        double d4 = 0.5 + p_351020_.z();
        boolean flag = direction$axis == Direction.Axis.X;
        Vec3 vec31 = new Vec3((double)blockpos.getX() + (flag ? d2 : d4), (double)blockpos.getY() + d3, (double)blockpos.getZ() + (flag ? d4 : d2));
        Vec3 vec32 = PortalShape.findCollisionFreePosition((Vec3)vec31, (ServerLevel)level, (Entity)entity, (EntityDimensions)entitydimensions);
        return new DimensionTransition(level, vec32, vec3, p_350648_ + (float)i, p_350338_, p_352441_);
    }

    public Portal.Transition getLocalTransition() {
        return Portal.Transition.CONFUSION;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (random.nextInt(100) == 0) {
            level.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.PORTAL_AMBIENT, SoundSource.BLOCKS, 0.5f, random.nextFloat() * 0.4f + 0.8f, false);
        }
        for (int i = 0; i < 4; ++i) {
            double d0 = (double)pos.getX() + random.nextDouble();
            double d1 = (double)pos.getY() + random.nextDouble();
            double d2 = (double)pos.getZ() + random.nextDouble();
            double d3 = ((double)random.nextFloat() - 0.5) * 0.5;
            double d4 = ((double)random.nextFloat() - 0.5) * 0.5;
            double d5 = ((double)random.nextFloat() - 0.5) * 0.5;
            int j = random.nextInt(2) * 2 - 1;
            if (!level.getBlockState(pos.west()).is((Block)this) && !level.getBlockState(pos.east()).is((Block)this)) {
                d0 = (double)pos.getX() + 0.5 + 0.25 * (double)j;
                d3 = random.nextFloat() * 2.0f * (float)j;
            } else {
                d2 = (double)pos.getZ() + 0.5 + 0.25 * (double)j;
                d5 = random.nextFloat() * 2.0f * (float)j;
            }
            level.addParticle((ParticleOptions)ParticleTypes.PORTAL, d0, d1, d2, d3, d4, d5);
        }
    }

    public ItemStack getCloneItemStack(BlockGetter p_54911_, BlockPos p_54912_, BlockState p_54913_) {
        return ItemStack.EMPTY;
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        switch (rotation) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((Direction.Axis)state.getValue(AXIS)) {
                    case Z: {
                        return (BlockState)state.setValue(AXIS, (Comparable)Direction.Axis.X);
                    }
                    case X: {
                        return (BlockState)state.setValue(AXIS, (Comparable)Direction.Axis.Z);
                    }
                }
                return state;
            }
        }
        return state;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AXIS});
    }
}

