/*
 * Decompiled with CFR 0.152.
 */
package com.kittehmod.ceilands.fabric.fabric;

import com.kittehmod.ceilands.fabric.block.CeilandsFlammableBlocks;
import com.kittehmod.ceilands.fabric.block.ModWoodType;
import com.kittehmod.ceilands.fabric.entity.mob.CastleLord;
import com.kittehmod.ceilands.fabric.entity.mob.SpiderMonarch;
import com.kittehmod.ceilands.fabric.fabric.CompatsFabric;
import com.kittehmod.ceilands.fabric.item.CeilandsFuels;
import com.kittehmod.ceilands.fabric.registry.CeilandsBlockEntities;
import com.kittehmod.ceilands.fabric.registry.CeilandsBlocks;
import com.kittehmod.ceilands.fabric.registry.CeilandsEntities;
import com.kittehmod.ceilands.fabric.registry.CeilandsFeatures;
import com.kittehmod.ceilands.fabric.registry.CeilandsGameRules;
import com.kittehmod.ceilands.fabric.registry.CeilandsItems;
import com.kittehmod.ceilands.fabric.registry.CeilandsSoundEvents;
import com.kittehmod.ceilands.fabric.registry.CeilandsTrunkPlacerType;
import com.kittehmod.ceilands.fabric.util.CreativeModeTabDatabase;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroupEntries;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.fabricmc.fabric.api.object.builder.v1.world.poi.PointOfInterestHelper;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.fabricmc.fabric.api.registry.StrippableBlockRegistry;
import net.minecraft.class_1299;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3031;
import net.minecraft.class_3414;
import net.minecraft.class_4719;
import net.minecraft.class_5132;
import net.minecraft.class_5142;
import net.minecraft.class_5321;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import oshi.util.tuples.Pair;
import oshi.util.tuples.Quintet;
import oshi.util.tuples.Triplet;

public class CeilandsRegistry {
    public static void initializeRegistry() {
        CeilandsRegistry.registerModContent();
        CeilandsRegistry.registerPOITypes();
        CeilandsRegistry.registerWoodTypes();
        CeilandsRegistry.registerStrippables();
        CeilandsRegistry.registerFuels();
        CeilandsRegistry.registerFlammableBlocks();
        CeilandsGameRules.setup();
        CreativeModeTabDatabase.populateContents();
        CeilandsRegistry.assignItemsToTabs();
        CeilandsRegistry.registerMobAttributes();
    }

    private static void initializeModContent() {
        CeilandsBlocks.init();
        CeilandsItems.init();
        CeilandsEntities.init();
        CeilandsBlockEntities.init();
        CeilandsFeatures.init();
        CeilandsTrunkPlacerType.init();
        CeilandsSoundEvents.init();
    }

    public static void registerModContent() {
        CeilandsRegistry.initializeModContent();
        for (Pair<class_2960, class_2248> pair : CeilandsBlocks.BLOCKS) {
            class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)((class_2960)pair.getA()), (Object)((class_2248)pair.getB()));
        }
        for (Pair<class_2960, class_2248> pair : CeilandsItems.ITEMS) {
            class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)((class_2960)pair.getA()), (Object)((class_1792)pair.getB()));
        }
        for (Pair<class_2960, class_2248> pair : CeilandsEntities.ENTITIES) {
            class_2378.method_10230((class_2378)class_7923.field_41177, (class_2960)((class_2960)pair.getA()), (Object)((class_1299)pair.getB()));
        }
        for (Pair<class_2960, class_2248> pair : CeilandsBlockEntities.BLOCK_ENTITIES) {
            class_2378.method_10230((class_2378)class_7923.field_41181, (class_2960)((class_2960)pair.getA()), (Object)((class_2591)pair.getB()));
        }
        for (Pair<class_2960, class_2248> pair : CeilandsFeatures.FEATURES) {
            class_2378.method_10230((class_2378)class_7923.field_41144, (class_2960)((class_2960)pair.getA()), (Object)((class_3031)pair.getB()));
        }
        for (Pair<class_2960, class_2248> pair : CeilandsTrunkPlacerType.TRUNK_PLACERS) {
            class_2378.method_10230((class_2378)class_7923.field_41151, (class_2960)((class_2960)pair.getA()), (Object)((class_5142)pair.getB()));
        }
        for (Pair<class_2960, class_2248> pair : CeilandsSoundEvents.SOUND_EVENTS) {
            class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)((class_2960)pair.getA()), (Object)((class_3414)pair.getB()));
        }
    }

    public static void registerPOITypes() {
        PointOfInterestHelper.register((class_2960)class_2960.method_60655((String)"ceilands", (String)"ceilands_portal"), (int)0, (int)1, (class_2248[])new class_2248[]{CeilandsBlocks.CEILANDS_PORTAL});
    }

    public static void registerWoodTypes() {
        class_4719.method_24027((class_4719)ModWoodType.CEILTRUNK);
        class_4719.method_24027((class_4719)ModWoodType.LUZAWOOD);
    }

    public static void registerFlammableBlocks() {
        for (Triplet<class_2248, Integer, Integer> entry : CeilandsFlammableBlocks.CEILANDS_FLAMMABLE_BLOCKS) {
            FlammableBlockRegistry.getDefaultInstance().add((class_2248)entry.getA(), ((Integer)entry.getB()).intValue(), ((Integer)entry.getC()).intValue());
        }
    }

    public static void registerFuels() {
        for (Pair<class_1792, Integer> entry : CeilandsFuels.CEILANDS_FUELS) {
            FuelRegistry.INSTANCE.add((class_1935)entry.getA(), (Object)((Integer)entry.getB()));
        }
    }

    public static void registerStrippables() {
        StrippableBlockRegistry.register((class_2248)CeilandsBlocks.CEILTRUNK_LOG, (class_2248)CeilandsBlocks.STRIPPED_CEILTRUNK_LOG);
        StrippableBlockRegistry.register((class_2248)CeilandsBlocks.CEILTRUNK_WOOD, (class_2248)CeilandsBlocks.STRIPPED_CEILTRUNK_WOOD);
        StrippableBlockRegistry.register((class_2248)CeilandsBlocks.LUZAWOOD_LOG, (class_2248)CeilandsBlocks.STRIPPED_LUZAWOOD_LOG);
        StrippableBlockRegistry.register((class_2248)CeilandsBlocks.LUZAWOOD_WOOD, (class_2248)CeilandsBlocks.STRIPPED_LUZAWOOD_WOOD);
    }

    private static void registerMobAttributes() {
        FabricDefaultAttributeRegistry.register(CeilandsEntities.CASTLE_LORD, (class_5132.class_5133)CastleLord.createAttributes());
        FabricDefaultAttributeRegistry.register(CeilandsEntities.SPIDER_MONARCH, (class_5132.class_5133)SpiderMonarch.createAttributes());
    }

    public static void assignItemsToTabs() {
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40195).register(entries -> CeilandsRegistry.addItemsToTab(entries, (class_5321<class_1761>)class_7706.field_40195));
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40743).register(entries -> CeilandsRegistry.addItemsToTab(entries, (class_5321<class_1761>)class_7706.field_40743));
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40197).register(entries -> CeilandsRegistry.addItemsToTab(entries, (class_5321<class_1761>)class_7706.field_40197));
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_41060).register(entries -> CeilandsRegistry.addItemsToTab(entries, (class_5321<class_1761>)class_7706.field_41060));
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40202).register(entries -> CeilandsRegistry.addItemsToTab(entries, (class_5321<class_1761>)class_7706.field_40202));
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_41062).register(entries -> CeilandsRegistry.addItemsToTab(entries, (class_5321<class_1761>)class_7706.field_41062));
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40205).register(entries -> CeilandsRegistry.addItemsToTab(entries, (class_5321<class_1761>)class_7706.field_40205));
    }

    private static void addItemsToTab(FabricItemGroupEntries entries, class_5321<class_1761> tab) {
        for (Quintet<class_1792, class_1792, class_1761.class_7705, Boolean, class_5321<class_1761>> quint : CreativeModeTabDatabase.ITEM_ENTRIES) {
            if (quint.getE() != tab) continue;
            if (quint.getA() == null) {
                entries.method_45420(((class_1792)quint.getB()).method_7854());
                continue;
            }
            if (((Boolean)quint.getD()).booleanValue()) {
                entries.addAfter((class_1935)quint.getA(), new class_1799[]{((class_1792)quint.getB()).method_7854()});
                continue;
            }
            entries.addBefore((class_1935)quint.getA(), new class_1799[]{((class_1792)quint.getB()).method_7854()});
        }
        if (CompatsFabric.DRAMATIC_DOORS_INSTALLED && tab == class_7706.field_40195) {
            entries.addBefore((class_1935)CeilandsItems.CEILTRUNK_DOOR, new class_1935[]{(class_1935)class_7923.field_41178.method_10223(class_2960.method_60655((String)"dramaticdoors", (String)"short_ceiltrunk_door"))});
            entries.addAfter((class_1935)CeilandsItems.CEILTRUNK_DOOR, new class_1935[]{(class_1935)class_7923.field_41178.method_10223(class_2960.method_60655((String)"dramaticdoors", (String)"tall_ceiltrunk_door"))});
            entries.addBefore((class_1935)CeilandsItems.LUZAWOOD_DOOR, new class_1935[]{(class_1935)class_7923.field_41178.method_10223(class_2960.method_60655((String)"dramaticdoors", (String)"short_luzawood_door"))});
            entries.addAfter((class_1935)CeilandsItems.LUZAWOOD_DOOR, new class_1935[]{(class_1935)class_7923.field_41178.method_10223(class_2960.method_60655((String)"dramaticdoors", (String)"tall_luzawood_door"))});
        }
    }
}

