/*
 * Decompiled with CFR 0.152.
 */
package com.kittehmod.ceilands.fabric.client;

import com.kittehmod.ceilands.fabric.client.renderer.CastleLordRenderer;
import com.kittehmod.ceilands.fabric.client.renderer.CeilandsBoatRenderer;
import com.kittehmod.ceilands.fabric.client.renderer.SpiderMonarchRenderer;
import com.kittehmod.ceilands.fabric.registry.CeilandsBlockEntities;
import com.kittehmod.ceilands.fabric.registry.CeilandsBlocks;
import com.kittehmod.ceilands.fabric.registry.CeilandsEntities;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_5616;
import net.minecraft.class_5619;
import net.minecraft.class_7761;
import net.minecraft.class_837;
import oshi.util.tuples.Pair;

public class ClientCommon {
    public static final int CEILTRUNK_COLOUR = 0xCFFF00;
    public static final int LUZAWOOD_COLOUR = 4637695;
    public static final List<Pair<class_2248, class_1921>> BLOCK_RENDERS = new ArrayList<Pair<class_2248, class_1921>>();

    public static void initializeCommonClient() {
        ClientCommon.initializeBlockEntityRenderers();
        ClientCommon.initializeEntityRenderers();
        ClientCommon.initializeBlockRenderList();
    }

    private static void initializeBlockEntityRenderers() {
        class_5616.method_32144(CeilandsBlockEntities.CEILANDS_SIGN, class_837::new);
        class_5616.method_32144(CeilandsBlockEntities.CEILANDS_HANGING_SIGN, class_7761::new);
    }

    private static void initializeEntityRenderers() {
        class_5619.method_32173(CeilandsEntities.CASTLE_LORD, CastleLordRenderer::new);
        class_5619.method_32173(CeilandsEntities.SPIDER_MONARCH, SpiderMonarchRenderer::new);
        class_5619.method_32173(CeilandsEntities.CEILANDS_BOAT, boat -> new CeilandsBoatRenderer(boat, false));
        class_5619.method_32173(CeilandsEntities.CEILANDS_CHEST_BOAT, boat -> new CeilandsBoatRenderer(boat, true));
    }

    private static void initializeBlockRenderList() {
        ClientCommon.setBlockRenderType(CeilandsBlocks.CEILINUM_BARS, class_1921.method_23581());
        ClientCommon.setBlockRenderType(CeilandsBlocks.CEILINUM_DOOR, class_1921.method_23581());
        ClientCommon.setBlockRenderType(CeilandsBlocks.CEILINUM_TRAPDOOR, class_1921.method_23581());
        ClientCommon.setBlockRenderType(CeilandsBlocks.CEILTRUNK_LEAVES, class_1921.method_23579());
        ClientCommon.setBlockRenderType(CeilandsBlocks.CEILTRUNK_SAPLING, class_1921.method_23581());
        ClientCommon.setBlockRenderType(CeilandsBlocks.CEILTRUNK_DOOR, class_1921.method_23581());
        ClientCommon.setBlockRenderType(CeilandsBlocks.CEILTRUNK_TRAPDOOR, class_1921.method_23581());
        ClientCommon.setBlockRenderType(CeilandsBlocks.LUZAWOOD_LEAVES, class_1921.method_23579());
        ClientCommon.setBlockRenderType(CeilandsBlocks.LUZAWOOD_SAPLING, class_1921.method_23581());
        ClientCommon.setBlockRenderType(CeilandsBlocks.LUZAWOOD_DOOR, class_1921.method_23581());
        ClientCommon.setBlockRenderType(CeilandsBlocks.LUZAWOOD_TRAPDOOR, class_1921.method_23581());
        ClientCommon.setBlockRenderType(CeilandsBlocks.POTTED_LUZAWOOD_SAPLING, class_1921.method_23581());
        ClientCommon.setBlockRenderType(CeilandsBlocks.CEILANDS_PORTAL, class_1921.method_23583());
    }

    private static void setBlockRenderType(class_2248 block, class_1921 rendertype) {
        BLOCK_RENDERS.add((Pair<class_2248, class_1921>)new Pair((Object)block, (Object)rendertype));
    }
}

