/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.modular_angelring.networking;

import com.leclowndu93150.modular_angelring.common.EnabledModifiersComponent;
import com.leclowndu93150.modular_angelring.networking.KeyPressedPayload;
import com.leclowndu93150.modular_angelring.networking.NoKeyPressedPayload;
import com.leclowndu93150.modular_angelring.registry.AttachementRegistry;
import com.leclowndu93150.modular_angelring.registry.DataComponentRegistry;
import com.leclowndu93150.modular_angelring.registry.ItemRegistry;
import java.util.Optional;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;

public final class PayloadActions {
    public static final String NO_KEYS_PRESSED = "no_keys_pressed";

    public static void keyPressedAction(KeyPressedPayload payload, IPayloadContext ctx) {
        Player player = ctx.player();
        int key = payload.key();
        Optional slotResult = CuriosApi.getCuriosInventory((LivingEntity)player).flatMap(handler -> handler.findFirstCurio((Item)ItemRegistry.ANGEL_RING.get()));
        if (slotResult.isPresent()) {
            ItemStack itemStack = ((SlotResult)slotResult.get()).stack();
            EnabledModifiersComponent data = (EnabledModifiersComponent)itemStack.getOrDefault(DataComponentRegistry.MODIFIERS_ENABLED, (Object)EnabledModifiersComponent.EMPTY);
            switch (key) {
                case 0: {
                    if (!itemStack.has(DataComponentRegistry.INERTIA_MODIFIER)) break;
                    itemStack.set(DataComponentRegistry.MODIFIERS_ENABLED, (Object)new EnabledModifiersComponent(!data.inertiaEnabled(), data.speedModifierEnabled(), data.miningEnabled(), data.nightVisionEnabled(), data.magnetEnabled()));
                    break;
                }
                case 1: {
                    if (!itemStack.has(DataComponentRegistry.SPEED_MODIFIER)) break;
                    itemStack.set(DataComponentRegistry.MODIFIERS_ENABLED, (Object)new EnabledModifiersComponent(data.inertiaEnabled(), !data.speedModifierEnabled(), data.miningEnabled(), data.nightVisionEnabled(), data.magnetEnabled()));
                    break;
                }
                case 2: {
                    if (!itemStack.has(DataComponentRegistry.NIGHT_VISION_MODIFIER)) break;
                    boolean newNightVisionState = !data.nightVisionEnabled();
                    itemStack.set(DataComponentRegistry.MODIFIERS_ENABLED, (Object)new EnabledModifiersComponent(data.inertiaEnabled(), data.speedModifierEnabled(), data.miningEnabled(), newNightVisionState, data.magnetEnabled()));
                    AttachementRegistry.setNightVision(player, newNightVisionState);
                    if (newNightVisionState) break;
                    player.removeEffect(MobEffects.NIGHT_VISION);
                    break;
                }
                case 3: {
                    if (!itemStack.has(DataComponentRegistry.MAGNET_MODIFIER)) break;
                    itemStack.set(DataComponentRegistry.MODIFIERS_ENABLED, (Object)new EnabledModifiersComponent(data.inertiaEnabled(), data.speedModifierEnabled(), data.miningEnabled(), data.nightVisionEnabled(), !data.magnetEnabled()));
                }
            }
        }
    }

    public static void noKeyPressedAction(NoKeyPressedPayload payload, IPayloadContext ctx) {
        Player player = ctx.player();
        player.getPersistentData().putBoolean(NO_KEYS_PRESSED, payload.pressed());
    }
}

