/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.modular_angelring.events;

import com.leclowndu93150.modular_angelring.AngelRingConfig;
import com.leclowndu93150.modular_angelring.common.AngelRingModules;
import com.leclowndu93150.modular_angelring.common.EnabledModifiersComponent;
import com.leclowndu93150.modular_angelring.registry.DataComponentRegistry;
import com.leclowndu93150.modular_angelring.registry.ItemRegistry;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import top.theillusivec4.curios.api.CuriosApi;

@EventBusSubscriber(modid="modular_angelring")
public class AngelRingEvents {
    @SubscribeEvent
    public static void setRingBreakSpeed(PlayerEvent.BreakSpeed event) {
        Player player = event.getEntity();
        if (player.onGround()) {
            return;
        }
        CuriosApi.getCuriosInventory((LivingEntity)player).flatMap(handler -> handler.findFirstCurio((Item)ItemRegistry.ANGEL_RING.get())).ifPresent(slotResult -> {
            ItemStack angelRingStack = slotResult.stack();
            if (AngelRingModules.getMiningSpeedModifier(angelRingStack).booleanValue()) {
                event.setNewSpeed(event.getOriginalSpeed() * 5.0f);
            }
        });
    }

    @SubscribeEvent
    public static void stopDrift(PlayerTickEvent.Pre event) {
        Player player = event.getEntity();
        if (!player.getAbilities().flying) {
            return;
        }
        CuriosApi.getCuriosInventory((LivingEntity)player).flatMap(handler -> handler.findFirstCurio((Item)ItemRegistry.ANGEL_RING.get())).ifPresent(slotResult -> {
            ItemStack angelRingStack = slotResult.stack();
            EnabledModifiersComponent data = (EnabledModifiersComponent)angelRingStack.getOrDefault(DataComponentRegistry.MODIFIERS_ENABLED, (Object)EnabledModifiersComponent.EMPTY);
            if (AngelRingModules.getInertiaModifier(angelRingStack).booleanValue() && data.inertiaEnabled() && player.getPersistentData().getBoolean("no_keys_pressed")) {
                Vec3 motion = player.getDeltaMovement();
                if (motion.x != 0.0 || motion.z != 0.0) {
                    player.setDeltaMovement(motion.x * AngelRingConfig.slowdownFactor, motion.y, motion.z * AngelRingConfig.slowdownFactor);
                }
            }
        });
    }

    @SubscribeEvent
    public static void useMagnet(PlayerTickEvent.Pre event) {
        Player player = event.getEntity();
        if (player.isCrouching()) {
            return;
        }
        CuriosApi.getCuriosInventory((LivingEntity)player).flatMap(handler -> handler.findFirstCurio((Item)ItemRegistry.ANGEL_RING.get())).ifPresent(slotResult -> {
            ItemStack angelRingStack = slotResult.stack();
            EnabledModifiersComponent data = (EnabledModifiersComponent)angelRingStack.getOrDefault(DataComponentRegistry.MODIFIERS_ENABLED, (Object)EnabledModifiersComponent.EMPTY);
            if (AngelRingModules.getMagnetModifier(angelRingStack).booleanValue() && data.magnetEnabled()) {
                double radius = AngelRingConfig.magnetRadius;
                Vec3 playerPos = player.position();
                player.level().getEntitiesOfClass(ItemEntity.class, player.getBoundingBox().inflate(radius)).forEach(itemEntity -> {
                    Vec3 pullVec = playerPos.subtract(itemEntity.position()).normalize().scale(AngelRingConfig.magnetPullSpeed);
                    itemEntity.setDeltaMovement(itemEntity.getDeltaMovement().add(pullVec));
                });
            }
        });
    }
}

