/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.modular_angelring.events;

import com.leclowndu93150.modular_angelring.common.AngelRingModules;
import com.leclowndu93150.modular_angelring.common.EnabledModifiersComponent;
import com.leclowndu93150.modular_angelring.networking.KeyPressedPayload;
import com.leclowndu93150.modular_angelring.registry.DataComponentRegistry;
import com.leclowndu93150.modular_angelring.registry.ItemRegistry;
import com.leclowndu93150.modular_angelring.registry.KeyBindRegistry;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;

@EventBusSubscriber(modid="modular_angelring", value={Dist.CLIENT})
public class AngelRingClientEvents {
    static boolean isNightVisionEnabled = false;

    @SubscribeEvent
    public static void onKey(InputEvent.Key event) {
        LocalPlayer player = Minecraft.getInstance().player;
        Minecraft minecraft = Minecraft.getInstance();
        if (player == null) {
            return;
        }
        Optional slotResult = CuriosApi.getCuriosInventory((LivingEntity)player).flatMap(handler -> handler.findFirstCurio((Item)ItemRegistry.ANGEL_RING.get()));
        if (slotResult.isPresent()) {
            ItemStack angelRingStack = ((SlotResult)slotResult.get()).stack();
            EnabledModifiersComponent data = (EnabledModifiersComponent)angelRingStack.getOrDefault(DataComponentRegistry.MODIFIERS_ENABLED, (Object)EnabledModifiersComponent.EMPTY);
            Level level = player.level();
            if (((KeyMapping)KeyBindRegistry.INERTIA_MODULE.get()).consumeClick() && AngelRingModules.getInertiaModifier(angelRingStack).booleanValue()) {
                PacketDistributor.sendToServer((CustomPacketPayload)new KeyPressedPayload(0), (CustomPacketPayload[])new CustomPacketPayload[0]);
                if (!data.inertiaEnabled()) {
                    player.displayClientMessage((Component)Component.literal((String)"Inertia Module: Enabled").withStyle(ChatFormatting.GREEN), true);
                    level.playSound((Player)player, player.getX(), player.getY(), player.getZ(), (SoundEvent)SoundEvents.NOTE_BLOCK_BELL.value(), SoundSource.PLAYERS, 0.4f, 0.01f);
                } else {
                    player.displayClientMessage((Component)Component.literal((String)"Inertia Module: Disabled").withStyle(ChatFormatting.RED), true);
                    level.playSound((Player)player, player.getX(), player.getY(), player.getZ(), (SoundEvent)SoundEvents.NOTE_BLOCK_BELL.value(), SoundSource.PLAYERS, 0.4f, 0.09f);
                }
            }
            if (((KeyMapping)KeyBindRegistry.SPEED_MODULE.get()).consumeClick() && angelRingStack.has(DataComponentRegistry.SPEED_MODIFIER)) {
                PacketDistributor.sendToServer((CustomPacketPayload)new KeyPressedPayload(1), (CustomPacketPayload[])new CustomPacketPayload[0]);
                if (!data.speedModifierEnabled()) {
                    player.displayClientMessage((Component)Component.literal((String)"Speed Module: Enabled").withStyle(ChatFormatting.GREEN), true);
                    level.playSound((Player)player, player.getX(), player.getY(), player.getZ(), (SoundEvent)SoundEvents.NOTE_BLOCK_BELL.value(), SoundSource.PLAYERS, 0.4f, 0.01f);
                } else {
                    player.displayClientMessage((Component)Component.literal((String)"Speed Module: Disabled").withStyle(ChatFormatting.RED), true);
                    level.playSound((Player)player, player.getX(), player.getY(), player.getZ(), (SoundEvent)SoundEvents.NOTE_BLOCK_BELL.value(), SoundSource.PLAYERS, 0.4f, 0.09f);
                }
            }
            if (((KeyMapping)KeyBindRegistry.NIGHT_VISION_MODULE.get()).consumeClick() && angelRingStack.has(DataComponentRegistry.NIGHT_VISION_MODIFIER)) {
                PacketDistributor.sendToServer((CustomPacketPayload)new KeyPressedPayload(2), (CustomPacketPayload[])new CustomPacketPayload[0]);
                if (!data.nightVisionEnabled()) {
                    player.displayClientMessage((Component)Component.literal((String)"Night Vision Module: Enabled").withStyle(ChatFormatting.GREEN), true);
                    level.playSound((Player)player, player.getX(), player.getY(), player.getZ(), (SoundEvent)SoundEvents.NOTE_BLOCK_BELL.value(), SoundSource.PLAYERS, 0.4f, 0.01f);
                } else {
                    player.displayClientMessage((Component)Component.literal((String)"Night Vision Module: Disabled").withStyle(ChatFormatting.RED), true);
                    level.playSound((Player)player, player.getX(), player.getY(), player.getZ(), (SoundEvent)SoundEvents.NOTE_BLOCK_BELL.value(), SoundSource.PLAYERS, 0.4f, 0.09f);
                }
            }
            if (((KeyMapping)KeyBindRegistry.MAGNET_MODULE.get()).consumeClick() && angelRingStack.has(DataComponentRegistry.MAGNET_MODIFIER)) {
                PacketDistributor.sendToServer((CustomPacketPayload)new KeyPressedPayload(3), (CustomPacketPayload[])new CustomPacketPayload[0]);
                if (!data.magnetEnabled()) {
                    player.displayClientMessage((Component)Component.literal((String)"Magnet Module: Enabled").withStyle(ChatFormatting.GREEN), true);
                    level.playSound((Player)player, player.getX(), player.getY(), player.getZ(), (SoundEvent)SoundEvents.NOTE_BLOCK_BELL.value(), SoundSource.PLAYERS, 0.4f, 0.01f);
                } else {
                    player.displayClientMessage((Component)Component.literal((String)"Magnet Module: Disabled").withStyle(ChatFormatting.RED), true);
                    level.playSound((Player)player, player.getX(), player.getY(), player.getZ(), (SoundEvent)SoundEvents.NOTE_BLOCK_BELL.value(), SoundSource.PLAYERS, 0.4f, 0.09f);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Pre event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        CuriosApi.getCuriosInventory((LivingEntity)player).flatMap(handler -> handler.findFirstCurio((Item)ItemRegistry.ANGEL_RING.get())).ifPresent(arg_0 -> AngelRingClientEvents.lambda$onClientTick$2((Player)player, arg_0));
    }

    private static /* synthetic */ void lambda$onClientTick$2(Player player, SlotResult slotResult) {
        MobEffectInstance effect;
        ItemStack angelRingStack = slotResult.stack();
        EnabledModifiersComponent data = (EnabledModifiersComponent)angelRingStack.getOrDefault(DataComponentRegistry.MODIFIERS_ENABLED, (Object)EnabledModifiersComponent.EMPTY);
        if (AngelRingModules.getNightVisionModifier(angelRingStack).booleanValue() && data.nightVisionEnabled() && ((effect = player.getEffect(MobEffects.NIGHT_VISION)) == null || effect.getDuration() < 219)) {
            player.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, 400, 0, true, false));
        }
    }
}

