/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.behaviour.custom.target;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.player.Player;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.object.MemoryTest;
import net.tslat.smartbrainlib.util.BrainUtils;
import net.tslat.smartbrainlib.util.EntityRetrievalUtil;

public class SetRetaliateTarget<E extends LivingEntity>
extends ExtendedBehaviour<E> {
    private static final MemoryTest MEMORY_REQUIREMENTS = MemoryTest.builder(2).hasMemory(MemoryModuleType.HURT_BY_ENTITY).noMemory(MemoryModuleType.ATTACK_TARGET);
    protected Predicate<LivingEntity> canAttackPredicate = entity -> {
        if (!entity.isAlive()) return false;
        if (!(entity instanceof Player)) return true;
        Player player = (Player)entity;
        if (player.getAbilities().invulnerable) return false;
        return true;
    };
    protected LivingEntity toTarget = null;
    protected BiPredicate<E, Entity> alertAlliesPredicate = (owner, attacker) -> false;
    protected BiPredicate<E, LivingEntity> allyPredicate = (owner, ally) -> {
        OwnableEntity pet;
        if (!owner.getClass().isAssignableFrom(ally.getClass()) || BrainUtils.getTargetOfEntity(ally) != null) {
            return false;
        }
        if (owner instanceof OwnableEntity && (pet = (OwnableEntity)owner).getOwner() != ((OwnableEntity)ally).getOwner()) {
            return false;
        }
        Entity lastHurtBy = (Entity)BrainUtils.getMemory(ally, MemoryModuleType.HURT_BY_ENTITY);
        return lastHurtBy == null || !ally.isAlliedTo(lastHurtBy);
    };

    public SetRetaliateTarget<E> attackablePredicate(Predicate<LivingEntity> predicate) {
        this.canAttackPredicate = predicate;
        return this;
    }

    public SetRetaliateTarget<E> alertAlliesWhen(BiPredicate<E, Entity> predicate) {
        this.alertAlliesPredicate = predicate;
        return this;
    }

    public SetRetaliateTarget<E> isAllyIf(BiPredicate<E, LivingEntity> predicate) {
        this.allyPredicate = predicate;
        return this;
    }

    @Override
    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel level, E owner) {
        this.toTarget = (LivingEntity)BrainUtils.getMemory(owner, MemoryModuleType.HURT_BY_ENTITY);
        if (this.toTarget.isAlive() && this.toTarget.level() == level && this.canAttackPredicate.test(this.toTarget)) {
            if (this.alertAlliesPredicate.test(owner, (Entity)this.toTarget)) {
                this.alertAllies(level, owner);
            }
            return true;
        }
        return false;
    }

    @Override
    protected void start(E entity) {
        BrainUtils.setTargetOfEntity(entity, this.toTarget);
        BrainUtils.clearMemory(entity, MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE);
        this.toTarget = null;
    }

    protected void alertAllies(ServerLevel level, E owner) {
        double followRange = owner.getAttributeValue(Attributes.FOLLOW_RANGE);
        for (LivingEntity ally : EntityRetrievalUtil.getEntities(owner, followRange, 10.0, followRange, LivingEntity.class, entity -> this.allyPredicate.test(owner, (LivingEntity)entity))) {
            BrainUtils.setTargetOfEntity(ally, this.toTarget);
        }
    }
}

