/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.gateways.client;

import dev.shadowsoffire.gateways.GatewayObjects;
import dev.shadowsoffire.gateways.entity.GatewayEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;

public class GatewayTickableSound
extends AbstractTickableSoundInstance {
    private final GatewayEntity gateway;

    public GatewayTickableSound(GatewayEntity gateway) {
        super((SoundEvent)gateway.getGateway().soundtrack().value(), SoundSource.HOSTILE, gateway.level().getRandom());
        this.gateway = gateway;
        this.looping = true;
        this.delay = 0;
        this.x = (float)gateway.getX();
        this.y = (float)gateway.getY();
        this.z = (float)gateway.getZ();
        if (gateway.getGateway().soundtrack() == GatewayObjects.GATE_AMBIENT) {
            this.pitch = 0.75f;
            this.attenuation = SoundInstance.Attenuation.LINEAR;
        } else {
            this.attenuation = SoundInstance.Attenuation.NONE;
        }
    }

    public void tick() {
        if (!this.gateway.isAlive()) {
            this.stop();
        } else {
            this.volume = (1.0f - (float)((double)Minecraft.getInstance().player.distanceTo((Entity)this.gateway) / this.gateway.getGateway().rules().leashRange())) * 0.33f;
        }
    }

    public static void startGatewaySound(GatewayEntity entity) {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)new GatewayTickableSound(entity));
    }
}

