// server_scripts/easysleep.js

// Set playersSleepingPercentage to 10% ONLY on first server startup
ServerEvents.loaded(event => {
    let server = event.server
    
    // Check if we've already initialized the gamerule
    if (!server.persistentData.contains('easysleep_initialized')) {
        // First time - set to 10%
        server.runCommandSilent('gamerule playersSleepingPercentage 10')
        // Mark as initialized so we don't reset it again
        server.persistentData.putBoolean('easysleep_initialized', true)
    }
})

// Register the /easysleep command
ServerEvents.commandRegistry(event => {
    const { commands: Commands, arguments: Arguments } = event
    
    event.register(
        Commands.literal('easysleep')
            .requires(source => source.hasPermission(2)) // Requires OP level 2
            .then(
                Commands.argument('percentage', Arguments.INTEGER.create(event))
                    .executes(ctx => {
                        let percentage = Arguments.INTEGER.getResult(ctx, 'percentage')
                        
                        // Validate input - clamp between 0 and 100
                        if (percentage < 0) {
                            percentage = 0
                        } else if (percentage > 100) {
                            percentage = 100
                        }
                        
                        // Set the gamerule
                        ctx.source.server.runCommandSilent('gamerule playersSleepingPercentage ' + percentage)
                        
                        // Send confirmation message
                        ctx.source.sendSuccess(Text.of('§aPlayers sleeping percentage set to ' + percentage + '%'), true)
                        
                        return 1
                    })
            )
    )
})