/*
 * Decompiled with CFR 0.152.
 */
package fuzs.overflowingbars.client.handler;

import com.mojang.blaze3d.systems.RenderSystem;
import fuzs.overflowingbars.client.handler.ArmorBarRenderer;
import fuzs.overflowingbars.client.handler.HealthBarRenderer;
import fuzs.overflowingbars.client.handler.RowCountRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class BarOverlayRenderer {
    static final ResourceLocation GUI_ICONS_LOCATION = new ResourceLocation("textures/gui/icons.png");
    static final ResourceLocation OVERFLOWING_ICONS_LOCATION = new ResourceLocation("overflowingbars", "textures/gui/icons.png");

    public static void renderHealthLevelBars(GuiGraphics guiGraphics, int screenWidth, int screenHeight, Minecraft minecraft, int leftHeight, boolean rowCount) {
        Player player = BarOverlayRenderer.getCameraPlayer(minecraft);
        if (player == null) {
            return;
        }
        int posX = screenWidth / 2 - 91;
        int posY = screenHeight - leftHeight;
        HealthBarRenderer.INSTANCE.renderPlayerHealth(guiGraphics, posX, posY, player, minecraft.m_91307_());
        if (rowCount) {
            int allHearts = Mth.m_14167_((float)player.m_21223_());
            RowCountRenderer.drawBarRowCount(guiGraphics, posX - 2, posY, allHearts, true, minecraft.f_91062_);
            int maxAbsorption = (20 - Mth.m_14167_((float)((float)Math.min(20, allHearts) / 2.0f))) * 2;
            RowCountRenderer.drawBarRowCount(guiGraphics, posX - 2, posY - 10, Mth.m_14167_((float)player.m_6103_()), true, maxAbsorption, minecraft.f_91062_);
        }
    }

    public static void renderArmorLevelBar(GuiGraphics guiGraphics, int screenWidth, int screenHeight, Minecraft minecraft, int leftHeight, boolean rowCount, boolean unmodified) {
        Player player = BarOverlayRenderer.getCameraPlayer(minecraft);
        if (player == null) {
            return;
        }
        int posX = screenWidth / 2 - 91;
        int posY = screenHeight - leftHeight;
        ArmorBarRenderer.renderArmorBar(guiGraphics, posX, posY, player, minecraft.m_91307_(), unmodified);
        if (rowCount && !unmodified) {
            RowCountRenderer.drawBarRowCount(guiGraphics, posX - 2, posY, player.m_21230_(), true, minecraft.f_91062_);
        }
    }

    public static void renderToughnessLevelBar(GuiGraphics guiGraphics, int screenWidth, int screenHeight, Minecraft minecraft, int rightHeight, boolean rowCount, boolean left, boolean unmodified) {
        Player player = BarOverlayRenderer.getCameraPlayer(minecraft);
        if (player == null) {
            return;
        }
        int posX = screenWidth / 2 + (left ? -91 : 91);
        int posY = screenHeight - rightHeight;
        ArmorBarRenderer.renderToughnessBar(guiGraphics, posX, posY, player, minecraft.m_91307_(), left, unmodified);
        if (rowCount && !unmodified) {
            int toughnessValue = Mth.m_14107_((double)player.m_21133_(Attributes.f_22285_));
            RowCountRenderer.drawBarRowCount(guiGraphics, posX + (left ? -2 : 2), posY, toughnessValue, left, minecraft.f_91062_);
        }
    }

    @Nullable
    private static Player getCameraPlayer(Minecraft minecraft) {
        Player player;
        Entity entity = minecraft.m_91288_();
        return entity instanceof Player ? (player = (Player)entity) : null;
    }

    public static void resetRenderState() {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.defaultBlendFunc();
    }
}

