/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.majruszlibrary.registry.Registries;
import com.majruszsdifficulty.MajruszsDifficulty;
import java.util.List;
import java.util.stream.StreamSupport;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class CurseRandomly
extends LootItemConditionalFunction {
    public static LootItemFunctionType create() {
        return new LootItemFunctionType((Serializer)new LootItemConditionalFunction.Serializer<LootItemConditionalFunction>(){

            public CurseRandomly deserialize(JsonObject jsonObject, JsonDeserializationContext context, LootItemCondition[] itemConditions) {
                return new CurseRandomly(itemConditions);
            }
        });
    }

    public CurseRandomly(LootItemCondition[] itemConditions) {
        super(itemConditions);
    }

    public LootItemFunctionType m_7162_() {
        return (LootItemFunctionType)MajruszsDifficulty.CURSE_RANDOMLY_LOOT_FUNCTION.get();
    }

    public ItemStack m_7372_(ItemStack itemStack, LootContext context) {
        List<Enchantment> enchantments;
        List<Enchantment> curses = this.generateCurses(itemStack);
        if (!curses.isEmpty()) {
            itemStack = CurseRandomly.enchantItem(itemStack, context.m_230907_(), curses);
        }
        if (!(enchantments = this.generateEnchantments(itemStack)).isEmpty()) {
            itemStack = CurseRandomly.enchantItem(itemStack, context.m_230907_(), enchantments);
        }
        return itemStack;
    }

    private List<Enchantment> generateCurses(ItemStack itemStack) {
        return StreamSupport.stream(Registries.ENCHANTMENTS.spliterator(), false).filter(Enchantment::m_6592_).filter(Enchantment::m_6589_).filter(enchantment -> enchantment.m_6081_(itemStack)).toList();
    }

    private List<Enchantment> generateEnchantments(ItemStack itemStack) {
        return StreamSupport.stream(Registries.ENCHANTMENTS.spliterator(), false).filter(Enchantment::m_6592_).filter(enchantment -> !enchantment.m_6589_()).filter(enchantment -> enchantment.m_6081_(itemStack)).toList();
    }

    private static ItemStack enchantItem(ItemStack itemStack, RandomSource randomSource, List<Enchantment> enchantments) {
        Enchantment enchantment = enchantments.get(randomSource.m_188503_(enchantments.size()));
        int level = Mth.m_216271_((RandomSource)randomSource, (int)enchantment.m_44702_(), (int)enchantment.m_6586_());
        if (itemStack.m_150930_(Items.f_42517_)) {
            itemStack = new ItemStack((ItemLike)Items.f_42690_);
            EnchantedBookItem.m_41153_((ItemStack)itemStack, (EnchantmentInstance)new EnchantmentInstance(enchantment, level));
        } else {
            itemStack.m_41663_(enchantment, level);
        }
        return itemStack;
    }
}

