/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.items;

import com.majruszlibrary.data.IReader;
import com.majruszlibrary.data.Reader;
import com.majruszlibrary.data.Serializables;
import com.majruszlibrary.entity.EntityHelper;
import com.majruszlibrary.events.OnEntityPreDamaged;
import com.majruszlibrary.events.OnItemAttributeTooltip;
import com.majruszlibrary.events.base.Condition;
import com.majruszlibrary.level.LevelHelper;
import com.majruszlibrary.math.AnyPos;
import com.majruszlibrary.math.AnyRot;
import com.majruszlibrary.math.Range;
import com.majruszlibrary.text.TextHelper;
import com.majruszsdifficulty.data.Config;
import com.majruszsdifficulty.items.ScrollItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.EvokerFangs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EvokerFangScroll
extends ScrollItem {
    private static int ATTACK_DAMAGE = 12;
    private static Range<Integer> ATTACK_RANGE = Range.of((Number)8, (Number)20);

    @Override
    protected void useScroll(ItemStack itemStack, Level level, LivingEntity entity, float useRatio) {
        super.useScroll(itemStack, level, entity, useRatio);
        double rotation = Math.toRadians(entity.m_146908_()) - 1.5707963267948966;
        this.getAttackPattern(entity, (int)ATTACK_RANGE.lerp(useRatio)).forEach(spawnPoint -> {
            EvokerFangs evokerFangs = new EvokerFangs(level, spawnPoint.pos.f_82479_, spawnPoint.pos.f_82480_, spawnPoint.pos.f_82481_, (float)rotation, spawnPoint.cooldown, entity);
            Serializables.write((Object)new DamageInfo(ATTACK_DAMAGE), (Tag)EntityHelper.getOrCreateExtraTag((Entity)evokerFangs));
            level.m_7967_((Entity)evokerFangs);
        });
    }

    @Override
    protected SoundEvent getPrepareSound() {
        return SoundEvents.f_11868_;
    }

    @Override
    protected SoundEvent getCastSound() {
        return SoundEvents.f_11862_;
    }

    private List<SpawnPoint> getAttackPattern(LivingEntity entity, int attackLength) {
        ArrayList<SpawnPoint> spawnPoints = new ArrayList<SpawnPoint>();
        AnyRot lookRotation = EntityHelper.getLookRotation((Entity)entity);
        for (int x = 0; x <= attackLength; ++x) {
            for (int z = -1; z <= 1; ++z) {
                int cooldown = Math.abs(x) + 4;
                Vec3 position = AnyPos.from((Vec3)entity.m_20182_()).floor().add(AnyPos.from((Number)x, (Number)0, (Number)z).rot(lookRotation).round()).vec3();
                LevelHelper.findBlockPosOnGround((Level)entity.m_9236_(), (Number)position.f_82479_, (Range)Range.of((Number)(position.f_82480_ - 3.0), (Number)(position.f_82480_ + 3.0)), (Number)position.f_82481_).ifPresent(blockPos -> spawnPoints.add(new SpawnPoint(AnyPos.from((BlockPos)blockPos).add((Number)0.5, (Number)0.0, (Number)0.5).vec3(), cooldown)));
            }
        }
        return spawnPoints;
    }

    private static void increaseDamage(OnEntityPreDamaged data) {
        data.damage += (float)((DamageInfo)Serializables.read((Object)new DamageInfo(), (Tag)EntityHelper.getExtraTag((Entity)data.source.m_7640_()))).damage - data.original;
    }

    private static void addSpellInfo(OnItemAttributeTooltip data) {
        List.of(TextHelper.translatable((String)"majruszsdifficulty.scrolls.attack_damage", (Object[])new Object[]{ATTACK_DAMAGE}).m_130940_(ChatFormatting.DARK_GREEN), TextHelper.translatable((String)"majruszsdifficulty.scrolls.attack_range", (Object[])new Object[]{"%d-%d".formatted(EvokerFangScroll.ATTACK_RANGE.from, EvokerFangScroll.ATTACK_RANGE.to)}).m_130940_(ChatFormatting.DARK_GREEN)).forEach(component -> data.add(EquipmentSlot.MAINHAND, (Component)component));
    }

    static {
        OnEntityPreDamaged.listen(EvokerFangScroll::increaseDamage).addCondition(Condition.isLogicalServer()).addCondition(data -> data.source.m_7640_() instanceof EvokerFangs).addCondition(data -> EntityHelper.getExtraTag((Entity)data.source.m_7640_()) != null);
        OnItemAttributeTooltip.listen(EvokerFangScroll::addSpellInfo).addCondition(data -> data.itemStack.m_41720_() instanceof EvokerFangScroll);
        Serializables.getStatic(Config.Items.class).define("evoker_fang_scroll", EvokerFangScroll.class);
        Serializables.getStatic(EvokerFangScroll.class).define("attack_damage", Reader.integer(), () -> ATTACK_DAMAGE, v -> {
            ATTACK_DAMAGE = (Integer)Range.of((Number)1, (Number)100).clamp((Number)v);
        }).define("attack_range", Reader.range((IReader)Reader.integer()), () -> ATTACK_RANGE, v -> {
            ATTACK_RANGE = Range.of((Number)1, (Number)100).clamp(v);
        });
        Serializables.get(DamageInfo.class).define("MajruszsProgressiveDifficultyEvokerFangDamage", Reader.integer(), s -> s.damage, (s, v) -> {
            s.damage = v;
        });
    }

    private static class DamageInfo {
        int damage = 0;

        public DamageInfo(int damage) {
            this.damage = damage;
        }

        public DamageInfo() {
        }
    }

    private record SpawnPoint(Vec3 pos, int cooldown) {
    }
}

