/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.features;

import com.majruszlibrary.collection.CollectionHelper;
import com.majruszlibrary.collection.DefaultMap;
import com.majruszlibrary.data.IReader;
import com.majruszlibrary.data.Reader;
import com.majruszlibrary.data.Serializables;
import com.majruszlibrary.events.OnEntitySpawned;
import com.majruszlibrary.events.base.Condition;
import com.majruszlibrary.registry.Registries;
import com.majruszlibrary.text.RegexString;
import com.majruszsdifficulty.data.Config;
import com.majruszsdifficulty.gamestage.GameStageHelper;
import com.majruszsdifficulty.gamestage.GameStageValue;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.entity.MobSpawnType;

public class SpawnBlocker {
    private static GameStageValue<List<RegexString>> FORBIDDEN_ENTITIES = GameStageValue.of(DefaultMap.defaultEntry((Object)RegexString.toRegex(List.of("majruszsdifficulty:illusioner", "majruszsdifficulty:tank", "majruszsdifficulty:cerberus"))), DefaultMap.entry((String)"expert", (Object)RegexString.toRegex(List.of("majruszsdifficulty:cerberus"))), DefaultMap.entry((String)"master", List.of()));

    private static Condition<OnEntitySpawned> isForbidden() {
        return Condition.predicate(data -> {
            String id = Registries.ENTITY_TYPES.getId((Object)data.entity.m_6095_()).toString();
            List<RegexString> forbiddenIds = FORBIDDEN_ENTITIES.get(GameStageHelper.determineGameStage(data));
            for (RegexString forbiddenId : forbiddenIds) {
                if (!forbiddenId.matches(id)) continue;
                return true;
            }
            return false;
        });
    }

    private static Map<String, List<String>> getEntities() {
        return CollectionHelper.map(FORBIDDEN_ENTITIES.get(), RegexString::toString, HashMap::new);
    }

    private static void setEntities(Map<String, List<String>> map) {
        FORBIDDEN_ENTITIES = GameStageValue.of(CollectionHelper.map(map, RegexString::toRegex, HashMap::new));
    }

    static {
        OnEntitySpawned.listen(OnEntitySpawned::cancelSpawn).addCondition(Condition.isLogicalServer()).addCondition(data -> !data.isLoadedFromDisk).addCondition(data -> data.mobSpawnType == null || data.mobSpawnType.equals((Object)MobSpawnType.NATURAL)).addCondition(SpawnBlocker.isForbidden());
        Serializables.getStatic(Config.Features.class).define("spawn_blocker", SpawnBlocker.class);
        Serializables.getStatic(SpawnBlocker.class).define("forbidden_entities", Reader.map((IReader)Reader.list((IReader)Reader.string())), SpawnBlocker::getEntities, SpawnBlocker::setEntities);
    }
}

