/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.entity;

import com.majruszlibrary.animations.ModelDef;
import com.majruszlibrary.animations.ModelParts;
import com.majruszlibrary.math.AnyPos;
import com.majruszlibrary.modhelper.Resource;
import com.majruszlibrary.platform.Side;
import com.majruszsdifficulty.MajruszsDifficulty;
import com.majruszsdifficulty.entity.Cerberus;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CerberusModel<Type extends Cerberus>
extends HierarchicalModel<Type> {
    public static Resource<ModelDef> MODEL = MajruszsDifficulty.HELPER.loadClient("cerberus_model", ModelDef.class);
    public final ModelParts modelParts;
    public final ModelPart body;
    public final ModelPart necks;
    public final ModelPart neck1;
    public final ModelPart neck3;
    public final ModelPart jawUpper1;
    public final ModelPart jawUpper2;
    public final ModelPart jawUpper3;
    public final ModelPart jawLower1;
    public final ModelPart jawLower2;
    public final ModelPart jawLower3;
    public final ModelPart frontLeg1;
    public final ModelPart frontLeg2;
    public final ModelPart hindLeg1;
    public final ModelPart hindLeg2;

    public CerberusModel(ModelPart modelPart) {
        this.modelParts = new ModelParts(modelPart, (ModelDef)MODEL.get());
        this.body = this.modelParts.get("body");
        this.necks = this.modelParts.get("necks");
        this.neck1 = this.modelParts.get("neck1");
        this.neck3 = this.modelParts.get("neck3");
        this.jawUpper1 = this.modelParts.get("jawUpper1");
        this.jawUpper2 = this.modelParts.get("jawUpper2");
        this.jawUpper3 = this.modelParts.get("jawUpper3");
        this.jawLower1 = this.modelParts.get("jawLower1");
        this.jawLower2 = this.modelParts.get("jawLower2");
        this.jawLower3 = this.modelParts.get("jawLower3");
        this.frontLeg1 = this.modelParts.get("frontLeg1");
        this.frontLeg2 = this.modelParts.get("frontLeg2");
        this.hindLeg1 = this.modelParts.get("hindLeg1");
        this.hindLeg2 = this.modelParts.get("hindLeg2");
    }

    public void setupAnim(Type cerberus, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float jawRotation;
        this.modelParts.reset();
        this.necks.f_104204_ = (float)((double)this.necks.f_104204_ + Math.toRadians(netHeadYaw));
        this.necks.f_104203_ = (float)((double)this.necks.f_104203_ + (Math.toRadians(headPitch) + (double)0.0873f));
        this.neck1.f_104204_ = (float)((double)this.neck1.f_104204_ + Math.toRadians((double)(netHeadYaw * (netHeadYaw < 0.0f ? 0.255f : -0.075f)) + 2.0 * Math.sin(0.1f * ageInTicks)));
        this.neck3.f_104204_ = (float)((double)this.neck3.f_104204_ + Math.toRadians((double)(netHeadYaw * (netHeadYaw > 0.0f ? 0.225f : -0.075f)) - 2.0 * Math.cos(0.1f * ageInTicks)));
        this.jawUpper2.f_104203_ = this.jawUpper3.f_104203_ = (jawRotation = (float)Math.toRadians(-1.0 * Math.sin(ageInTicks / 10.0f) - (double)(15.0f * Mth.m_14036_((float)(1.2f - this.getPlayerDistance(cerberus) / 5.0f), (float)0.0f, (float)1.0f))));
        this.jawUpper1.f_104203_ = this.jawUpper3.f_104203_;
        this.jawLower2.f_104203_ = this.jawLower3.f_104203_ = jawRotation;
        this.jawLower1.f_104203_ = this.jawLower3.f_104203_;
        float limbFactor1 = 0.5f * limbSwing;
        float limbFactor2 = 0.6f * limbSwingAmount;
        this.frontLeg1.f_104203_ = this.hindLeg1.f_104203_ = (float)(Math.cos(limbFactor1) * (double)limbFactor2);
        this.frontLeg2.f_104203_ = this.hindLeg2.f_104203_ = (float)(Math.cos((double)limbFactor1 + Math.PI) * (double)limbFactor2);
        this.body.f_104201_ += Math.abs((float)Math.cos(limbFactor1) * limbSwingAmount);
        ((Cerberus)((Object)cerberus)).getAnimations().forEach(animation -> animation.apply(this.modelParts, ageInTicks));
    }

    public ModelPart m_142109_() {
        return this.modelParts.getRoot();
    }

    private float getPlayerDistance(Type cerberus) {
        LocalPlayer player = Side.getMinecraft().f_91074_;
        return player != null && !player.m_5833_() ? AnyPos.from((Vec3)player.m_20182_()).dist(cerberus.m_20182_()).floatValue() : Float.MAX_VALUE;
    }
}

