/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.pufferfish_unofficial_additions.misc;

import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraftforge.registries.IForgeRegistry;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;

public class ExtendedJson {
    public static Result<AbstractSpell, Problem> parseSpell(JsonElement element) {
        return ExtendedJson.parseSomething((IForgeRegistry)SpellRegistry.REGISTRY.get(), element, () -> "Expected valid spell");
    }

    public static Result<HolderSet<AbstractSpell>, Problem> parseSpellTag(JsonElement element) {
        return ExtendedJson.parseSomethingTag((IForgeRegistry)SpellRegistry.REGISTRY.get(), element, () -> "Expected valid spell tag");
    }

    public static Result<HolderSet<AbstractSpell>, Problem> parseSpellOrSpellTag(JsonElement element) {
        return ExtendedJson.parseSomethingOrSomethingTag((IForgeRegistry)SpellRegistry.REGISTRY.get(), element, () -> "Expected valid spell or spell tag");
    }

    public static Result<SchoolType, Problem> parseSchool(JsonElement element) {
        return ExtendedJson.parseSomething((IForgeRegistry)SchoolRegistry.REGISTRY.get(), element, () -> "Expected valid school");
    }

    public static Result<HolderSet<SchoolType>, Problem> parseSchoolTag(JsonElement element) {
        return ExtendedJson.parseSomethingTag((IForgeRegistry)SchoolRegistry.REGISTRY.get(), element, () -> "Expected valid school tag");
    }

    public static Result<HolderSet<SchoolType>, Problem> parseSchoolOrSchoolTag(JsonElement element) {
        return ExtendedJson.parseSomethingOrSomethingTag((IForgeRegistry)SchoolRegistry.REGISTRY.get(), element, () -> "Expected valid school or school tag");
    }

    private static <T> Result<T, Problem> parseSomething(IForgeRegistry<T> registry, JsonElement element, Supplier<String> message) {
        try {
            String string = element.getJson().getAsString();
            return Result.success((Object)registry.getDelegateOrThrow(new ResourceLocation(string)).get());
        }
        catch (Exception ignored) {
            return Result.failure((Object)element.getPath().createProblem(message.get()));
        }
    }

    private static <T> Result<HolderSet<T>, Problem> parseSomethingTag(IForgeRegistry<T> registry, JsonElement element, Supplier<String> message) {
        try {
            String string = element.getJson().getAsString();
            if (string.startsWith("#")) {
                string = string.substring(1);
            }
            return Result.success((Object)HolderSet.m_205800_(registry.tags().getTag(TagKey.m_203882_((ResourceKey)registry.getRegistryKey(), (ResourceLocation)new ResourceLocation(string))).stream().map(Holder::m_205709_).toList()));
        }
        catch (Exception ignored) {
            return Result.failure((Object)element.getPath().createProblem(message.get()));
        }
    }

    private static <T> Result<HolderSet<T>, Problem> parseSomethingOrSomethingTag(IForgeRegistry<T> registry, JsonElement element, Supplier<String> message) {
        try {
            String string = element.getJson().getAsString();
            return string.startsWith("#") ? Result.success((Object)HolderSet.m_205800_(registry.tags().getTag(TagKey.m_203882_((ResourceKey)registry.getRegistryKey(), (ResourceLocation)new ResourceLocation(string.substring(1)))).stream().map(Holder::m_205709_).toList())) : Result.success((Object)HolderSet.m_205809_((Holder[])new Holder[]{Holder.m_205709_((Object)registry.getValue(new ResourceLocation(string)))}));
        }
        catch (Exception ignored) {
            return Result.failure((Object)element.getPath().createProblem(message.get()));
        }
    }
}

