/*
 * Decompiled with CFR 0.152.
 */
package tamaized.voidscape.client;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.blockentity.TheEndPortalRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.common.MinecraftForge;
import org.joml.Matrix4f;
import tamaized.voidscape.Voidscape;
import tamaized.voidscape.capability.SubCapability;
import tamaized.voidscape.client.RenderStateAccessor;
import tamaized.voidscape.client.Shaders;
import tamaized.voidscape.client.ui.RenderTurmoil;

public class DonatorLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("voidscape", "textures/entity/donator.png");
    private static final Function<Supplier<ShaderInstance>, RenderType> RENDER_TYPE = Util.m_143827_(shader -> RenderType.m_173215_((String)"voidscape_wings", (VertexFormat)DefaultVertexFormat.f_85819_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_110685_(RenderStateAccessor.TRANSLUCENT_TRANSPARENCY()).m_110661_(RenderStateAccessor.NO_CULL()).m_173292_(new RenderStateShard.ShaderStateShard(shader)).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.MultiTextureStateShard.Builder().m_173132_(TEXTURE, false, false).m_173132_(TheEndPortalRenderer.f_112627_, false, false).m_173131_()).m_110691_(true)));
    private static final RenderType WRAPPED_POS_TEX_COLOR = RENDER_TYPE.apply(GameRenderer::m_172820_);
    private static final RenderType WINGS = RENDER_TYPE.apply(() -> Shaders.VOIDSKY_WINGS);
    private static final MultiBufferSource.BufferSource BUFFERS = MultiBufferSource.m_109900_((Map)((Map)Util.m_137469_((Object)new Object2ObjectLinkedOpenHashMap(), map -> {
        map.put((Object)WRAPPED_POS_TEX_COLOR, (Object)new BufferBuilder(WRAPPED_POS_TEX_COLOR.m_110507_()));
        map.put((Object)WINGS, (Object)new BufferBuilder(WINGS.m_110507_()));
    })), (BufferBuilder)new BufferBuilder(256));

    public DonatorLayer(RenderLayerParent<T, M> p_117346_) {
        super(p_117346_);
    }

    public static void setup() {
        MinecraftForge.EVENT_BUS.addListener(event -> {
            if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
                BUFFERS.m_109911_();
            }
        });
    }

    public void render(PoseStack stack, MultiBufferSource multibuffer, int packedLightIn, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        entity.getCapability(SubCapability.CAPABILITY).ifPresent(cap -> cap.get(Voidscape.subCapDonatorData).ifPresent(data -> {
            if (data.enabled) {
                VertexConsumer buffer = BUFFERS.m_6299_(WRAPPED_POS_TEX_COLOR);
                float x1 = 0.1f;
                float y1 = -0.75f;
                float z1 = 0.75f;
                float x2 = x1 + 1.0f;
                float y2 = y1 + 1.0f;
                float z2 = z1 - 0.75f;
                RenderTurmoil.Color24 color = RenderTurmoil.Color24.INSTANCE;
                Consumer<VertexConsumer> vertexColor = verticies -> verticies.m_6122_(color.bit16, color.bit8, color.bit0, color.bit24).m_5752_();
                color.set(0.25f, 0.0f, 0.0f, 0.0f);
                stack.m_85836_();
                stack.m_252781_(Axis.f_252393_.m_252977_(-25.0f));
                stack.m_252781_(Axis.f_252495_.m_252977_(15.0f));
                Matrix4f pose = stack.m_85850_().m_252922_();
                vertexColor.accept(buffer.m_252986_(pose, x2, y2, z1).m_7421_(0.0f, 1.0f));
                vertexColor.accept(buffer.m_252986_(pose, x2, y1, z1).m_7421_(0.0f, 0.0f));
                vertexColor.accept(buffer.m_252986_(pose, x1, y1, z2).m_7421_(1.0f, 0.0f));
                vertexColor.accept(buffer.m_252986_(pose, x1, y2, z2).m_7421_(1.0f, 1.0f));
                stack.m_85849_();
                stack.m_85836_();
                pose = stack.m_85850_().m_252922_();
                stack.m_252781_(Axis.f_252393_.m_252977_(25.0f));
                stack.m_252781_(Axis.f_252495_.m_252977_(15.0f));
                float offset = -1.2f;
                vertexColor.accept(buffer.m_252986_(pose, x1 + offset, y2, z1).m_7421_(0.0f, 1.0f));
                vertexColor.accept(buffer.m_252986_(pose, x1 + offset, y1, z1).m_7421_(0.0f, 0.0f));
                vertexColor.accept(buffer.m_252986_(pose, x2 + offset, y1, z2).m_7421_(1.0f, 0.0f));
                vertexColor.accept(buffer.m_252986_(pose, x2 + offset, y2, z2).m_7421_(1.0f, 1.0f));
                stack.m_85849_();
                buffer = BUFFERS.m_6299_(WINGS);
                color.unpack(data.color);
                color.bit24 = 63;
                stack.m_85836_();
                stack.m_252781_(Axis.f_252393_.m_252977_(-25.0f));
                stack.m_252781_(Axis.f_252495_.m_252977_(15.0f));
                pose = stack.m_85850_().m_252922_();
                vertexColor.accept(buffer.m_252986_(pose, x2, y2, z1).m_7421_(0.0f, 1.0f));
                vertexColor.accept(buffer.m_252986_(pose, x2, y1, z1).m_7421_(0.0f, 0.0f));
                vertexColor.accept(buffer.m_252986_(pose, x1, y1, z2).m_7421_(1.0f, 0.0f));
                vertexColor.accept(buffer.m_252986_(pose, x1, y2, z2).m_7421_(1.0f, 1.0f));
                stack.m_85849_();
                stack.m_85836_();
                pose = stack.m_85850_().m_252922_();
                stack.m_252781_(Axis.f_252393_.m_252977_(25.0f));
                stack.m_252781_(Axis.f_252495_.m_252977_(15.0f));
                offset = -1.2f;
                vertexColor.accept(buffer.m_252986_(pose, x1 + offset, y2, z1).m_7421_(0.0f, 1.0f));
                vertexColor.accept(buffer.m_252986_(pose, x1 + offset, y1, z1).m_7421_(0.0f, 0.0f));
                vertexColor.accept(buffer.m_252986_(pose, x2 + offset, y1, z2).m_7421_(1.0f, 0.0f));
                vertexColor.accept(buffer.m_252986_(pose, x2 + offset, y2, z2).m_7421_(1.0f, 1.0f));
                stack.m_85849_();
            }
        }));
    }
}

