/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.rarcompat.items.hands;

import artifacts.registry.ModItems;
import it.hurts.octostudios.rarcompat.items.WearableRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class FeralClawsItem
extends WearableRelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"claws").stat(StatData.builder((String)"modifier").initialValue(0.05, 0.15).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.12).formatValue(value -> (int)MathUtils.round((double)(value * 100.0), (int)1)).build()).build()).build()).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(-9314292).borderBottom(-15103723).build()).build()).leveling(LevelingData.builder().initialCost(100).maxLevel(10).step(100).build()).loot(LootData.builder().entry(LootCollections.VILLAGE).entry(LootCollections.DESERT).entry(LootCollections.JUNGLE).entry(LootCollections.AQUATIC).entry(LootCollections.PILLAGE).entry(LootCollections.COLD).entry(LootCollections.SCULK).entry(LootCollections.ANTHROPOGENIC).build()).build();
    }

    public static void resetAttribute(Player player, ItemStack stack, FeralClawsItem relic) {
        EntityUtils.resetAttribute((LivingEntity)player, (ItemStack)stack, (Attribute)Attributes.f_22283_, (float)((float)((double)FeralClawsItem.getAttackCount(stack) * relic.getAbilityValue(stack, "claws", "modifier"))), (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_BASE);
    }

    public static void addTime(ItemStack stack, int val) {
        NBTUtils.setInt((ItemStack)stack, (String)"time", (int)Math.max(0, NBTUtils.getInt((ItemStack)stack, (String)"time", (int)0) + val));
    }

    public static int getTime(ItemStack stack) {
        return NBTUtils.getInt((ItemStack)stack, (String)"time", (int)0);
    }

    public static void addAttackCount(ItemStack stack, int val) {
        NBTUtils.setInt((ItemStack)stack, (String)"count", (int)Math.max(0, FeralClawsItem.getAttackCount(stack) + val));
    }

    public static int getAttackCount(ItemStack stack) {
        return NBTUtils.getInt((ItemStack)stack, (String)"count", (int)0);
    }

    public void onUnequip(LivingEntity entity, ItemStack stack) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        ItemStack currentStack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.FERAL_CLAWS.get()));
        if (!currentStack.m_41619_()) {
            return;
        }
        EntityUtils.removeAttribute((LivingEntity)entity, (ItemStack)stack, (Attribute)Attributes.f_22283_, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_BASE);
    }

    @Mod.EventBusSubscriber
    public static class FeralClawsEvent {
        @SubscribeEvent
        public static void onPlayerAttack(AttackEntityEvent event) {
            FeralClawsItem relic;
            Player player = event.getEntity();
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.FERAL_CLAWS.get()));
            Item item = stack.m_41720_();
            if (!(item instanceof FeralClawsItem) || !(relic = (FeralClawsItem)item).canPlayerUseActiveAbility(player, stack, "claws")) {
                return;
            }
            if (player.m_36403_(0.0f) != 1.0f) {
                relic.spreadExperience((LivingEntity)player, stack, 1);
            }
            FeralClawsItem.addAttackCount(stack, 1);
            FeralClawsItem.addTime(stack, -FeralClawsItem.getTime(stack));
            FeralClawsItem.resetAttribute(player, stack, relic);
        }

        @SubscribeEvent
        public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
            FeralClawsItem relic;
            Player player = event.player;
            if (event.phase != TickEvent.Phase.END || player.m_20193_().f_46443_) {
                return;
            }
            if (player.f_19797_ % 20 != 0) {
                return;
            }
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.FERAL_CLAWS.get()));
            Item item = stack.m_41720_();
            if (!(item instanceof FeralClawsItem) || !(relic = (FeralClawsItem)item).canPlayerUseActiveAbility(player, stack, "claws")) {
                return;
            }
            FeralClawsItem.addTime(stack, 1);
            int time = FeralClawsItem.getTime(stack);
            int attackCount = FeralClawsItem.getAttackCount(stack);
            if (player.m_36403_(0.0f) != 1.0f) {
                EntityUtils.removeAttribute((LivingEntity)player, (ItemStack)stack, (Attribute)Attributes.f_22283_, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_BASE);
                FeralClawsItem.addAttackCount(stack, -attackCount);
            }
            if (time >= 3) {
                if (attackCount <= 0) {
                    EntityUtils.removeAttribute((LivingEntity)player, (ItemStack)stack, (Attribute)Attributes.f_22283_, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_BASE);
                }
                if (time % 3 == 0 && attackCount > 0) {
                    FeralClawsItem.addAttackCount(stack, -1);
                    FeralClawsItem.resetAttribute(player, stack, relic);
                }
                FeralClawsItem.addTime(stack, -time);
            }
        }
    }
}

