/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.rarcompat.items;

import it.hurts.octostudios.rarcompat.items.WearableRelicItem;
import it.hurts.octostudios.rarcompat.network.packets.EntityMotionPacket;
import it.hurts.octostudios.rarcompat.network.packets.RepulsionUmbrellaPacket;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.network.packets.PacketPlayerMotion;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

public class UmbrellaItem
extends WearableRelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"glider").requiredPoints(2).stat(StatData.builder((String)"count").initialValue(1.0, 3.0).upgradeModifier(UpgradeOperation.ADD, 1.0).formatValue(value -> (int)MathUtils.round((double)value, (int)0)).build()).stat(StatData.builder((String)"cooldown").initialValue(2.0, 1.5).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, -0.07).formatValue(value -> MathUtils.round((double)value, (int)1)).build()).build()).ability(AbilityData.builder((String)"shield").requiredLevel(5).stat(StatData.builder((String)"knockback").initialValue(1.0, 3.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.1).formatValue(value -> MathUtils.round((double)value, (int)1)).build()).build()).build()).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(-4834773).borderBottom(-10481899).build()).build()).leveling(LevelingData.builder().initialCost(100).maxLevel(15).step(100).build()).loot(LootData.builder().entry(LootCollections.VILLAGE).build()).build();
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean isSelected) {
        Player player;
        if (!(entity instanceof Player) || !this.canPlayerUseActiveAbility(player = (Player)entity, stack, "glider")) {
            return;
        }
        boolean isOnGround = player.m_20096_();
        if (isOnGround && this.getCharges(stack) != this.getMaxCharges(stack)) {
            this.setCharges(stack, this.getMaxCharges(stack));
        }
        boolean hasUmbrella = false;
        for (InteractionHand hand : InteractionHand.values()) {
            if (player.m_21120_(hand) != stack) continue;
            hasUmbrella = true;
            break;
        }
        if (!hasUmbrella || player.isInFluidType() || player.m_20184_().f_82480_ > 0.0 || player.m_6144_()) {
            return;
        }
        Vec3 motion = player.m_20184_();
        player.m_20334_(motion.m_7096_(), -0.15, motion.m_7094_());
        player.f_19789_ = 0.0f;
        if (player.f_19797_ % 20 == 0 && !isOnGround) {
            this.spreadExperience((LivingEntity)player, stack, 1);
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (this.canPlayerUseActiveAbility(player, player.m_21120_(hand), "shield")) {
            player.m_6672_(hand);
            return InteractionResultHolder.m_19096_((Object)player.m_21120_(hand));
        }
        return InteractionResultHolder.m_19100_((Object)player.m_21120_(hand));
    }

    @NotNull
    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BLOCK;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public int m_142158_(ItemStack stack) {
        return Math.round(13.0f * (float)this.getCharges(stack) / (float)this.getMaxCharges(stack));
    }

    public boolean m_142522_(@NotNull ItemStack stack) {
        return this.getCharges(stack) != this.getMaxCharges(stack);
    }

    public int m_142159_(@NotNull ItemStack stack) {
        return Mth.m_14169_((float)(Math.max(0.0f, (float)this.getCharges(stack) / (float)this.getMaxCharges(stack)) / 3.0f), (float)1.0f, (float)1.0f);
    }

    public int getMaxCharges(ItemStack stack) {
        return (int)MathUtils.round((double)this.getAbilityValue(stack, "glider", "count"), (int)0);
    }

    public int getCharges(ItemStack stack) {
        return NBTUtils.getInt((ItemStack)stack, (String)"charge", (int)0);
    }

    public void setCharges(ItemStack stack, int amount) {
        NBTUtils.setInt((ItemStack)stack, (String)"charge", (int)Math.max(amount, 0));
    }

    public void addCharges(ItemStack stack, int amount) {
        this.setCharges(stack, this.getCharges(stack) + amount);
    }

    public static boolean isHoldingUmbrella(LivingEntity entity, InteractionHand hand) {
        return entity.m_21120_(hand).m_41720_() instanceof UmbrellaItem && (!entity.m_6117_() || entity.m_7655_() != hand);
    }

    @Mod.EventBusSubscriber
    public static class UmbrellaCommonEvents {
        @SubscribeEvent
        public static void onPlayerHurt(LivingAttackEvent event) {
            LivingEntity source;
            Object object;
            InteractionHand hand2;
            Player player;
            LivingEntity livingEntity = event.getEntity();
            if (!(livingEntity instanceof Player) || (player = (Player)livingEntity).m_20193_().m_5776_()) {
                return;
            }
            Level level = player.m_20193_();
            ItemStack stack = ItemStack.f_41583_;
            for (InteractionHand hand2 : InteractionHand.values()) {
                ItemStack entry = player.m_21120_(hand2);
                if (!(entry.m_41720_() instanceof UmbrellaItem)) continue;
                stack = entry;
                break;
            }
            if (stack.m_41619_()) {
                return;
            }
            UmbrellaItem relic = (UmbrellaItem)stack.m_41720_();
            if (level.m_5776_() || !player.m_6117_() || !((object = event.getSource().m_7639_()) instanceof LivingEntity) || (source = (LivingEntity)object).m_20182_().m_82546_(player.m_20182_()).m_82541_().m_82526_(player.m_20154_().m_82541_()) < (double)0.65f || player.m_36335_().m_41519_(stack.m_41720_())) {
                return;
            }
            hand2 = event.getSource().m_7640_();
            if (hand2 instanceof AbstractArrow) {
                AbstractArrow arrow = (AbstractArrow)hand2;
                it.hurts.octostudios.rarcompat.network.NetworkHandler.sendToClientsTrackingEntityAndSelf(new EntityMotionPacket(arrow.m_19879_(), arrow.m_20184_()), (Entity)arrow);
            }
            if (source.m_21205_().m_41720_() instanceof AxeItem) {
                player.m_36335_().m_41524_((Item)relic, 110);
                player.m_5810_();
                level.m_5594_(null, player.m_20183_(), SoundEvents.f_215672_, SoundSource.MASTER, 0.3f, 1.0f + player.m_217043_().m_188501_() * 0.25f);
            } else {
                level.m_5594_(null, player.m_20183_(), SoundEvents.f_215675_, SoundSource.MASTER, 0.3f, 1.0f + player.m_217043_().m_188501_() * 0.25f);
            }
            event.setCanceled(true);
            relic.spreadExperience((LivingEntity)player, stack, 1);
            for (LivingEntity entity2 : level.m_6443_(LivingEntity.class, player.m_20191_().m_82400_(3.0), entity -> !entity.m_20148_().equals(player.m_20148_()) && entity.m_6084_())) {
                Vec3 motion = entity2.m_20182_().m_82546_(player.m_20182_()).m_82541_().m_82490_((double)0.4f + relic.getAbilityValue(stack, "glider", "count") * (double)0.2f);
                if (entity2 instanceof Player) {
                    Player serverPlayer = (Player)entity2;
                    NetworkHandler.sendToClient((Object)new PacketPlayerMotion(motion.m_7096_(), motion.m_7098_() / 5.0, motion.m_7094_()), (ServerPlayer)((ServerPlayer)serverPlayer));
                } else {
                    entity2.m_20334_(motion.m_7096_(), motion.m_7098_() / 5.0, motion.m_7094_());
                }
                Vec3 pos = source.m_20182_().m_82549_(new Vec3(0.0, (double)(source.m_20206_() / 2.0f), 0.0));
                Vec3 velocity = motion.m_82541_().m_82490_(0.5);
                ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123796_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 10, velocity.f_82479_, velocity.f_82480_, velocity.f_82481_, (double)0.1f);
            }
        }
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT})
    public static class UmbrellaClientEvents {
        @SubscribeEvent
        public static void onLeftClickEmpty(PlayerInteractEvent.LeftClickEmpty event) {
            UmbrellaClientEvents.handleLeftClick((PlayerInteractEvent)event);
        }

        @SubscribeEvent
        public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
            if (event.getAction() == PlayerInteractEvent.LeftClickBlock.Action.START && event.getEntity().m_9236_().m_5776_()) {
                UmbrellaClientEvents.handleLeftClick((PlayerInteractEvent)event);
            }
        }

        private static void handleLeftClick(PlayerInteractEvent event) {
            UmbrellaItem relic;
            Player player = event.getEntity();
            ItemStack stack = player.m_21205_();
            Item item = stack.m_41720_();
            if (!(item instanceof UmbrellaItem) || !(relic = (UmbrellaItem)item).canPlayerUseActiveAbility(player, stack, "glider") || player.m_36335_().m_41519_((Item)relic) || relic.getCharges(stack) <= 0) {
                return;
            }
            it.hurts.octostudios.rarcompat.network.NetworkHandler.sendToServer(new RepulsionUmbrellaPacket());
            Vec3 angle = player.m_20154_().m_82490_((double)-1.15f);
            Vec3 motion = player.m_20184_().m_82549_(angle);
            if (angle.f_82480_ < 0.0) {
                player.m_20256_(new Vec3(motion.m_7096_(), 0.0, motion.m_7094_()));
            } else {
                player.m_20334_(motion.m_7096_(), angle.m_7098_(), motion.m_7094_());
            }
        }

        @SubscribeEvent
        public static void onLivingRender(RenderLivingEvent.Pre<?, ?> event) {
            boolean isRightHanded;
            Player player;
            LivingEntity livingEntity;
            block7: {
                block6: {
                    livingEntity = event.getEntity();
                    if (!(livingEntity instanceof Player)) break block6;
                    player = (Player)livingEntity;
                    livingEntity = event.getRenderer().m_7200_();
                    if (livingEntity instanceof HumanoidModel) break block7;
                }
                return;
            }
            HumanoidModel humanoidModel = (HumanoidModel)livingEntity;
            boolean isHoldingOffHand = UmbrellaItem.isHoldingUmbrella((LivingEntity)player, InteractionHand.OFF_HAND);
            boolean isHoldingMainHand = UmbrellaItem.isHoldingUmbrella((LivingEntity)player, InteractionHand.MAIN_HAND);
            boolean bl = isRightHanded = player.m_5737_() == HumanoidArm.RIGHT;
            if (player.m_6144_() && !player.m_20096_() && (isHoldingMainHand || isHoldingOffHand)) {
                return;
            }
            if (isHoldingMainHand && isRightHanded || isHoldingOffHand && !isRightHanded) {
                humanoidModel.f_102816_ = HumanoidModel.ArmPose.THROW_SPEAR;
            }
            if (isHoldingMainHand && !isRightHanded || isHoldingOffHand && isRightHanded) {
                humanoidModel.f_102815_ = HumanoidModel.ArmPose.THROW_SPEAR;
            }
        }
    }
}

