/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterdungeons.world.structure.spider_dungeon.piece;

import com.yungnickyoung.minecraft.betterdungeons.mixin.accessor.BoundingBoxAccessor;
import com.yungnickyoung.minecraft.betterdungeons.module.StructurePieceTypeModule;
import com.yungnickyoung.minecraft.betterdungeons.world.structure.spider_dungeon.piece.SpiderDungeonNestPiece;
import com.yungnickyoung.minecraft.betterdungeons.world.structure.spider_dungeon.piece.SpiderDungeonPiece;
import com.yungnickyoung.minecraft.betterdungeons.world.structure.spider_dungeon.piece.SpiderDungeonSmallTunnelPiece;
import java.util.BitSet;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.material.Fluids;

@ParametersAreNonnullByDefault
public class SpiderDungeonBigTunnelPiece
extends SpiderDungeonPiece {
    private final BlockPos startPos;
    private BlockPos endPos;
    private float pitch = 0.0f;
    private final float[] yaws = new float[30];
    private static final int LENGTH = 30;
    private static final float X_MINRADIUS = 2.0f;
    private static final float X_MAXRADIUS = 2.5f;
    private static final float Y_MINRADIUS = 2.0f;
    private static final float Y_MAXRADIUS = 2.5f;
    private static final float Z_MINRADIUS = 2.0f;
    private static final float Z_MAXRADIUS = 2.5f;

    public SpiderDungeonBigTunnelPiece(BlockPos startPos) {
        this(startPos, 0);
    }

    public SpiderDungeonBigTunnelPiece(BlockPos startPos, int pieceChainLength, float initialPitch, float initialYaw) {
        this(startPos, pieceChainLength);
        this.pitch = initialPitch;
        this.yaws[0] = initialYaw;
    }

    public SpiderDungeonBigTunnelPiece(CompoundTag compoundTag) {
        super(StructurePieceTypeModule.BIG_TUNNEL, compoundTag);
        int[] start = compoundTag.m_128465_("startPos");
        int[] end = compoundTag.m_128465_("endPos");
        this.startPos = new BlockPos(start[0], start[1], start[2]);
        this.endPos = new BlockPos(end[0], end[1], end[2]);
        this.pitch = compoundTag.m_128457_("pitch");
        ListTag yawListNBT = compoundTag.m_128437_("yawList", 5);
        for (int i = 0; i < 30; ++i) {
            this.yaws[i] = yawListNBT.m_128775_(i);
        }
    }

    private SpiderDungeonBigTunnelPiece(BlockPos startPos, int pieceChainLength) {
        super(StructurePieceTypeModule.BIG_TUNNEL, pieceChainLength, SpiderDungeonBigTunnelPiece.getInitialBoundingBox(startPos));
        this.startPos = new BlockPos((Vec3i)startPos);
        this.endPos = new BlockPos((Vec3i)startPos);
    }

    protected void m_183620_(StructurePieceSerializationContext structurePieceSerializationContext, CompoundTag compoundTag) {
        compoundTag.m_128385_("startPos", new int[]{this.startPos.m_123341_(), this.startPos.m_123342_(), this.startPos.m_123343_()});
        compoundTag.m_128385_("endPos", new int[]{this.endPos.m_123341_(), this.endPos.m_123342_(), this.endPos.m_123343_()});
        compoundTag.m_128350_("pitch", this.pitch);
        ListTag yawListNBT = new ListTag();
        for (int i = 0; i < 30; ++i) {
            yawListNBT.add((Object)FloatTag.m_128566_((float)this.yaws[i]));
        }
        compoundTag.m_128365_("yawList", (Tag)yawListNBT);
    }

    public void m_214092_(StructurePiece structurePiece, StructurePieceAccessor structurePieceAccessor, RandomSource randomSource) {
        if (this.pitch == 0.0f) {
            this.pitch = Mth.m_14036_((float)(randomSource.m_188501_() * (float)(-Math.PI)), (float)-2.6f, (float)-0.6f);
        }
        if (this.pitch > -2.2f && this.pitch < -1.0f) {
            this.pitch = -2.2f;
        }
        float pitchY = Mth.m_14031_((float)this.pitch);
        float pitchXZ = Mth.m_14089_((float)this.pitch);
        if (this.yaws[0] == 0.0f) {
            this.yaws[0] = randomSource.m_188501_() * ((float)Math.PI * 2);
        }
        float yawModifier = 0.0f;
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxY = Integer.MIN_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxZ = Integer.MIN_VALUE;
        float caveStartX = this.startPos.m_123341_();
        float caveStartY = this.startPos.m_123342_();
        float caveStartZ = this.startPos.m_123343_();
        caveStartX += Mth.m_14089_((float)this.yaws[0]) * pitchXZ;
        caveStartY += Mth.m_14031_((float)pitchY);
        caveStartZ += Mth.m_14031_((float)this.yaws[0]) * pitchXZ;
        if (caveStartX - 2.5f - 4.0f < (float)minX) {
            minX = (int)caveStartX - 2 - 4;
        }
        if (caveStartX + 2.5f + 4.0f > (float)maxX) {
            maxX = (int)caveStartX + 2 + 4;
        }
        if (caveStartY - 2.5f - 4.0f < (float)minY) {
            minY = (int)caveStartY - 2 - 4;
        }
        if (caveStartY + 2.5f + 4.0f > (float)maxY) {
            maxY = (int)caveStartY + 2 + 4;
        }
        if (caveStartZ - 2.5f - 4.0f < (float)minZ) {
            minZ = (int)caveStartZ - 2 - 4;
        }
        if (caveStartZ + 2.5f + 4.0f > (float)maxZ) {
            maxZ = (int)caveStartZ + 2 + 4;
        }
        for (int i = 1; i < 30; ++i) {
            yawModifier *= 0.75f;
            this.yaws[i] = this.yaws[i - 1] + (yawModifier += randomSource.m_188501_() * randomSource.m_188501_()) * 0.01f;
            caveStartX += Mth.m_14089_((float)this.yaws[i]) * pitchXZ;
            caveStartY += Mth.m_14031_((float)pitchY);
            caveStartZ += Mth.m_14031_((float)this.yaws[i]) * pitchXZ;
            if (caveStartX - 2.5f - 4.0f < (float)minX) {
                minX = (int)caveStartX - 2 - 4;
            }
            if (caveStartX + 2.5f + 4.0f > (float)maxX) {
                maxX = (int)caveStartX + 2 + 4;
            }
            if (caveStartY - 2.5f - 4.0f < (float)minY) {
                minY = (int)caveStartY - 2 - 4;
            }
            if (caveStartY + 2.5f + 4.0f > (float)maxY) {
                maxY = (int)caveStartY + 2 + 4;
            }
            if (caveStartZ - 2.5f - 4.0f < (float)minZ) {
                minZ = (int)caveStartZ - 2 - 4;
            }
            if (!(caveStartZ + 2.5f + 4.0f > (float)maxZ)) continue;
            maxZ = (int)caveStartZ + 2 + 4;
        }
        ((BoundingBoxAccessor)this.f_73383_).setMinX(minX);
        ((BoundingBoxAccessor)this.f_73383_).setMaxX(maxX);
        ((BoundingBoxAccessor)this.f_73383_).setMinY(minY);
        ((BoundingBoxAccessor)this.f_73383_).setMaxY(maxY);
        ((BoundingBoxAccessor)this.f_73383_).setMinZ(minZ);
        ((BoundingBoxAccessor)this.f_73383_).setMaxZ(maxZ);
        this.endPos = new BlockPos((int)caveStartX, (int)caveStartY, (int)caveStartZ);
        if (this.f_73384_ == 0) {
            SpiderDungeonBigTunnelPiece nextBigTunnelPiece = new SpiderDungeonBigTunnelPiece(this.endPos, this.f_73384_ + 1, 0.0f, this.yaws[29]);
            structurePieceAccessor.m_142679_((StructurePiece)nextBigTunnelPiece);
            nextBigTunnelPiece.m_214092_(nextBigTunnelPiece, structurePieceAccessor, randomSource);
        }
        float smallTunnelAngle = this.yaws[29] + 0.3f;
        SpiderDungeonSmallTunnelPiece smallTunnelPiece1 = new SpiderDungeonSmallTunnelPiece(this.endPos, smallTunnelAngle += randomSource.m_188501_() * 0.4f + 0.9f, this.f_73384_ + 1);
        structurePieceAccessor.m_142679_((StructurePiece)smallTunnelPiece1);
        smallTunnelPiece1.m_214092_(smallTunnelPiece1, structurePieceAccessor, randomSource);
        SpiderDungeonSmallTunnelPiece smallTunnelPiece2 = new SpiderDungeonSmallTunnelPiece(this.endPos, smallTunnelAngle += randomSource.m_188501_() * 0.4f + 0.9f, this.f_73384_ + 1);
        structurePieceAccessor.m_142679_((StructurePiece)smallTunnelPiece2);
        smallTunnelPiece2.m_214092_(smallTunnelPiece2, structurePieceAccessor, randomSource);
        SpiderDungeonSmallTunnelPiece smallTunnelPiece3 = new SpiderDungeonSmallTunnelPiece(this.endPos, smallTunnelAngle += randomSource.m_188501_() * 0.4f + 0.9f, this.f_73384_ + 1);
        structurePieceAccessor.m_142679_((StructurePiece)smallTunnelPiece3);
        smallTunnelPiece3.m_214092_(smallTunnelPiece3, structurePieceAccessor, randomSource);
        smallTunnelAngle += randomSource.m_188501_() * 0.4f + 0.9f;
        if (randomSource.m_188501_() < 0.5f) {
            SpiderDungeonSmallTunnelPiece smallTunnelPiece4 = new SpiderDungeonSmallTunnelPiece(this.endPos, smallTunnelAngle, this.f_73384_ + 1);
            structurePieceAccessor.m_142679_((StructurePiece)smallTunnelPiece4);
            smallTunnelPiece4.m_214092_(smallTunnelPiece4, structurePieceAccessor, randomSource);
        } else if (this.f_73384_ == 0) {
            SpiderDungeonBigTunnelPiece extraBigTunnelPiece = new SpiderDungeonBigTunnelPiece(this.endPos, this.f_73384_ + 1, randomSource.m_188501_() * (float)Math.PI / 6.0f - 0.5235988f, smallTunnelAngle);
            structurePieceAccessor.m_142679_((StructurePiece)extraBigTunnelPiece);
            extraBigTunnelPiece.m_214092_(extraBigTunnelPiece, structurePieceAccessor, randomSource);
        }
        SpiderDungeonNestPiece nestPiece = new SpiderDungeonNestPiece(this.endPos, this.f_73384_ + 1);
        structurePieceAccessor.m_142679_((StructurePiece)nestPiece);
        nestPiece.m_214092_(nestPiece, structurePieceAccessor, randomSource);
    }

    public void m_213694_(WorldGenLevel world, StructureManager structureManager, ChunkGenerator chunkGenerator, RandomSource randomSource, BoundingBox box, ChunkPos chunkPos, BlockPos blockPos) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        WorldgenRandom decoRand = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        decoRand.m_190068_(world.m_7328_(), this.startPos.m_123341_(), this.startPos.m_123343_());
        int xBits = 4;
        int zBits = 4;
        int yBits = Mth.m_14163_((int)(world.m_151558_() - world.m_141937_()));
        BitSet carvingMask = new BitSet((int)Math.pow(2.0, xBits + zBits + yBits));
        int[] surface = new int[256];
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                mutable.m_122178_(chunkPos.m_45604_() + x, 1, chunkPos.m_45605_() + z);
                surface[x * 16 + z] = world.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, mutable.m_123341_(), mutable.m_123343_());
            }
        }
        float caveStartX = this.startPos.m_123341_();
        float caveStartY = this.startPos.m_123342_();
        float caveStartZ = this.startPos.m_123343_();
        for (int i = 0; i < 30; ++i) {
            float pitchY = Mth.m_14031_((float)this.pitch);
            float pitchXZ = Mth.m_14089_((float)this.pitch);
            float yaw = this.yaws[i];
            caveStartX += Mth.m_14089_((float)yaw) * pitchXZ;
            caveStartY += Mth.m_14031_((float)pitchY);
            caveStartZ += Mth.m_14031_((float)yaw) * pitchXZ;
            float xRadius = Mth.m_14179_((float)Mth.m_14031_((float)((float)i * (float)Math.PI / 30.0f)), (float)2.0f, (float)2.5f);
            float yRadius = Mth.m_14179_((float)Mth.m_14031_((float)((float)i * (float)Math.PI / 30.0f)), (float)2.0f, (float)2.5f);
            float zRadius = Mth.m_14179_((float)Mth.m_14031_((float)((float)i * (float)Math.PI / 30.0f)), (float)2.0f, (float)2.5f);
            int minX = Mth.m_14143_((float)(caveStartX - xRadius)) - chunkPos.f_45578_ * 16 - 1;
            int maxX = Mth.m_14143_((float)(caveStartX + xRadius)) - chunkPos.f_45578_ * 16 + 1;
            int minY = Mth.m_14045_((int)(Mth.m_14143_((float)(caveStartY - yRadius)) - 1), (int)world.m_141937_(), (int)world.m_151558_());
            int maxY = Mth.m_14045_((int)(Mth.m_14143_((float)(caveStartY + yRadius)) + 1), (int)world.m_141937_(), (int)world.m_151558_());
            int minZ = Mth.m_14143_((float)(caveStartZ - zRadius)) - chunkPos.f_45579_ * 16 - 1;
            int maxZ = Mth.m_14143_((float)(caveStartZ + zRadius)) - chunkPos.f_45579_ * 16 + 1;
            minX = Mth.m_14045_((int)minX, (int)0, (int)15);
            maxX = Mth.m_14045_((int)maxX, (int)0, (int)15);
            minZ = Mth.m_14045_((int)minZ, (int)0, (int)15);
            maxZ = Mth.m_14045_((int)maxZ, (int)0, (int)15);
            for (float x = (float)minX; x <= (float)maxX; x += 1.0f) {
                int globalX = (int)x + chunkPos.f_45578_ * 16;
                if (globalX < chunkPos.m_45604_() || globalX > chunkPos.m_45608_()) continue;
                float radialXDist = ((float)globalX - caveStartX + 0.5f) / xRadius;
                for (float z = (float)minZ; z <= (float)maxZ; z += 1.0f) {
                    int globalY;
                    int globalZ = (int)z + chunkPos.f_45579_ * 16;
                    if (globalZ < chunkPos.m_45605_() || globalZ > chunkPos.m_45609_()) continue;
                    float radialZDist = ((float)globalZ - caveStartZ + 0.5f) / zRadius;
                    for (float y = (float)minY; y <= (float)maxY && (globalY = (int)y) <= surface[(int)x % 16 * 16 + (int)z % 16]; y += 1.0f) {
                        BlockState state;
                        float radialYDist = (y - caveStartY - 0.5f) / yRadius;
                        int mask = (int)x | (int)z << 4 | (int)(y - (float)world.m_141937_()) << 8;
                        float radialDist = radialXDist * radialXDist + radialYDist * radialYDist + radialZDist * radialZDist;
                        if (!carvingMask.get(mask) && (double)radialDist < 1.0) {
                            if (BLOCK_BLACKLIST.contains(this.m_73398_((BlockGetter)world, globalX, globalY, globalZ, box).m_60734_())) continue;
                            this.m_73434_(world, Blocks.f_50627_.m_49966_(), globalX, globalY, globalZ, box);
                            carvingMask.set(mask);
                            continue;
                        }
                        float radialXDistShell = ((float)globalX - caveStartX + 0.5f) / (xRadius + 1.2f);
                        float radialYDistShell = (y - caveStartY - 0.5f) / (yRadius + 1.2f);
                        float radialZDistShell = ((float)globalZ - caveStartZ + 0.5f) / (zRadius + 1.2f);
                        float radialDistShell = radialXDistShell * radialXDistShell + radialYDistShell * radialYDistShell + radialZDistShell * radialZDistShell;
                        if (carvingMask.get(mask) || !((double)radialDistShell < 1.0) || BLOCK_BLACKLIST.contains((state = this.m_73398_((BlockGetter)world, globalX, globalY, globalZ, box)).m_60734_()) || !state.m_60795_() && state.m_60819_().m_76152_() == Fluids.f_76191_ && !(decoRand.m_188501_() < 0.2f)) continue;
                        this.m_73434_(world, Blocks.f_50652_.m_49966_(), globalX, globalY, globalZ, box);
                    }
                }
            }
        }
        this.decorateCave(world, (RandomSource)decoRand, chunkPos, box, carvingMask);
    }
}

