/*
 * Decompiled with CFR 0.152.
 */
package mekanism.tools.common.recipe;

import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.math.MathUtils;
import mekanism.common.recipe.WrappedShapedRecipe;
import mekanism.tools.common.registries.ToolsRecipeSerializers;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;

@NothingNullByDefault
public class PaxelRecipe
extends WrappedShapedRecipe {
    public PaxelRecipe(ShapedRecipe internal) {
        super(internal);
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ToolsRecipeSerializers.PAXEL.get();
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess registryAccess) {
        ItemStack resultItem = this.m_8043_(registryAccess);
        if (resultItem.m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack toReturn = resultItem.m_41777_();
        if (!toReturn.m_41763_() || toReturn.m_41768_()) {
            return toReturn;
        }
        int totalDurability = 0;
        int totalMaxDurability = 0;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_() || !stack.m_41720_().isDamageable(stack)) continue;
            int max = stack.m_41776_();
            totalDurability += max - stack.m_41773_();
            totalMaxDurability += max;
        }
        if (totalDurability == totalMaxDurability) {
            return toReturn;
        }
        int maxDurability = toReturn.m_41776_();
        int targetDurability = MathUtils.clampToInt((double)((double)maxDurability * ((double)totalDurability / (double)totalMaxDurability)));
        if (targetDurability == 0) {
            return ItemStack.f_41583_;
        }
        if (targetDurability < maxDurability) {
            toReturn.m_41721_(maxDurability - targetDurability);
        }
        return toReturn;
    }
}

