/*
 * Decompiled with CFR 0.152.
 */
package net.brazier_modding.gdarp.pack_finders;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.brazier_modding.gdarp.Constants;
import net.minecraft.ChatFormatting;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.FilePackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.linkfs.LinkFileSystem;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.world.flag.FeatureFlagSet;

public class GlobalPackFinder
implements RepositorySource {
    private static final Predicate<Path> IS_VALID_RESOURCE_PACK = pack -> {
        if (Files.isSymbolicLink(pack)) {
            return false;
        }
        boolean flag = true;
        if (Files.isRegularFile(pack, new LinkOption[0]) && pack.toString().endsWith(".zip")) {
            try (FileSystem fs = FileSystems.newFileSystem(pack);){
                flag &= Files.isDirectory(fs.getPath("assets/", new String[0]), new LinkOption[0]);
                flag &= Files.isRegularFile(fs.getPath("pack.mcmeta", new String[0]), new LinkOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            flag &= Files.isDirectory(pack.resolve("assets/"), new LinkOption[0]);
            flag &= Files.isRegularFile(pack.resolve("pack.mcmeta"), new LinkOption[0]);
        }
        return flag;
    };
    private static final Predicate<Path> IS_VALID_DATA_PACK = pack -> {
        if (Files.isSymbolicLink(pack)) {
            return false;
        }
        boolean flag = true;
        if (Files.isRegularFile(pack, new LinkOption[0]) && pack.toString().endsWith(".zip")) {
            try (FileSystem fs = FileSystems.newFileSystem(pack);){
                flag &= Files.isDirectory(fs.getPath("data/", new String[0]), new LinkOption[0]);
                flag &= Files.isRegularFile(fs.getPath("pack.mcmeta", new String[0]), new LinkOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            flag &= Files.isDirectory(pack.resolve("data"), new LinkOption[0]);
            flag &= Files.isRegularFile(pack.resolve("pack.mcmeta"), new LinkOption[0]);
        }
        return flag;
    };
    private static PackSource GLOBAL = PackSource.m_247176_(name -> name.m_6881_().m_130946_(" (Global)").m_130940_(ChatFormatting.AQUA), (boolean)true);
    private static PackSource GLOBAL_OPT = PackSource.m_247176_(name -> name.m_6881_().m_130946_(" (Global Optional)").m_130940_(ChatFormatting.DARK_AQUA), (boolean)false);
    public final PackType packType;
    private final boolean forcedPacks;
    private final ImmutableList<Path> packLocations;

    public GlobalPackFinder(PackType packType, boolean required, List<Path> packLocations) {
        this.packType = packType;
        this.forcedPacks = required;
        this.packLocations = ImmutableList.builder().addAll(packLocations).build();
    }

    public void m_7686_(Consumer<Pack> packRegistrar) {
        try {
            this.discoverResourcePacks(path -> {
                Pack pack;
                Pack.ResourcesSupplier resourceSupplier = null;
                resourceSupplier = Files.isRegularFile(path, new LinkOption[0]) && path.toString().endsWith(".zip") ? this.createFilePack((Path)path) : this.createFolderPack((Path)path);
                if (resourceSupplier == null) {
                    return;
                }
                Pack.Info packInfo = Pack.m_246334_((String)path.getFileName().toString(), (Pack.ResourcesSupplier)resourceSupplier);
                if (packInfo == null) {
                    packInfo = new Pack.Info((Component)Component.m_237113_((String)path.getFileName().toString()), SharedConstants.m_183709_().m_264084_(this.packType), FeatureFlagSet.m_246902_());
                }
                if ((pack = Pack.m_245512_((String)path.getFileName().toString(), (Component)Component.m_237113_((String)path.getFileName().toString()), (boolean)this.forcedPacks, (Pack.ResourcesSupplier)resourceSupplier, (Pack.Info)packInfo, (PackType)this.packType, (Pack.Position)Pack.Position.TOP, (boolean)true, (PackSource)(this.forcedPacks ? GLOBAL : GLOBAL_OPT))) != null) {
                    packRegistrar.accept(pack);
                }
            });
        }
        catch (IOException e) {
            Constants.LOG.error((Object)e);
        }
    }

    private Pack.ResourcesSupplier createFilePack(Path path) {
        Object supplier = null;
        FileSystem fs = path.getFileSystem();
        if (this.packType == PackType.CLIENT_RESOURCES && !IS_VALID_RESOURCE_PACK.test(path)) {
            return null;
        }
        if (this.packType == PackType.SERVER_DATA && !IS_VALID_DATA_PACK.test(path)) {
            return null;
        }
        if (fs == FileSystems.getDefault() || fs instanceof LinkFileSystem) {
            return id -> new FilePackResources(id, path.toFile(), false);
        }
        return null;
    }

    private Pack.ResourcesSupplier createFolderPack(Path path) {
        if (this.packType == PackType.CLIENT_RESOURCES && !IS_VALID_RESOURCE_PACK.test(path)) {
            return null;
        }
        if (this.packType == PackType.SERVER_DATA && !IS_VALID_DATA_PACK.test(path)) {
            return null;
        }
        return id -> new PathPackResources(id, path, false);
    }

    private void discoverResourcePacks(Consumer<Path> packCallback) throws IOException {
        ArrayList<Path> packs = new ArrayList<Path>();
        ArrayList<Path> directoryPacks = new ArrayList<Path>();
        for (Path path : this.packLocations) {
            if (Files.isDirectory(path, new LinkOption[0])) {
                if (Files.isRegularFile(path.resolve("pack.mcmeta"), new LinkOption[0])) {
                    this.addNoDuplicatePaths(packs, directoryPacks, path, false);
                    continue;
                }
                if (Files.notExists(path, new LinkOption[0])) {
                    Files.createDirectories(path, new FileAttribute[0]);
                }
                try (Stream<Path> fileStream = Files.list(path);){
                    fileStream.forEach(filePath -> {
                        if (Files.isRegularFile(filePath, new LinkOption[0]) || Files.isDirectory(filePath, new LinkOption[0]) && Files.isRegularFile(filePath.resolve("pack.mcmeta"), new LinkOption[0])) {
                            this.addNoDuplicatePaths((List<Path>)packs, (List<Path>)directoryPacks, (Path)filePath, true);
                        }
                    });
                }
                catch (IOException e) {
                    Constants.LOG.error((Object)e);
                }
                continue;
            }
            this.addNoDuplicatePaths(packs, directoryPacks, path, false);
        }
        LinkedList<Path> noDuplicatePacks = new LinkedList<Path>();
        block8: for (Path pack : packs) {
            for (Path pack2 : noDuplicatePacks) {
                if (!Files.isSameFile(pack, pack2)) continue;
                continue block8;
            }
            noDuplicatePacks.addFirst(pack);
        }
        for (Path pack : noDuplicatePacks) {
            packCallback.accept(pack);
        }
    }

    private void addNoDuplicatePaths(List<Path> packs, List<Path> directoryPacks, Path path, boolean isLowPriority) {
        try {
            for (int i = 0; i < packs.size(); ++i) {
                Path firstPath = packs.get(i);
                if (!Files.isSameFile(firstPath, path)) continue;
                for (int j = 0; j < directoryPacks.size(); ++j) {
                    Path dirPath = directoryPacks.get(j);
                    if (!Files.isSameFile(dirPath, path)) continue;
                    Constants.LOG.info("Pack {} with lower priority, overrides Pack {} added by a folder entry.", (Object)path, (Object)firstPath);
                    packs.set(i, path);
                    if (isLowPriority) {
                        directoryPacks.set(j, path);
                    } else {
                        directoryPacks.remove(j);
                    }
                    return;
                }
                Constants.LOG.info("Pack with the path {} has already been loaded with higher priority, skipping it.", (Object)path);
                return;
            }
            packs.add(path);
            if (isLowPriority) {
                directoryPacks.add(path);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

