/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.network;

import com.brutalbosses.BrutalBosses;
import com.brutalbosses.event.ClientEventHandler;
import com.brutalbosses.network.IMessage;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class BossOverlayMessage
implements IMessage {
    private int entityID = -1;

    public BossOverlayMessage(int entityID) {
        this.entityID = entityID;
    }

    public BossOverlayMessage() {
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.entityID);
    }

    @Override
    public BossOverlayMessage read(FriendlyByteBuf buffer) {
        this.entityID = buffer.readInt();
        return this;
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        if (contextSupplier.get().getDirection() != NetworkDirection.PLAY_TO_CLIENT) {
            BrutalBosses.LOGGER.error("Boss Overlay message sent to the wrong side!", (Throwable)new Exception());
        } else {
            Entity entity = Minecraft.m_91087_().f_91074_.m_9236_().m_6815_(this.entityID);
            if (entity != null) {
                ClientEventHandler.checkEntity(entity);
            }
        }
        contextSupplier.get().setPacketHandled(true);
    }
}

