/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.foundation.copycat.multistate;

import com.copycatsplus.copycats.Copycats;
import com.copycatsplus.copycats.foundation.copycat.ICopycatBlockEntity;
import com.copycatsplus.copycats.foundation.copycat.multistate.IMultiStateCopycatBlockEntity;
import com.copycatsplus.copycats.foundation.copycat.multistate.MaterialItemStorage;
import com.copycatsplus.copycats.foundation.copycat.multistate.MultiStateCopycatBlock;
import com.copycatsplus.copycats.utility.BlockEntityUtils;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MultiStateCopycatBlockEntity
extends SmartBlockEntity
implements IMultiStateCopycatBlockEntity {
    private MaterialItemStorage materialItemStorage;

    public MultiStateCopycatBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.init();
    }

    @Override
    public MaterialItemStorage getMaterialItemStorage() {
        return this.materialItemStorage;
    }

    @Override
    public void setMaterialItemStorageInternal(MaterialItemStorage storage) {
        this.materialItemStorage = storage;
    }

    @Override
    public void invalidate() {
        super.invalidate();
        IMultiStateCopycatBlockEntity.super.invalidate();
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    @Override
    public ItemRequirement getRequiredItems(BlockState state) {
        return IMultiStateCopycatBlockEntity.super.getRequiredItems(state);
    }

    public void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        IMultiStateCopycatBlockEntity.read(this, tag, clientPacket);
    }

    public void writeSafe(CompoundTag tag) {
        super.writeSafe(tag);
        IMultiStateCopycatBlockEntity.writeSafe(this, tag);
    }

    public void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        IMultiStateCopycatBlockEntity.write(this, tag, clientPacket);
    }

    public void migrateData(ICopycatBlockEntity copycatBlockEntity) {
        Block block = this.m_58900_().m_60734_();
        if (block instanceof MultiStateCopycatBlock) {
            MultiStateCopycatBlock mscb = (MultiStateCopycatBlock)block;
            ResourceLocation blockId = copycatBlockEntity.m_58900_().m_60734_().m_204297_().m_205785_().m_135782_();
            Copycats.LOGGER.debug("Converting block({}) at @{} to a multistate copycat", (Object)blockId.toString(), (Object)copycatBlockEntity.m_58899_().m_123344_());
            String firstProperty = this.getMaterialItemStorage().getAllProperties().stream().filter(prop -> mscb.partExists(this.m_58900_(), (String)prop)).findFirst().orElse(null);
            if (firstProperty == null) {
                Copycats.LOGGER.error("Failed to convert block({}) at @{} to a multistate copycat: no valid properties found", (Object)blockId.toString(), (Object)copycatBlockEntity.m_58899_().m_123344_());
                BlockEntityUtils.redraw((BlockEntity)this);
                return;
            }
            MaterialItemStorage.MaterialItem materialItem = this.materialItemStorage.getMaterialItem(firstProperty);
            materialItem.setMaterial(copycatBlockEntity.getMaterial());
            materialItem.setConsumedItem(copycatBlockEntity.getConsumedItem());
            for (String property : mscb.storageProperties()) {
                if (!mscb.partExists(this.m_58900_(), property) || this.getMaterialItemStorage().hasCustomMaterial(property)) continue;
                MaterialItemStorage.MaterialItem store = this.materialItemStorage.getMaterialItem(property);
                store.setMaterial(copycatBlockEntity.getMaterial());
                store.setConsumedItem(ItemStack.f_41583_);
            }
            BlockEntityUtils.redraw((BlockEntity)this);
        }
    }
}

