/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.client.render.item;

import com.mojang.blaze3d.platform.NativeImage;
import net.minecraft.Util;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class AlbumImageProcessor {
    private static final int COLOR_DIVISIONS = 16;
    private static final float[] POW22 = (float[])Util.m_137469_((Object)new float[256], fs -> {
        for (int i = 0; i < ((float[])fs).length; ++i) {
            fs[i] = (float)Math.pow((float)i / 255.0f, 2.2);
        }
    });

    public static NativeImage apply(NativeImage image, NativeImage overlay) {
        NativeImage nativeImage2 = new NativeImage(overlay.m_84982_(), overlay.m_85084_(), true);
        float xFactor = (float)image.m_84982_() / (float)(overlay.m_84982_() * 2);
        float yFactor = (float)image.m_85084_() / (float)(overlay.m_85084_() * 2);
        for (int m = 0; m < overlay.m_84982_(); ++m) {
            for (int n = 0; n < overlay.m_85084_(); ++n) {
                int x1 = (int)(xFactor * (float)m * 2.0f);
                int x2 = (int)(xFactor * (float)(m * 2 + 1));
                int y1 = (int)(yFactor * (float)n * 2.0f);
                int y2 = (int)(yFactor * (float)(n * 2 + 1));
                int baseColor = AlbumImageProcessor.alphaBlend(image.m_84985_(x1, y1), image.m_84985_(x2, y1), image.m_84985_(x1, y2), image.m_84985_(x2, y2));
                int overlayColor = overlay.m_84985_(m, n);
                nativeImage2.m_84988_(m, n, overlayColor & 0xFF000000 | AlbumImageProcessor.multiply(baseColor, overlayColor, 16) | AlbumImageProcessor.multiply(baseColor, overlayColor, 8) | AlbumImageProcessor.multiply(baseColor, overlayColor, 0));
            }
        }
        image.close();
        return nativeImage2;
    }

    private static int multiply(int col1, int col2, int bitOffset) {
        return ((int)((float)(col1 >> bitOffset & 0xFF) * ((float)(col2 >> bitOffset & 0xFF) / 255.0f) / 16.0f) * 16 & 0xFF) << bitOffset;
    }

    private static int alphaBlend(int col1, int col2, int col3, int col4) {
        int o = AlbumImageProcessor.gammaBlend(col1, col2, col3, col4, 16);
        int p = AlbumImageProcessor.gammaBlend(col1, col2, col3, col4, 8);
        int q = AlbumImageProcessor.gammaBlend(col1, col2, col3, col4, 0);
        return 0xFF000000 | o << 16 | p << 8 | q;
    }

    private static int gammaBlend(int col1, int col2, int col3, int col4, int bitOffset) {
        float f = AlbumImageProcessor.getPow22(col1 >> bitOffset);
        float g = AlbumImageProcessor.getPow22(col2 >> bitOffset);
        float h = AlbumImageProcessor.getPow22(col3 >> bitOffset);
        float i = AlbumImageProcessor.getPow22(col4 >> bitOffset);
        float j = (float)((double)((float)Math.pow((double)(f + g + h + i) * 0.25, 0.45454545454545453)));
        return (int)((double)j * 255.0);
    }

    private static float getPow22(int val) {
        return POW22[val & 0xFF];
    }
}

