/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bedbenefits.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.Expose;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import net.darkhax.bedbenefits.Constants;
import net.darkhax.bedbenefits.config.HealingSleepEffect;
import net.darkhax.bedbenefits.config.SleepOffEffect;
import net.darkhax.bookshelf.api.Services;

public class Config {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().excludeFieldsWithoutExposeAnnotation().create();
    @Expose
    public HealingSleepEffect restoreHealth = new HealingSleepEffect();
    @Expose
    public SleepOffEffect sleepOffEffects = new SleepOffEffect();

    public static Config load() {
        File configFile = Services.PLATFORM.getConfigPath().resolve("bedbenefits.json").toFile();
        Config config = new Config();
        if (configFile.exists()) {
            try (FileReader reader = new FileReader(configFile);){
                config = (Config)GSON.fromJson((Reader)reader, Config.class);
                Constants.LOG.info("Loaded config file.");
            }
            catch (Exception e) {
                Constants.LOG.error("Could not read config file {}. Defaults will be used.", (Object)configFile.getAbsolutePath());
                Constants.LOG.catching((Throwable)e);
            }
        } else {
            Constants.LOG.info("Creating a new config file at {}.", (Object)configFile.getAbsolutePath());
            configFile.getParentFile().mkdirs();
        }
        try (FileWriter writer = new FileWriter(configFile);){
            GSON.toJson((Object)config, (Appendable)writer);
            Constants.LOG.info("Saved config file.");
        }
        catch (Exception e) {
            Constants.LOG.error("Could not write config file '{}'!", (Object)configFile.getAbsolutePath());
            Constants.LOG.catching((Throwable)e);
        }
        return config;
    }
}

