/*
 * Decompiled with CFR 0.152.
 */
package com.cak.trading_floor.forge.content.depot.behavior;

import com.cak.trading_floor.content.trading_depot.behavior.CommonTradingDepotBehaviorAccess;
import com.cak.trading_floor.forge.content.depot.TradingDepotItemHandler;
import com.cak.trading_floor.foundation.TFLang;
import com.simibubi.create.content.kinetics.belt.BeltHelper;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.VersionedInventoryTrackerBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class TradingDepotBehaviour
extends BlockEntityBehaviour
implements CommonTradingDepotBehaviorAccess {
    public static final BehaviourType<TradingDepotBehaviour> TYPE = new BehaviourType();
    public FilteringBehaviour filtering;
    final TradingDepotItemHandler itemHandler = new TradingDepotItemHandler(this);
    final LazyOptional<TradingDepotItemHandler> itemHandlerLazyOptional = LazyOptional.of(() -> this.itemHandler);
    TransportedItemStack offer;
    List<ItemStack> result = new ArrayList<ItemStack>();
    List<TransportedItemStack> incoming = new ArrayList<TransportedItemStack>();
    VersionedInventoryTrackerBehaviour invVersionTracker;
    boolean pruneEmptyStacksNextTick = false;

    public TradingDepotBehaviour(SmartBlockEntity be) {
        super(be);
    }

    public void tick() {
        super.tick();
        Level world = this.blockEntity.m_58904_();
        if (world == null) {
            return;
        }
        if (this.pruneEmptyStacksNextTick) {
            this.result = new ArrayList<ItemStack>(this.result.stream().filter(stack -> !stack.m_41619_()).toList());
            this.pruneEmptyStacksNextTick = false;
        }
        Iterator<TransportedItemStack> iterator = this.incoming.iterator();
        while (iterator.hasNext()) {
            TransportedItemStack ts = iterator.next();
            if (!this.tick(ts) || world.f_46443_ && !this.blockEntity.isVirtual()) continue;
            if (this.offer == null) {
                this.offer = ts;
            } else if (!ItemHelper.canItemStackAmountsStack((ItemStack)this.offer.stack, (ItemStack)ts.stack)) {
                Vec3 vec = VecHelper.getCenterOf((Vec3i)this.blockEntity.m_58899_());
                Containers.m_18992_((Level)this.blockEntity.m_58904_(), (double)vec.f_82479_, (double)(vec.f_82480_ + 0.5), (double)vec.f_82481_, (ItemStack)ts.stack);
            } else {
                this.offer.stack.m_41769_(ts.stack.m_41613_());
            }
            iterator.remove();
            this.blockEntity.notifyUpdate();
        }
        if (this.offer == null) {
            return;
        }
        this.tick(this.offer);
    }

    public void doPruneEmptyStacksNextTick() {
        this.pruneEmptyStacksNextTick = true;
    }

    protected boolean tick(TransportedItemStack input) {
        input.prevBeltPosition = input.beltPosition;
        input.prevSideOffset = input.sideOffset;
        float diff = 0.5f - input.beltPosition;
        if (diff > 0.001953125f) {
            if (diff > 0.03125f && !BeltHelper.isItemUpright((ItemStack)input.stack)) {
                ++input.angle;
            }
            input.beltPosition += diff / 4.0f;
        }
        return diff < 0.0625f;
    }

    public void addAdditionalBehaviours(List<BlockEntityBehaviour> behaviours) {
        behaviours.add((BlockEntityBehaviour)new DirectBeltInputBehaviour(this.blockEntity).allowingBeltFunnels().setInsertionHandler(this::tryInsertingFromSide));
        this.invVersionTracker = new VersionedInventoryTrackerBehaviour(this.blockEntity);
        behaviours.add((BlockEntityBehaviour)this.invVersionTracker);
    }

    private ItemStack tryInsertingFromSide(TransportedItemStack transportedStack, Direction side, boolean simulate) {
        ItemStack inserted = transportedStack.stack;
        int size = transportedStack.stack.m_41613_();
        transportedStack = transportedStack.copy();
        transportedStack.beltPosition = side.m_122434_().m_122478_() ? 0.5f : 0.0f;
        transportedStack.insertedFrom = side;
        transportedStack.prevSideOffset = transportedStack.sideOffset;
        transportedStack.prevBeltPosition = transportedStack.beltPosition;
        ItemStack remainder = this.insert(transportedStack, simulate);
        if (remainder.m_41613_() != size) {
            this.blockEntity.notifyUpdate();
        }
        return remainder;
    }

    public int getPresentStackSize() {
        return this.getOfferStack().m_41613_();
    }

    public int getRemainingSpace() {
        int cumulativeStackSize = this.getPresentStackSize();
        for (TransportedItemStack transportedItemStack : this.incoming) {
            cumulativeStackSize += transportedItemStack.stack.m_41613_();
        }
        return this.getOfferStack().m_41741_() - cumulativeStackSize;
    }

    public ItemStack insert(TransportedItemStack input, boolean simulate) {
        int remainingSpace = this.getRemainingSpace();
        ItemStack inserted = input.stack;
        if (remainingSpace <= 0) {
            return inserted;
        }
        if (this.offer != null && !this.offer.stack.m_41619_() && !ItemStack.m_150942_((ItemStack)this.offer.stack, (ItemStack)inserted)) {
            return inserted;
        }
        ItemStack returned = ItemStack.f_41583_;
        if (remainingSpace < inserted.m_41613_()) {
            returned = ItemHandlerHelper.copyStackWithSize((ItemStack)input.stack, (int)(inserted.m_41613_() - remainingSpace));
            if (!simulate) {
                TransportedItemStack copy = input.copy();
                copy.stack.m_41764_(remainingSpace);
                if (this.offer != null && !this.offer.stack.m_41619_()) {
                    this.incoming.add(copy);
                } else {
                    this.offer = copy;
                }
            }
        } else if (!simulate) {
            if (this.offer != null && !this.offer.stack.m_41619_()) {
                this.incoming.add(input);
            } else {
                this.offer = input;
            }
        }
        return returned;
    }

    public boolean isEmpty() {
        return this.offer == null && this.isOutputEmpty();
    }

    public boolean isOutputEmpty() {
        for (ItemStack stack : this.result) {
            if (stack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public void destroy() {
        super.destroy();
        Level level = this.getWorld();
        BlockPos pos = this.getPos();
        ItemHelper.dropContents((Level)level, (BlockPos)pos, (IItemHandler)this.itemHandler);
    }

    public void unload() {
        if (this.itemHandlerLazyOptional != null) {
            this.itemHandlerLazyOptional.invalidate();
        }
    }

    public void read(CompoundTag nbt, boolean clientPacket) {
        this.offer = null;
        if (nbt.m_128441_("Input")) {
            this.offer = TransportedItemStack.read((CompoundTag)nbt.m_128469_("Input"));
        }
        int outputCount = nbt.m_128451_("OutputCount");
        this.result = new ArrayList<ItemStack>(outputCount);
        for (int i = 0; i < outputCount; ++i) {
            this.result.add(ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Output" + i)));
        }
        ListTag list = nbt.m_128437_("Incoming", 10);
        this.incoming = NBTHelper.readCompoundList((ListTag)list, TransportedItemStack::read);
    }

    public void write(CompoundTag nbt, boolean clientPacket) {
        if (this.offer != null) {
            nbt.m_128365_("Input", (Tag)this.offer.serializeNBT());
        }
        nbt.m_128405_("OutputCount", this.result.size());
        for (int i = 0; i < this.result.size(); ++i) {
            nbt.m_128365_("Output" + i, (Tag)this.result.get(i).m_41739_(new CompoundTag()));
        }
        if (!this.incoming.isEmpty()) {
            nbt.m_128365_("Incoming", (Tag)NBTHelper.writeCompoundList(this.incoming, TransportedItemStack::serializeNBT));
        }
    }

    public LazyOptional<TradingDepotItemHandler> getItemHandler() {
        return this.itemHandlerLazyOptional;
    }

    public ItemStack getOfferStack() {
        return this.offer == null ? ItemStack.f_41583_ : this.offer.stack;
    }

    public void setOfferStack(TransportedItemStack input) {
        this.offer = input;
    }

    @Override
    public void setOfferStack(ItemStack input) {
        if (this.offer != null) {
            this.offer.stack = input;
        } else {
            this.offer = new TransportedItemStack(input);
        }
    }

    public void removeOfferStack() {
        this.offer = null;
    }

    public BehaviourType<?> getType() {
        return TYPE;
    }

    public void combineOutputs() {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (ItemStack stack : this.result) {
            for (ItemStack other : result) {
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)other)) continue;
                int newCount = Math.min(other.m_41613_() + stack.m_41613_(), other.m_41741_());
                int filledCount = newCount - other.m_41613_();
                other.m_41764_(newCount);
                stack.m_41764_(stack.m_41613_() - filledCount);
            }
            if (stack.m_41619_()) continue;
            result.add(stack);
        }
        this.result = result;
    }

    public boolean canBeUsedFor(MerchantOffer offer) {
        return this.filtering.test(offer.m_45368_());
    }

    public void addContentsToTooltip(List<Component> tooltip) {
        TFLang.translate("tooltip.trading_depot.contents", new Object[0]).forGoggles(tooltip);
        if (this.offer != null && !this.offer.stack.m_41619_()) {
            TFLang.translate("tooltip.trading_depot.contents.input", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
            TFLang.itemStack(this.offer.stack).style(ChatFormatting.GRAY).forGoggles(tooltip, 2);
        }
        if (!this.result.isEmpty()) {
            TFLang.translate("tooltip.trading_depot.contents.output", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
            for (ItemStack stack : this.result) {
                TFLang.itemStack(stack).style(ChatFormatting.GRAY).forGoggles(tooltip, 2);
            }
        }
    }

    @Override
    public List<ItemStack> getResults() {
        return this.result;
    }

    public void invalidate() {
        this.itemHandlerLazyOptional.invalidate();
    }

    public void resetInv() {
        this.invVersionTracker.reset();
    }

    @Override
    public TransportedItemStack getOffer() {
        return this.offer;
    }

    @Override
    public List<TransportedItemStack> getIncoming() {
        return this.incoming;
    }

    public TradingDepotItemHandler getRealItemHandler() {
        return this.itemHandler;
    }

    public void spinOfferOrSomething() {
        this.offer.angle = this.offer.angle + (int)((Math.random() * 10.0 + 10.0) * (double)(Math.random() > 0.5 ? -1 : 1));
    }
}

