/*
 * Decompiled with CFR 0.152.
 */
package com.github.kay9.dragonmounts;

import com.github.kay9.dragonmounts.DMLConfig;
import com.github.kay9.dragonmounts.DMLRegistry;
import com.github.kay9.dragonmounts.client.DragonEggModel;
import com.github.kay9.dragonmounts.client.DragonModel;
import com.github.kay9.dragonmounts.client.DragonRenderer;
import com.github.kay9.dragonmounts.client.KeyMappings;
import com.github.kay9.dragonmounts.client.MountControlsMessenger;
import com.github.kay9.dragonmounts.data.CrossBreedingManager;
import com.github.kay9.dragonmounts.data.model.DragonModelPropertiesListener;
import com.github.kay9.dragonmounts.dragon.DragonSpawnEgg;
import com.github.kay9.dragonmounts.dragon.TameableDragon;
import com.github.kay9.dragonmounts.dragon.breed.BreedRegistry;
import com.github.kay9.dragonmounts.dragon.breed.DragonBreed;
import com.github.kay9.dragonmounts.dragon.egg.HatchableEggBlock;
import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.TriConsumer;

public class DragonMountsLegacy {
    public static final String MOD_ID = "dragonmounts";
    public static final Logger LOG = LogManager.getLogger((String)"dragonmounts");

    public static ResourceLocation id(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    static void registerRenderers() {
        EntityRenderers.m_174036_((EntityType)((EntityType)DMLRegistry.DRAGON.get()), DragonRenderer::new);
        ForgeHooksClient.registerLayerDefinition((ModelLayerLocation)DragonRenderer.MODEL_LOCATION, () -> DragonModel.createBodyLayer(DragonModel.Properties.STANDARD));
    }

    static void registerEggModelLoader(BiConsumer<String, IGeometryLoader<DragonEggModel>> registrar) {
        registrar.accept("dragon_egg", DragonEggModel.Loader.INSTANCE);
    }

    static void registerItemColors(ItemColors colors) {
        colors.m_92689_(DragonSpawnEgg::getColor, new ItemLike[]{(ItemLike)DMLRegistry.SPAWN_EGG.get()});
    }

    static void registerReloadListenersEarly() {
        if (Minecraft.m_91087_() != null) {
            ((ReloadableResourceManager)Minecraft.m_91087_().m_91098_()).m_7217_((PreparableReloadListener)DragonModelPropertiesListener.INSTANCE);
        }
    }

    static void registerKeyBindings(Consumer<KeyMapping> registrar) {
        KeyMappings.registerKeybinds(registrar);
    }

    static void registerReloadListeners(Consumer<PreparableReloadListener> registrar) {
        registrar.accept((PreparableReloadListener)CrossBreedingManager.INSTANCE);
    }

    static void registerDatapacks(TriConsumer<ResourceKey<Registry<DragonBreed>>, Codec<DragonBreed>, Codec<DragonBreed>> registrar) {
        registrar.accept(BreedRegistry.REGISTRY_KEY, DragonBreed.CODEC, DragonBreed.NETWORK_CODEC);
    }

    static void registerCreativeTabItems(ResourceKey<CreativeModeTab> tab, Consumer<ItemStack> registrar) {
        if (tab == CreativeModeTabs.f_256731_) {
            DragonSpawnEgg.populateTab(registrar);
        }
        if (tab == CreativeModeTabs.f_256791_) {
            HatchableEggBlock.populateTab(registrar);
        }
    }

    static void registerEntityAttributes(BiConsumer<EntityType<? extends LivingEntity>, AttributeSupplier> registrar) {
        registrar.accept((EntityType<? extends LivingEntity>)((EntityType)DMLRegistry.DRAGON.get()), TameableDragon.createAttributes().m_22265_());
    }

    static boolean overrideVanillaDragonEgg(Level level, BlockPos pos, Player player) {
        Optional end;
        if (DMLConfig.allowEggOverride() && level.m_8055_(pos).m_60713_(Blocks.f_50260_) && (end = BreedRegistry.registry(level.m_9598_()).m_123009_(DragonBreed.BuiltIn.END)).isPresent()) {
            if (level.f_46443_) {
                player.m_6674_(InteractionHand.MAIN_HAND);
            } else {
                BlockState state = (BlockState)((Block)DMLRegistry.EGG_BLOCK.get()).m_49966_().m_61124_((Property)HatchableEggBlock.HATCHING, (Comparable)Boolean.valueOf(true));
                HatchableEggBlock.place((ServerLevel)level, pos, state, (DragonBreed)end.get());
            }
            return true;
        }
        return false;
    }

    static void clientTick(boolean head) {
        if (!head) {
            MountControlsMessenger.tick();
        }
    }

    static void onKeyPress(int key, int action, int modifiers) {
        KeyMappings.handleKeyPress(key, action);
    }
}

