/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.client.render.layer;

import com.github.L_Ender.cataclysm.client.model.entity.Scylla_Model;
import com.github.L_Ender.cataclysm.client.render.entity.Scylla_Renderer;
import com.github.L_Ender.cataclysm.client.render.etc.LightningBoltData;
import com.github.L_Ender.cataclysm.client.render.etc.LightningRender;
import com.github.L_Ender.cataclysm.entity.InternalAnimationMonster.IABossMonsters.Scylla.Scylla_Entity;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

@OnlyIn(value=Dist.CLIENT)
public class Scylla_Anchor_Layer
extends RenderLayer<Scylla_Entity, Scylla_Model> {
    protected final EntityRenderDispatcher entityRenderDispatcher;
    private Map<UUID, LightningRender> lightningRenderMap = new HashMap<UUID, LightningRender>();
    private final RandomSource rnd = RandomSource.m_216327_();

    public Scylla_Anchor_Layer(Scylla_Renderer renderIn, EntityRendererProvider.Context context) {
        super((RenderLayerParent)renderIn);
        this.entityRenderDispatcher = context.m_174022_();
    }

    public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, Scylla_Entity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        this.renderAnchorLightning(matrixStackIn, bufferIn, entity, partialTicks);
    }

    private void renderAnchorLightning(PoseStack matrixStackIn, MultiBufferSource bufferIn, Scylla_Entity entity, float partialtick) {
        matrixStackIn.m_85836_();
        Vec3 offset = new Vec3(0.0, 0.0, 0.0);
        Vec3 ridePos = this.getAnchorPosition(offset);
        matrixStackIn.m_85837_(ridePos.f_82479_, ridePos.f_82480_, ridePos.f_82481_);
        if (entity.getChainAnchor()) {
            if (entity.getAttackState() == 7) {
                this.drawLightningAnchor(matrixStackIn, bufferIn, entity, 1.5f, 143, 241, 215, 6, 0.05f, partialtick);
            }
            if (entity.getAttackState() == 20 && entity.attackTicks > 6 && entity.attackTicks < 29) {
                this.drawLightningAnchor(matrixStackIn, bufferIn, entity, 4.0f, 143, 241, 215, 4, 0.1f, partialtick);
            }
        }
        matrixStackIn.m_85849_();
    }

    private void drawLightningAnchor(PoseStack matrixStackIn, MultiBufferSource bufferIn, Scylla_Entity entity, float xyz, int r, int g, int b, int seg, float size, float partialTicks) {
        matrixStackIn.m_85836_();
        double x = (this.rnd.m_188501_() - 0.5f) * xyz;
        double y = (this.rnd.m_188501_() - 0.5f) * xyz;
        double z = (this.rnd.m_188501_() - 0.5f) * xyz;
        LightningBoltData.BoltRenderInfo blueBoltData = new LightningBoltData.BoltRenderInfo(0.5f, 0.1f, 0.5f, 0.85f, new Vector4f((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, 0.8f), 0.1f);
        LightningBoltData bolt1 = new LightningBoltData(blueBoltData, Vec3.f_82478_, new Vec3(x, y, z), seg).size(size).lifespan(1).spawn(LightningBoltData.SpawnFunction.NO_DELAY).fade(LightningBoltData.FadeFunction.NONE);
        LightningRender lightningRender = this.getLightingRender(entity.m_20148_());
        if (!Minecraft.m_91087_().m_91104_()) {
            lightningRender.update((Object)entity, bolt1, partialTicks);
        }
        lightningRender.render(partialTicks, matrixStackIn, bufferIn);
        matrixStackIn.m_85849_();
        if (!entity.m_6084_() && this.lightningRenderMap.containsKey(entity.m_20148_())) {
            this.lightningRenderMap.remove(entity.m_20148_());
        }
    }

    private LightningRender getLightingRender(UUID uuid) {
        if (this.lightningRenderMap.get(uuid) == null) {
            this.lightningRenderMap.put(uuid, new LightningRender());
        }
        return this.lightningRenderMap.get(uuid);
    }

    public Vec3 getAnchorPosition(Vec3 offsetIn) {
        PoseStack translationStack = new PoseStack();
        translationStack.m_85836_();
        ((Scylla_Model)this.m_117386_()).translateChainAnchor(translationStack);
        Vector4f armOffsetVec = new Vector4f((float)offsetIn.f_82479_, (float)offsetIn.f_82480_, (float)offsetIn.f_82481_, 1.0f);
        armOffsetVec.mul((Matrix4fc)translationStack.m_85850_().m_252922_());
        Vec3 vec3 = new Vec3((double)armOffsetVec.x(), (double)armOffsetVec.y(), (double)armOffsetVec.z());
        translationStack.m_85849_();
        return vec3;
    }
}

