/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.shoppy.networking.packets;

import com.epherical.epherolib.networking.AbstractNetworking;
import com.epherical.shoppy.block.entity.AbstractTradingBlockEntity;
import com.epherical.shoppy.block.entity.BarteringBlockEntity;
import com.epherical.shoppy.block.entity.ShopBlockEntity;
import com.epherical.shoppy.menu.MenuOwner;
import com.epherical.shoppy.objects.Action;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public record SlotManipulation(int slot, Action action) {
    public static void handle(SlotManipulation slotManipulation, AbstractNetworking.Context<?> context) {
        ServerPlayer player = context.getPlayer();
        if (player != null) {
            player.m_20194_().execute(() -> {
                AbstractContainerMenu patt1128$temp = player.f_36096_;
                if (patt1128$temp instanceof MenuOwner) {
                    ShopBlockEntity blockEntity;
                    BarteringBlockEntity blockEntity2;
                    MenuOwner menu = (MenuOwner)patt1128$temp;
                    Container patt1202$temp = menu.getContainer();
                    if (patt1202$temp instanceof BarteringBlockEntity && (blockEntity2 = (BarteringBlockEntity)patt1202$temp).getOwner().equals(player.m_20148_())) {
                        switch (slotManipulation.action()) {
                            case INCREMENT: {
                                slotManipulation.handleIncrement(blockEntity2);
                                break;
                            }
                            case DECREMENT: {
                                slotManipulation.handleDecrement(blockEntity2);
                                break;
                            }
                            case INSERT_SLOT: {
                                slotManipulation.insertSingleSlot(player, blockEntity2);
                                break;
                            }
                            case INSERT_ALL: {
                                slotManipulation.insertAll(player, blockEntity2);
                                break;
                            }
                            case REMOVE_ALL: {
                                slotManipulation.removeAllSlots(player, blockEntity2);
                                break;
                            }
                            case REMOVE_STACK: {
                                slotManipulation.removeSingleSlot(player, blockEntity2);
                            }
                        }
                        return;
                    }
                    Container patt2101$temp = menu.getContainer();
                    if (patt2101$temp instanceof ShopBlockEntity && (blockEntity = (ShopBlockEntity)patt2101$temp).getOwner().equals(player.m_20148_())) {
                        switch (slotManipulation.action()) {
                            case INCREMENT: {
                                if (slotManipulation.slot != 1) break;
                                slotManipulation.abstractIncrement(blockEntity);
                                blockEntity.markUpdated();
                                break;
                            }
                            case DECREMENT: {
                                if (slotManipulation.slot != 1) break;
                                slotManipulation.abstractDecrement(blockEntity);
                                blockEntity.markUpdated();
                                break;
                            }
                            case INSERT_SLOT: {
                                slotManipulation.insertSingleSlotAbstract(player, blockEntity);
                                break;
                            }
                            case INSERT_ALL: {
                                slotManipulation.abstractInsertAll(player, blockEntity);
                                break;
                            }
                            case REMOVE_ALL: {
                                if (slotManipulation.slot != 0) break;
                                slotManipulation.abstractRemoveAllSlots(player, blockEntity);
                                blockEntity.markUpdated();
                                break;
                            }
                            case REMOVE_STACK: {
                                if (slotManipulation.slot != 0) break;
                                slotManipulation.abstractRemoveSingle(player, blockEntity);
                                blockEntity.markUpdated();
                            }
                        }
                        return;
                    }
                }
            });
        }
    }

    private void handleIncrement(BarteringBlockEntity blockEntity) {
        switch (this.slot()) {
            case 2: {
                blockEntity.getCurrency().m_41769_(1);
                break;
            }
            case 3: {
                this.abstractIncrement(blockEntity);
            }
        }
        blockEntity.markUpdated();
    }

    private void abstractIncrement(AbstractTradingBlockEntity blockEntity) {
        blockEntity.getSelling().m_41769_(1);
    }

    private void handleDecrement(BarteringBlockEntity blockEntity) {
        switch (this.slot()) {
            case 2: {
                if (blockEntity.getCurrency().m_41613_() <= 1) break;
                blockEntity.getCurrency().m_41774_(1);
                break;
            }
            case 3: {
                this.abstractDecrement(blockEntity);
            }
        }
        blockEntity.markUpdated();
    }

    private void abstractDecrement(AbstractTradingBlockEntity blockEntity) {
        if (blockEntity.getSelling().m_41613_() > 1) {
            blockEntity.getSelling().m_41774_(1);
        }
    }

    private void insertSingleSlot(ServerPlayer player, BarteringBlockEntity blockEntity) {
        this.insertSingleSlotAbstract(player, blockEntity);
    }

    private void insertSingleSlotAbstract(ServerPlayer player, AbstractTradingBlockEntity blockEntity) {
        int slotMatchingItem;
        if (this.slot == 0 && !blockEntity.getSelling().m_41619_() && blockEntity.remainingItemStorage() != 0 && (slotMatchingItem = player.m_150109_().m_36030_(blockEntity.getSelling())) != -1) {
            blockEntity.putItemIntoShop(player.m_150109_().m_8020_(slotMatchingItem));
        }
    }

    private void insertAll(ServerPlayer player, BarteringBlockEntity blockEntity) {
        this.abstractInsertAll(player, blockEntity);
    }

    private void abstractInsertAll(ServerPlayer player, AbstractTradingBlockEntity blockEntity) {
        if (this.slot == 0 && !blockEntity.getSelling().m_41619_() && blockEntity.remainingItemStorage() != 0) {
            for (ItemStack item : player.m_150109_().f_35974_) {
                if (item.m_41619_() || !ItemStack.m_150942_((ItemStack)item, (ItemStack)blockEntity.getSelling())) continue;
                blockEntity.putItemIntoShop(item);
            }
        }
    }

    private void removeSingleSlot(ServerPlayer player, BarteringBlockEntity blockEntity) {
        switch (this.slot) {
            case 0: {
                this.abstractRemoveSingle(player, blockEntity);
                break;
            }
            case 1: {
                blockEntity.emptyProfits(player);
            }
        }
        blockEntity.markUpdated();
    }

    private void abstractRemoveSingle(ServerPlayer player, AbstractTradingBlockEntity blockEntity) {
        blockEntity.emptyItemsToBeSold(player);
    }

    private void removeAllSlots(ServerPlayer player, BarteringBlockEntity blockEntity) {
        switch (this.slot) {
            case 0: {
                this.abstractRemoveAllSlots(player, blockEntity);
                break;
            }
            case 1: {
                while (blockEntity.emptyProfits(player)) {
                }
                break;
            }
        }
        blockEntity.markUpdated();
    }

    private void abstractRemoveAllSlots(ServerPlayer player, AbstractTradingBlockEntity blockEntity) {
        while (blockEntity.emptyItemsToBeSold(player)) {
        }
    }
}

