/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.shoppy.menu;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class DenseContainer
implements Container {
    private final int size;
    private final NonNullList<ItemStack> items;
    @Nullable
    private List<ContainerListener> listeners;

    public DenseContainer(int pSize) {
        this.size = pSize;
        this.items = NonNullList.m_122780_((int)pSize, (Object)ItemStack.f_41583_);
    }

    public DenseContainer(ItemStack ... pItems) {
        this.size = pItems.length;
        this.items = NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])pItems);
    }

    public void addListener(ContainerListener pListener) {
        if (this.listeners == null) {
            this.listeners = Lists.newArrayList();
        }
        this.listeners.add(pListener);
    }

    public void removeListener(ContainerListener pListener) {
        if (this.listeners != null) {
            this.listeners.remove(pListener);
        }
    }

    public ItemStack m_8020_(int pIndex) {
        return pIndex >= 0 && pIndex < this.items.size() ? (ItemStack)this.items.get(pIndex) : ItemStack.f_41583_;
    }

    public List<ItemStack> removeAllItems() {
        List<ItemStack> list = this.items.stream().filter(p_19197_ -> !p_19197_.m_41619_()).collect(Collectors.toList());
        this.m_6211_();
        return list;
    }

    public ItemStack m_7407_(int pIndex, int pCount) {
        ItemStack itemstack = ContainerHelper.m_18969_(this.items, (int)pIndex, (int)pCount);
        if (!itemstack.m_41619_()) {
            this.m_6596_();
        }
        return itemstack;
    }

    public ItemStack addItem(ItemStack pStack) {
        ItemStack itemstack = pStack.m_41777_();
        this.moveItemToOccupiedSlotsWithSameType(itemstack);
        if (itemstack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        this.moveItemToEmptySlots(itemstack);
        return itemstack.m_41619_() ? ItemStack.f_41583_ : itemstack;
    }

    public boolean canAddItem(ItemStack pStack) {
        boolean flag = false;
        for (ItemStack itemstack : this.items) {
            if (!itemstack.m_41619_() && (!ItemStack.m_150942_((ItemStack)itemstack, (ItemStack)pStack) || itemstack.m_41613_() >= itemstack.m_41741_())) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public ItemStack m_8016_(int pIndex) {
        ItemStack itemstack = (ItemStack)this.items.get(pIndex);
        if (itemstack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        this.items.set(pIndex, (Object)ItemStack.f_41583_);
        return itemstack;
    }

    public void m_6836_(int pIndex, ItemStack pStack) {
        this.items.set(pIndex, (Object)pStack);
        this.m_6596_();
    }

    public int m_6643_() {
        return this.size;
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public void m_6596_() {
        if (this.listeners != null) {
            for (ContainerListener containerlistener : this.listeners) {
                containerlistener.m_5757_((Container)this);
            }
        }
    }

    public boolean m_6542_(Player pPlayer) {
        return true;
    }

    public void m_6211_() {
        this.items.clear();
        this.m_6596_();
    }

    public void fillStackedContents(StackedContents pHelper) {
        for (ItemStack itemstack : this.items) {
            pHelper.m_36491_(itemstack);
        }
    }

    public String toString() {
        return this.items.stream().filter(p_19194_ -> !p_19194_.m_41619_()).collect(Collectors.toList()).toString();
    }

    private void moveItemToEmptySlots(ItemStack pStack) {
        for (int i = 0; i < this.size; ++i) {
            ItemStack itemstack = this.m_8020_(i);
            if (!itemstack.m_41619_()) continue;
            this.m_6836_(i, pStack.m_41777_());
            pStack.m_41764_(0);
            return;
        }
    }

    private void moveItemToOccupiedSlotsWithSameType(ItemStack pStack) {
        for (int i = 0; i < this.size; ++i) {
            ItemStack itemstack = this.m_8020_(i);
            if (!ItemStack.m_150942_((ItemStack)itemstack, (ItemStack)pStack)) continue;
            this.moveItemsBetweenStacks(pStack, itemstack);
            if (!pStack.m_41619_()) continue;
            return;
        }
    }

    private void moveItemsBetweenStacks(ItemStack pStack, ItemStack pOther) {
        int i = Math.min(this.m_6893_(), pOther.m_41741_());
        int j = Math.min(pStack.m_41613_(), i - pOther.m_41613_());
        if (j > 0) {
            pOther.m_41769_(j);
            pStack.m_41774_(j);
            this.m_6596_();
        }
    }

    public void fromTag(ListTag pContainerNbt) {
        this.m_6211_();
        for (int i = 0; i < pContainerNbt.size(); ++i) {
            ItemStack itemstack = ItemStack.m_41712_((CompoundTag)pContainerNbt.m_128728_(i));
            if (itemstack.m_41619_()) continue;
            this.addItem(itemstack);
        }
    }

    public ListTag createTag() {
        ListTag listtag = new ListTag();
        for (int i = 0; i < this.m_6643_(); ++i) {
            ItemStack itemstack = this.m_8020_(i);
            if (itemstack.m_41619_()) continue;
            listtag.add((Object)itemstack.m_41739_(new CompoundTag()));
        }
        return listtag;
    }
}

