/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.shoppy.block.entity;

import com.epherical.octoecon.api.user.UniqueUser;
import com.epherical.octoecon.api.user.User;
import com.epherical.shoppy.ShoppyMod;
import com.epherical.shoppy.block.entity.AbstractTradingBlockEntity;
import com.epherical.shoppy.menu.shopping.ShoppingMenu;
import com.epherical.shoppy.menu.shopping.ShoppingMenuOwner;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ShopBlockEntity
extends AbstractTradingBlockEntity {
    private static final Logger LOGGER = LogManager.getLogger();
    private boolean isBuyingFromPlayer = false;
    private int price = 0;
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int data) {
            return switch (data) {
                case 0 -> ShopBlockEntity.this.selling.m_41613_();
                case 1 -> ShopBlockEntity.this.storedSellingItems;
                case 2 -> ShopBlockEntity.this.price;
                case 3 -> {
                    if (ShopBlockEntity.this.isBuyingFromPlayer) {
                        yield 1;
                    }
                    yield 0;
                }
                default -> 0;
            };
        }

        public void m_8050_(int key, int value) {
            switch (key) {
                case 0: {
                    ShopBlockEntity.this.selling.m_41764_(value);
                    break;
                }
                case 1: {
                    ShopBlockEntity.this.storedSellingItems = value;
                    break;
                }
                case 2: {
                    ShopBlockEntity.this.price = value;
                    break;
                }
                case 3: {
                    ShopBlockEntity.this.isBuyingFromPlayer = value != 0;
                }
            }
        }

        public int m_6499_() {
            return 4;
        }
    };
    private static final int[] SLOTS_FOR_REST = new int[]{0};

    public ShopBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(ShoppyMod.SHOP_BLOCK_ENTITY, blockPos, blockState);
    }

    public ShopBlockEntity(BlockEntityType<?> blockEntity, BlockPos blockPos, BlockState blockState) {
        super(blockEntity, blockPos, blockState);
    }

    @Override
    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        this.isBuyingFromPlayer = compoundTag.m_128471_("buyingFromPlayer");
        this.price = compoundTag.m_128451_("price");
    }

    @Override
    protected void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        compoundTag.m_128379_("buyingFromPlayer", this.isBuyingFromPlayer);
        compoundTag.m_128405_("price", this.price);
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"block.shoppy.shop_block");
    }

    @Override
    public void m_6211_() {
        super.m_6211_();
        this.isBuyingFromPlayer = false;
        this.markUpdated();
    }

    @Override
    public boolean attemptPurchase(Player player, boolean creativeBlock) {
        ItemStack currencyInHand = ItemStack.f_41583_;
        try {
            Inventory inventory = player.m_150109_();
            currencyInHand = inventory.m_8020_(inventory.m_36030_(this.selling));
        }
        catch (ArrayIndexOutOfBoundsException inventory) {
            // empty catch block
        }
        ServerPlayer owner = this.f_58857_.m_7654_().m_6846_().m_11259_(this.owner);
        if (ShoppyMod.economyInstance == null) {
            MutableComponent noEconomy = Component.m_237115_((String)"shop.error.no_economy").m_6270_(ShoppyMod.ERROR_STYLE);
            player.m_213846_((Component)noEconomy);
            return false;
        }
        UniqueUser ownerUser = ShoppyMod.economyInstance.getOrCreatePlayerAccount(this.owner);
        UniqueUser user = ShoppyMod.economyInstance.getOrCreatePlayerAccount(player.m_20148_());
        if (user != null && ownerUser != null) {
            if (this.isBuyingFromPlayer) {
                if (creativeBlock && user.hasAmount(ShoppyMod.economyInstance.getDefaultCurrency(), (double)this.price)) {
                    return this.shopBuyFromPlayer(player, currencyInHand, ownerUser, user, (Player)owner, true);
                }
                if (ownerUser.hasAmount(ShoppyMod.economyInstance.getDefaultCurrency(), (double)this.price)) {
                    return this.shopBuyFromPlayer(player, currencyInHand, ownerUser, user, (Player)owner, false);
                }
                MutableComponent msg = Component.m_237115_((String)"shop.buying.not_enough_funds").m_6270_(ShoppyMod.ERROR_STYLE);
                player.m_213846_((Component)msg);
                return false;
            }
            if (creativeBlock && user.hasAmount(ShoppyMod.economyInstance.getDefaultCurrency(), (double)this.price)) {
                return this.shopSellToPlayer(player, currencyInHand, ownerUser, user, (Player)owner, true);
            }
            if (user.hasAmount(ShoppyMod.economyInstance.getDefaultCurrency(), (double)this.price)) {
                return this.shopSellToPlayer(player, currencyInHand, ownerUser, user, (Player)owner, false);
            }
            MutableComponent notEnoughMoney = Component.m_237115_((String)"shop.purchase.not_enough_money").m_6270_(ShoppyMod.ERROR_STYLE);
            player.m_213846_((Component)notEnoughMoney);
            return false;
        }
        MutableComponent noAccounts = Component.m_237115_((String)"shop.purchase.no_account").m_6270_(ShoppyMod.ERROR_STYLE);
        player.m_213846_((Component)noAccounts);
        LOGGER.error("Missing accounts for a shop transaction!! Player involved {}, UUIDs involved (PURCHASER {}) (OWNER {})", (Object)player.m_6302_(), (Object)player.m_20148_(), (Object)this.getOwner());
        LOGGER.error("This could be a result of an ShoppyMod.economyInstance implementation being unable to handle offline players?");
        return false;
    }

    private boolean shopSellToPlayer(Player player, ItemStack currencyInHand, UniqueUser ownerUser, UniqueUser playerShopping, Player owner, boolean creative) {
        int amountToGive = this.selling.m_41613_();
        if (amountToGive > this.storedSellingItems) {
            MutableComponent buyerMsg = Component.m_237115_((String)"shop.purchase.shop_empty").m_6270_(ShoppyMod.ERROR_STYLE);
            player.m_213846_((Component)buyerMsg);
            if (owner != null) {
                MutableComponent location = Component.m_237110_((String)"X: %s, Y: %s, Z: %s", (Object[])new Object[]{this.m_58899_().m_123341_(), this.m_58899_().m_123342_(), this.m_58899_().m_123343_()}).m_6270_(ShoppyMod.VARIABLE_STYLE);
                MutableComponent ownerMsg = Component.m_237110_((String)"shop.purchase.owner.shop_empty", (Object[])new Object[]{location}).m_6270_(ShoppyMod.CONSTANTS_STYLE);
                owner.m_213846_((Component)ownerMsg);
            }
            return false;
        }
        if (player.m_150109_().m_36062_() == -1) {
            MutableComponent component = Component.m_237115_((String)"common.purchase.full_inventory").m_6270_(ShoppyMod.ERROR_STYLE);
            player.m_213846_((Component)component);
            return false;
        }
        player.m_36356_(this.selling.m_41777_());
        if (creative) {
            playerShopping.withdrawMoney(ShoppyMod.economyInstance.getDefaultCurrency(), (double)this.price, "creative shop purchase");
        } else {
            playerShopping.sendTo((User)ownerUser, ShoppyMod.economyInstance.getDefaultCurrency(), (double)this.price);
            this.storedSellingItems -= amountToGive;
        }
        MutableComponent buyer = Component.m_237110_((String)"shop.purchase.transaction_success", (Object[])new Object[]{this.selling.m_41611_()}).m_6270_(ShoppyMod.APPROVAL_STYLE);
        player.m_213846_((Component)buyer);
        if (owner != null) {
            MutableComponent sellerMsg = Component.m_237110_((String)"shop.purchase.owner.transaction_success", (Object[])new Object[]{player.m_5446_(), this.selling.m_41611_()}).m_6270_(ShoppyMod.APPROVAL_STYLE);
            owner.m_213846_((Component)sellerMsg);
        }
        return true;
    }

    private boolean shopBuyFromPlayer(Player player, ItemStack currencyInHand, UniqueUser ownerUser, UniqueUser playerShopping, Player owner, boolean creative) {
        int moneyToGiveToPlayer = this.price;
        int storageLeft = this.remainingItemStorage() - this.selling.m_41613_();
        if (storageLeft < 0) {
            MutableComponent notEnoughSpace = Component.m_237115_((String)"shop.buying.full").m_6270_(ShoppyMod.ERROR_STYLE);
            player.m_213846_((Component)notEnoughSpace);
            return false;
        }
        if (currencyInHand.m_41619_() || !ItemStack.m_150942_((ItemStack)currencyInHand, (ItemStack)this.selling)) {
            MutableComponent notSameItem = Component.m_237115_((String)"shop.buying.no_held_item").m_6270_(ShoppyMod.ERROR_STYLE);
            player.m_213846_((Component)notSameItem);
            return false;
        }
        if (currencyInHand.m_41613_() < this.selling.m_41613_()) {
            MutableComponent notEnough = Component.m_237115_((String)"shop.buying.not_enough_items").m_6270_(ShoppyMod.ERROR_STYLE);
            player.m_213846_((Component)notEnough);
            return false;
        }
        currencyInHand.m_41774_(this.selling.m_41613_());
        if (creative) {
            playerShopping.depositMoney(ShoppyMod.economyInstance.getDefaultCurrency(), (double)moneyToGiveToPlayer, "creative mode shop");
        } else {
            ownerUser.sendTo((User)playerShopping, ShoppyMod.economyInstance.getDefaultCurrency(), (double)moneyToGiveToPlayer);
            this.storedSellingItems += this.selling.m_41613_();
        }
        Component priceComp = ShoppyMod.economyInstance.getDefaultCurrency().format((double)this.price);
        MutableComponent seller = Component.m_237110_((String)"shop.buying.player.success", (Object[])new Object[]{this.selling.m_41611_(), priceComp}).m_6270_(ShoppyMod.APPROVAL_STYLE);
        player.m_213846_((Component)seller);
        if (owner != null) {
            MutableComponent buyerMsg = Component.m_237110_((String)"shop.buying.owner.success", (Object[])new Object[]{player.m_5446_(), this.selling.m_41611_(), priceComp}).m_6270_(ShoppyMod.APPROVAL_STYLE);
            owner.m_213846_((Component)buyerMsg);
        }
        return true;
    }

    @Override
    public void sendInformationToOwner(Player player) {
        if (ShoppyMod.economyInstance == null) {
            MutableComponent noEconomy = Component.m_237115_((String)"shop.error.no_economy").m_6270_(ShoppyMod.ERROR_STYLE);
            player.m_213846_((Component)noEconomy);
            return;
        }
        MutableComponent type = this.isBuyingFromPlayer ? Component.m_237115_((String)"shop.status.buy").m_6270_(ShoppyMod.VARIABLE_STYLE) : Component.m_237115_((String)"shop.status.sell").m_6270_(ShoppyMod.VARIABLE_STYLE);
        MutableComponent items = Component.m_237113_((String)("" + this.storedSellingItems)).m_6270_(ShoppyMod.VARIABLE_STYLE);
        MutableComponent contents = Component.m_237110_((String)"shop.information.owner.contents", (Object[])new Object[]{type, this.selling.m_41611_(), items}).m_6270_(ShoppyMod.CONSTANTS_STYLE);
        player.m_213846_((Component)contents);
    }

    @Override
    public InteractionResult interactWithTradingBlock(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        Vec3 hit = blockHitResult.m_82450_().m_82546_(Vec3.m_82528_((Vec3i)blockPos));
        ItemStack item = player.m_21205_();
        if (ShoppyMod.economyInstance == null) {
            MutableComponent noEconomy = Component.m_237115_((String)"shop.error.no_economy").m_6270_(ShoppyMod.ERROR_STYLE);
            player.m_213846_((Component)noEconomy);
            return InteractionResult.CONSUME;
        }
        if (hit.m_7098_() > 0.5 && player.m_6047_()) {
            this.clearShop(blockHitResult);
            return InteractionResult.SUCCESS;
        }
        if (hit.m_7098_() > 0.5) {
            if (this.getSelling().m_41619_()) {
                this.addSellingItem(item.m_41777_());
                MutableComponent message = this.isBuyingFromPlayer ? Component.m_237110_((String)"shop.setup.owner.add_buying", (Object[])new Object[]{item.m_41611_()}).m_6270_(ShoppyMod.APPROVAL_STYLE) : Component.m_237110_((String)"shop.setup.owner.add_selling", (Object[])new Object[]{item.m_41611_()}).m_6270_(ShoppyMod.APPROVAL_STYLE);
                player.m_213846_((Component)message);
            } else if (ItemStack.m_150942_((ItemStack)item, (ItemStack)this.getSelling())) {
                this.putItemIntoShop(item);
            }
            return InteractionResult.SUCCESS;
        }
        if (hit.m_7098_() <= 0.5) {
            if (player.m_6047_()) {
                this.updateTradingStatus(!this.isBuyingFromPlayer);
                MutableComponent status = this.isBuyingFromPlayer ? Component.m_237115_((String)"shop.status.buying").m_6270_(ShoppyMod.VARIABLE_STYLE) : Component.m_237115_((String)"shop.status.selling").m_6270_(ShoppyMod.VARIABLE_STYLE);
                MutableComponent update = Component.m_237110_((String)"shop.status.update", (Object[])new Object[]{status}).m_6270_(ShoppyMod.CONSTANTS_STYLE);
                player.m_213846_((Component)update);
            } else {
                MutableComponent message = Component.m_237115_((String)"shop.pricing.owner.update").m_6270_(ShoppyMod.APPROVAL_STYLE);
                player.m_213846_((Component)message);
                ShoppyMod.awaitingResponse.put(player.m_20148_(), this);
            }
        }
        return InteractionResult.CONSUME;
    }

    @Override
    public void userLeftClickTradingBlock(BlockState blockState, Level level, BlockPos blockPos, Player player) {
        if (ShoppyMod.economyInstance == null) {
            MutableComponent noEconomy = Component.m_237115_((String)"shop.error.no_economy").m_6270_(ShoppyMod.ERROR_STYLE);
            player.m_213846_((Component)noEconomy);
            return;
        }
        MutableComponent amountBeingSold = Component.m_237113_((String)("x" + this.getSelling().m_41613_())).m_6270_(ShoppyMod.VARIABLE_STYLE);
        MutableComponent itemBeingSold = this.getSelling().m_41611_().m_6881_().m_130938_(style -> {
            style.m_131144_(new HoverEvent(HoverEvent.Action.f_130832_, (Object)new HoverEvent.ItemStackInfo(this.getSelling())));
            return style;
        });
        Component currencyAmount = ShoppyMod.economyInstance.getDefaultCurrency().format((double)this.price);
        MutableComponent component = this.isBuyingFromPlayer ? Component.m_237110_((String)"shop.information.user.buying_info", (Object[])new Object[]{amountBeingSold, itemBeingSold, currencyAmount}).m_6270_(ShoppyMod.CONSTANTS_STYLE) : Component.m_237110_((String)"shop.information.user.selling_info", (Object[])new Object[]{amountBeingSold, itemBeingSold, currencyAmount}).m_6270_(ShoppyMod.CONSTANTS_STYLE);
        player.m_213846_((Component)component);
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("buyingFromPlayer", this.isBuyingFromPlayer);
        tag.m_128365_("selling", (Tag)this.selling.m_41739_(new CompoundTag()));
        tag.m_128405_("price", this.price);
        tag.m_128362_("owner", this.owner);
        return tag;
    }

    public void updateTradingStatus(boolean value) {
        this.isBuyingFromPlayer = value;
        this.markUpdated();
    }

    public void setPrice(int price) {
        this.price = price;
        this.markUpdated();
    }

    public int getPrice() {
        return this.price;
    }

    public boolean isBuyingFromPlayer() {
        return this.isBuyingFromPlayer;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        if (this.getOwner().equals(player.m_20148_())) {
            return ShoppingMenuOwner.realContainer(i, inventory, this, this.data);
        }
        return ShoppingMenu.realContainer(i, inventory, this, this.data);
    }

    protected AbstractContainerMenu m_6555_(int i, Inventory inventory) {
        return null;
    }

    public int m_6643_() {
        return 2;
    }

    public boolean m_7983_() {
        return this.selling.m_41619_();
    }

    public ItemStack m_8020_(int pSlot) {
        ItemStack item;
        int take;
        if (pSlot == 0) {
            take = this.storedSellingItems;
            item = this.getSelling().m_41777_();
        } else if (pSlot == 1) {
            item = this.getSelling();
            take = this.getSelling().m_41613_();
        } else {
            return ItemStack.f_41583_;
        }
        item.m_41764_(take);
        return item;
    }

    public ItemStack m_7407_(int slot, int amountToRemove) {
        ItemStack item = this.m_8020_(slot);
        if (slot == 0) {
            this.storedSellingItems -= amountToRemove;
        }
        this.markUpdated();
        return item.m_41620_(amountToRemove);
    }

    public ItemStack m_8016_(int slot) {
        return this.m_7407_(slot, 64);
    }

    public void m_6836_(int slot, ItemStack stack) {
        if (slot == 1) {
            this.selling = stack;
        }
        this.markUpdated();
    }

    public boolean m_6542_(Player player) {
        return true;
    }

    public int[] m_7071_(Direction direction) {
        if (direction == Direction.DOWN) {
            return new int[0];
        }
        return SLOTS_FOR_REST;
    }

    public boolean m_7155_(int i, ItemStack itemStack, @Nullable Direction direction) {
        if (this.storedSellingItems <= this.maxStorage && i == 0 && direction != null && direction != Direction.DOWN && ItemStack.m_150942_((ItemStack)itemStack, (ItemStack)this.selling)) {
            this.m_6836_(i, itemStack);
            return true;
        }
        return false;
    }

    public boolean m_7157_(int i, ItemStack itemStack, Direction direction) {
        return false;
    }
}

